/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.util;

public class IndentStringBuilder {
    private final String indentStr;
    private final StringBuilder out;
    private int level = 0;
    private boolean indentAllowed = true;

    public IndentStringBuilder(String indentStr, StringBuilder out) {
        this.indentStr = indentStr;
        this.out = out;
    }

    public IndentStringBuilder() {
        this("\t", new StringBuilder());
    }

    public IndentStringBuilder append(String s) {
        this.appendIndent();
        this.out.append(s);
        return this;
    }

    public IndentStringBuilder appendIndent() {
        if (this.indentAllowed) {
            this.out.append(this.indentStr.repeat(this.level));
            this.indentAllowed = false;
        }
        return this;
    }

    public IndentStringBuilder newline() {
        this.out.append("\n");
        this.indentAllowed = true;
        return this;
    }

    public IndentStringBuilder increaseIndent() {
        ++this.level;
        return this;
    }

    public IndentStringBuilder decreaseIndent() {
        --this.level;
        return this;
    }

    public IndentStringBuilder backspace() {
        this.out.deleteCharAt(this.out.length() - 1);
        return this;
    }

    public String toString() {
        return this.out.toString();
    }
}

