/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2350;
import net.minecraft.class_3532;

public class QuatUtil {
    public static final Gson BASIC_PRETTY_GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    public static final class_2350[] DIRECTIONS_AND_NULL = new class_2350[]{class_2350.field_11033, class_2350.field_11036, class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039, null};

    public static int clamp(int n, int min, int max) {
        if (n < min) {
            return min;
        }
        return Math.min(n, max);
    }

    public static long clampL(long n, long min, long max) {
        if (n < min) {
            return min;
        }
        return Math.min(n, max);
    }

    public static float rangeRemap(float value, float low1, float high1, float low2, float high2) {
        float value2 = class_3532.method_15363((float)value, (float)low1, (float)high1);
        return low2 + (value2 - low1) * (high2 - low2) / (high1 - low1);
    }

    public static <K, T> Map<K, List<T>> collate(Iterable<T> things, Function<T, K> collator) {
        HashMap<Object, List> res = new HashMap<Object, List>();
        for (T thing : things) {
            res.computeIfAbsent(collator.apply(thing), __ -> new ArrayList()).add(thing);
        }
        return res;
    }

    public static <T> boolean allEqual(Iterable<T> things) {
        Iterator<T> iter = things.iterator();
        if (!iter.hasNext()) {
            return true;
        }
        T first = iter.next();
        if (!iter.hasNext()) {
            return true;
        }
        while (iter.hasNext()) {
            if (first.equals(iter.next())) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> List<T> sortedCopy(List<T> in) {
        ArrayList<T> result = new ArrayList<T>(in);
        Collections.sort(result);
        return result;
    }

    public static <T> List<T> sortedCopy(List<T> in, Comparator<? super T> comparator) {
        ArrayList<T> result = new ArrayList<T>(in);
        result.sort(comparator);
        return result;
    }

    public static <T, C extends Comparable<C>> List<T> sortedCopy(List<T> in, Function<? super T, ? extends C> keyExtractor) {
        return QuatUtil.sortedCopy(in, Comparator.comparing(keyExtractor));
    }
}

