/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftful.neo;

import agency.highlysuspect.quatlib.craftless.config.ConfigOpt;
import agency.highlysuspect.quatlib.craftless.config.ConfigSection;
import agency.highlysuspect.quatlib.craftless.config.SectOrOpt;
import agency.highlysuspect.quatlib.craftless.config.WritableConfig;
import agency.highlysuspect.quatlib.craftless.config.sn.Sn;
import agency.highlysuspect.quatlib.craftless.config.sn.SnParser;
import agency.highlysuspect.quatlib.craftless.config.sn.SnWriter;
import agency.highlysuspect.quatlib.craftless.failure.CtxChain;
import agency.highlysuspect.quatlib.craftless.failure.ReportedException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

public class NeoBackedConfig_V1
implements WritableConfig {
    private final Map<ConfigOpt<?>, ModConfigSpec.ConfigValue<?>> liveValues = new HashMap();
    private Map<ConfigOpt<?>, Object> parsedValues = new HashMap();
    private final CtxChain ctx;

    public NeoBackedConfig_V1(CtxChain ctx, ConfigSection schema, ModConfigSpec.Builder builder) {
        this.ctx = ctx;
        this.accept(schema, builder, true);
    }

    private void accept(SectOrOpt item, ModConfigSpec.Builder builder, boolean root) {
        builder.comment(item.getComment().toArray(new String[0]));
        if (item instanceof ConfigSection) {
            ConfigSection sect = (ConfigSection)item;
            if (!root) {
                builder.push(sect.getName());
            }
            for (SectOrOpt child : sect.getChildren()) {
                this.accept(child, builder, false);
            }
            if (!root) {
                builder.pop();
            }
        } else if (item instanceof ConfigOpt) {
            ConfigOpt opt = (ConfigOpt)item;
            this.acceptOpt(opt, builder);
        }
    }

    private <T> void acceptOpt(ConfigOpt<T> opt, ModConfigSpec.Builder builder) {
        if (this.nightConfigFriendly(opt)) {
            this.liveValues.put(opt, builder.define(opt.getName(), opt.getDefaultValue()));
        } else {
            String writtenDef = new SnWriter().write(opt.write(opt.getDefaultValue()));
            this.liveValues.put(opt, builder.define(opt.getName(), (Object)writtenDef));
        }
    }

    @Override
    public <T> T get(ConfigOpt<T> opt) {
        return (T)this.parsedValues.computeIfAbsent(opt, this::getFresh);
    }

    @Override
    public void modify(Consumer<WritableConfig.Handle> modifier) {
        final HashSet changed = new HashSet();
        modifier.accept(new WritableConfig.Handle(){

            @Override
            public <T> WritableConfig.Handle set(ConfigOpt<T> opt, T value) {
                ModConfigSpec.ConfigValue<?> live = NeoBackedConfig_V1.this.liveValues.get(opt);
                NeoBackedConfig_V1.this.validateAndCorrectWithMyRules(opt, live, value, NeoBackedConfig_V1.this.ctxFor(live)).ifPresent(corrected -> {
                    NeoBackedConfig_V1.this.parsedValues.put(opt, corrected);
                    NeoBackedConfig_V1.this.setInForge(opt, live, corrected);
                    changed.add(live);
                });
                return this;
            }
        });
        changed.forEach(ModConfigSpec.ConfigValue::save);
    }

    private <T> T getFresh(ConfigOpt<T> opt) {
        ModConfigSpec.ConfigValue<?> live = this.liveValues.get(opt);
        return (T)this.getFreshIfValid(opt, live).orElseGet(opt::getDefaultValue);
    }

    private <T, U> Optional<T> getFreshIfValid(ConfigOpt<T> opt, ModConfigSpec.ConfigValue<U> live) {
        CtxChain ctx2 = this.ctxFor(live);
        return this.parseWithMyRules(opt, live, ctx2).flatMap(parsed -> this.validateAndCorrectWithMyRules(opt, live, parsed, ctx2));
    }

    private <T> boolean nightConfigFriendly(ConfigOpt<T> opt) {
        T def = opt.getDefaultValue();
        return def instanceof String || def instanceof Number || def instanceof Boolean;
    }

    private <T, U> void setInForge(ConfigOpt<T> opt, ModConfigSpec.ConfigValue<U> live, T val) {
        if (this.nightConfigFriendly(opt)) {
            live.set(val);
        } else {
            live.set((Object)new SnWriter().write(opt.write(val)));
        }
    }

    private <T, U> Optional<T> parseWithMyRules(ConfigOpt<T> opt, ModConfigSpec.ConfigValue<U> live, CtxChain ctx2) {
        try {
            Object parsed;
            if (this.nightConfigFriendly(opt)) {
                parsed = live.get();
            } else {
                String unparsed = (String)live.get();
                Sn<?> snParsed = new SnParser(unparsed).parseValue(ctx2);
                parsed = opt.parse(snParsed.view(ctx2), ctx2);
            }
            return Optional.of(parsed);
        }
        catch (ReportedException e) {
            return Optional.empty();
        }
    }

    private <T, U> Optional<T> validateAndCorrectWithMyRules(ConfigOpt<T> opt, ModConfigSpec.ConfigValue<U> live, T val, CtxChain ctx2) {
        try {
            T corrected = opt.correct(val, ctx2);
            opt.validate(corrected, ctx2);
            if (!Objects.equals(corrected, val)) {
                this.setInForge(opt, live, corrected);
            }
            return Optional.of(corrected);
        }
        catch (ReportedException e) {
            return Optional.empty();
        }
    }

    private CtxChain ctxFor(ModConfigSpec.ConfigValue<?> live) {
        CtxChain ctx2 = this.ctx;
        for (String pathSegment : live.getPath()) {
            ctx2 = ctx2.path(pathSegment);
        }
        return ctx2;
    }

    public void onExternalChange() {
        HashMap newParsed = new HashMap(this.parsedValues);
        this.liveValues.forEach((opt, live) -> this.getFreshIfValid((ConfigOpt)opt, (ModConfigSpec.ConfigValue)live).ifPresent(it -> newParsed.put((ConfigOpt<?>)opt, it)));
        this.parsedValues = newParsed;
    }

    public void registerConfigReloadListeners(IEventBus modBus, ModConfigSpec builtSpec) {
        modBus.addListener(ModConfigEvent.Loading.class, evt -> {
            if (evt.getConfig().getSpec() == builtSpec) {
                this.onExternalChange();
            }
        });
        modBus.addListener(ModConfigEvent.Reloading.class, evt -> {
            if (evt.getConfig().getSpec() == builtSpec) {
                this.onExternalChange();
            }
        });
    }

    public static NeoBackedConfig_V1 make(CtxChain ctx, ConfigSection schema, IEventBus modBus, ModContainer me) {
        return NeoBackedConfig_V1.make(ctx, schema, modBus, me, ModConfig.Type.COMMON);
    }

    public static NeoBackedConfig_V1 make(CtxChain ctx, ConfigSection schema, IEventBus modBus, ModContainer me, ModConfig.Type type) {
        ctx = ctx.detail("Config file at config/" + me.getModId() + "-" + type.extension() + ".toml");
        ModConfigSpec.Builder bob = new ModConfigSpec.Builder();
        NeoBackedConfig_V1 cfg = new NeoBackedConfig_V1(ctx, schema, bob);
        ModConfigSpec built = bob.build();
        me.registerConfig(type, (IConfigSpec)built);
        cfg.registerConfigReloadListeners(modBus, built);
        return cfg;
    }
}

