/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftful.neo;

import agency.highlysuspect.quatlib.craftful.QuatlibMc;
import agency.highlysuspect.quatlib.craftful.neo.AfterQuatlibEvent;
import agency.highlysuspect.quatlib.craftful.neo.NeoReg;
import agency.highlysuspect.quatlib.craftful.neo.client.AfterQuatlibClientEvent;
import agency.highlysuspect.quatlib.craftful.neo.event.NeoServerTickHandler;
import agency.highlysuspect.quatlib.craftless.QuatlibBase;
import agency.highlysuspect.quatlib.craftless.facet.Latch;
import agency.highlysuspect.quatlib.craftless.facet.Reg;
import agency.highlysuspect.quatlib.craftless.facet.RegType;
import agency.highlysuspect.quatlib.craftless.util.BlockEntityFactory;
import agency.highlysuspect.quatlib.craftless.util.MyMenuSupplier;
import agency.highlysuspect.quatlib.craftless.util.PhysicalLoader;
import agency.highlysuspect.quatlib.craftless.util.PhysicalSide;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.fml.loading.FMLEnvironment;

@Mod(value="modder_name_lib")
public class QuatlibNeoforge
extends QuatlibMc {
    public final IEventBus modBus;
    private final Map<Latch<? extends ItemLike>, DispenseItemBehavior> dispenseBehaviorsToRegister = new HashMap<Latch<? extends ItemLike>, DispenseItemBehavior>();
    private final NeoServerTickHandler neoServerTickHandler = new NeoServerTickHandler();

    public QuatlibNeoforge(IEventBus modBus) {
        super(FMLEnvironment.dist.isClient() ? PhysicalSide.CLIENT : PhysicalSide.DEDICATED_SERVER, PhysicalLoader.FORGE);
        this.modBus = modBus;
        modBus.register((Object)this);
    }

    @SubscribeEvent
    public void onConstruct(FMLConstructModEvent e) {
        e.enqueueWork(() -> {
            ModContainer me = ModLoadingContext.get().getActiveContainer();
            LOG.info("Posting AfterQuatlibEvent...", new Object[0]);
            ModLoader.postEventWrapContainerInModOrder((Event)new AfterQuatlibEvent());
            LOG.info("Done posting AfterQuatlibEvent!", new Object[0]);
            if (FMLEnvironment.dist == Dist.CLIENT) {
                LOG.info("Posting AfterQuatlibClientEvent...", new Object[0]);
                ModLoader.postEventWrapContainerInModOrder((Event)new AfterQuatlibClientEvent());
                LOG.info("Done posting AfterQuatlibClientEvent!", new Object[0]);
            }
            ModLoadingContext.get().setActiveContainer(me);
        });
    }

    @Override
    public Reg<?> createReg(RegType<?> type) {
        NeoReg reg = new NeoReg(this.convertRegType(type));
        this.modBus.register(reg);
        return reg;
    }

    @Override
    public void registerDispenserBehavior(Latch<? extends ItemLike> item, DispenseItemBehavior behavior) {
        this.dispenseBehaviorsToRegister.put(item, behavior);
    }

    @Override
    public <T extends BlockEntity> BlockEntityType<T> makeBlockEntityType(BlockEntityFactory<T> factory, Block ... blocks) {
        return new BlockEntityType(factory::create, blocks);
    }

    @Override
    public <T extends AbstractContainerMenu> MenuType<T> makeMenuType(MyMenuSupplier<T> supplier) {
        return new MenuType(supplier::create, FeatureFlagSet.of());
    }

    @Override
    public void addServerTicker(Consumer<MinecraftServer> ticker) {
        this.neoServerTickHandler.addTicker(ticker);
    }

    @Override
    public void removeServerTicker(Consumer<MinecraftServer> ticker) {
        this.neoServerTickHandler.removeTicker(ticker);
    }

    @Override
    public boolean isModLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    @SubscribeEvent
    void actuallyRegisterDispenserBehaviors(FMLCommonSetupEvent e) {
        e.enqueueWork(() -> {
            this.dispenseBehaviorsToRegister.forEach((handle, behavior) -> DispenserBlock.registerBehavior((ItemLike)((ItemLike)handle.get()), (DispenseItemBehavior)behavior));
            this.dispenseBehaviorsToRegister.clear();
        });
    }

    public static QuatlibNeoforge inst() {
        return (QuatlibNeoforge)Objects.requireNonNull(QuatlibBase.INST, "QuatlibNeoforge is null");
    }
}

