/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftful.neo.event;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class NeoServerTickHandler {
    private final Map<Consumer<MinecraftServer>, BusCompat> compats = new IdentityHashMap<Consumer<MinecraftServer>, BusCompat>();

    public void addTicker(Consumer<MinecraftServer> action) {
        BusCompat b = new BusCompat(action);
        this.compats.put(action, b);
        NeoForge.EVENT_BUS.register((Object)b);
    }

    public void removeTicker(Consumer<MinecraftServer> action) {
        BusCompat b = this.compats.remove(action);
        if (b != null) {
            NeoForge.EVENT_BUS.unregister((Object)b);
        }
    }

    private record BusCompat(Consumer<MinecraftServer> action) {
        @SubscribeEvent
        public void onTick(ServerTickEvent.Pre e) {
            this.action.accept(e.getServer());
        }
    }
}

