/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless;

import agency.highlysuspect.quatlib.craftless.Slf4jLogFacade;
import agency.highlysuspect.quatlib.craftless.bridge.ResourceLocationBridge;
import agency.highlysuspect.quatlib.craftless.facet.Id;
import agency.highlysuspect.quatlib.craftless.facet.Latch;
import agency.highlysuspect.quatlib.craftless.facet.Reg;
import agency.highlysuspect.quatlib.craftless.facet.RegType;
import agency.highlysuspect.quatlib.craftless.facet.dgen.DgenManager;
import agency.highlysuspect.quatlib.craftless.failure.FailureLogger;
import agency.highlysuspect.quatlib.craftless.failure.FailureRoot;
import agency.highlysuspect.quatlib.craftless.util.BlockEntityFactory;
import agency.highlysuspect.quatlib.craftless.util.LogFacade;
import agency.highlysuspect.quatlib.craftless.util.MyMenuSupplier;
import agency.highlysuspect.quatlib.craftless.util.PhysicalLoader;
import agency.highlysuspect.quatlib.craftless.util.PhysicalSide;
import agency.highlysuspect.quatlib.craftless.util.PhysicalVersion;
import agency.highlysuspect.quatlib.craftless.util.SharedConfigFileWatcher;
import java.util.Objects;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public abstract class QuatlibBase {
    public static final String MODID = "modder_name_lib";
    public static final String NAME = "ModderNameLib";
    public static final LogFacade LOG = new Slf4jLogFacade("ModderNameLib");
    public final PhysicalSide side;
    public final PhysicalLoader loader;
    public final PhysicalVersion version;
    public final DgenManager dgen = DgenManager.create();
    public final FailureRoot failures = new FailureRoot("ModderNameLib").addListener(new FailureLogger(LOG));
    public final SharedConfigFileWatcher watcher;
    protected static QuatlibBase INST;

    public QuatlibBase(PhysicalSide side, PhysicalLoader loader, PhysicalVersion version) {
        INST = this;
        this.side = side;
        this.loader = loader;
        this.version = version;
        this.watcher = this.makeSharedConfigFileWatcher();
    }

    protected abstract SharedConfigFileWatcher makeSharedConfigFileWatcher();

    public abstract ResourceLocationBridge<?> getResourceLocationBridge();

    public abstract Reg<?> createReg(RegType<?> var1);

    public abstract void registerDispenserBehavior(Latch<? extends ItemLike> var1, DispenseItemBehavior var2);

    public abstract <T extends BlockEntity> BlockEntityType<T> makeBlockEntityType(BlockEntityFactory<T> var1, Block ... var2);

    public abstract <T extends AbstractContainerMenu> MenuType<T> makeMenuType(MyMenuSupplier<T> var1);

    public abstract SoundEvent createVariableRangeSoundEvent(Id var1);

    public abstract boolean isModLoaded(String var1);

    public static QuatlibBase inst() {
        return Objects.requireNonNull(INST, "QuatlibBase is null");
    }
}

