/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.config.hdc;

import agency.highlysuspect.quatlib.craftless.QuatlibBase;
import agency.highlysuspect.quatlib.craftless.config.ConfigOpt;
import agency.highlysuspect.quatlib.craftless.config.ConfigSection;
import agency.highlysuspect.quatlib.craftless.config.MatchedUnparsedConfig;
import agency.highlysuspect.quatlib.craftless.config.MutableMapConfig;
import agency.highlysuspect.quatlib.craftless.config.ReadableConfig;
import agency.highlysuspect.quatlib.craftless.config.ValidatedConfig;
import agency.highlysuspect.quatlib.craftless.config.WritableConfig;
import agency.highlysuspect.quatlib.craftless.config.hdc.HalfDecentConfigWriter;
import agency.highlysuspect.quatlib.craftless.config.sn.SnMap;
import agency.highlysuspect.quatlib.craftless.config.sn.SnParser;
import agency.highlysuspect.quatlib.craftless.failure.CtxChain;
import agency.highlysuspect.quatlib.craftless.failure.ReportedException;
import agency.highlysuspect.quatlib.craftless.util.LogFacade;
import agency.highlysuspect.quatlib.craftless.util.SharedConfigFileWatcher;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class HalfDecentConfigFile
extends MutableMapConfig {
    private final CtxChain ctx;
    private final ConfigSection schema;
    private final Path path;
    private final LogFacade log;
    private final Executor background;
    private List<Consumer<ReadableConfig>> reloadHooks = new ArrayList<Consumer<ReadableConfig>>(1);
    long filewatcherDebounce = 0L;
    protected static final int FILEWATCHER_DEBOUNCE_MS = 500;
    long lastIngameSave = 0L;
    protected static final int SAVE_TIMEOUT_MS = 10000;

    public HalfDecentConfigFile(CtxChain ctx, ConfigSection schema, Path path, LogFacade log, Executor background) {
        this.ctx = ctx.detail("Config file at " + String.valueOf(path));
        this.schema = schema;
        this.path = path;
        this.log = log;
        this.background = background;
    }

    @Override
    public void modify(Consumer<WritableConfig.Handle> modifier) {
        super.modify(modifier);
        this.saveLater();
    }

    public void saveNow() {
        this.doSave(this.state);
    }

    public void saveLater() {
        this.log.info("Scheduling save of config file {}", this.path);
        IdentityHashMap stateClone = new IdentityHashMap(this.state);
        this.background.execute(() -> this.doSave(stateClone));
    }

    private void doSave(Map<ConfigOpt<?>, Object> theState) {
        String serializedConfig;
        this.log.info("Saving config file to {}", this.path);
        CtxChain ctx2 = this.ctx.detail("Problem saving config file");
        try {
            serializedConfig = new HalfDecentConfigWriter().writeTopLevel(this.schema, new MutableMapConfig(theState));
        }
        catch (Exception e) {
            throw ctx2.cause(e).detail("Failed to serialize config! This is a bug!").uncheckedReportError();
        }
        this.lastIngameSave = System.currentTimeMillis();
        try {
            Files.writeString(this.path, (CharSequence)serializedConfig, StandardCharsets.UTF_8, new OpenOption[0]);
            this.log.info("Saved successfully!", new Object[0]);
        }
        catch (Exception e) {
            throw ctx2.cause(e).detail("Failed to write config file to disk!").uncheckedReportError();
        }
    }

    public void load() {
        SnMap parsed;
        String read;
        this.log.info("Loading config file {}", this.path);
        CtxChain ctx2 = this.ctx.detail("Problem loading config file");
        if (Files.notExists(this.path, new LinkOption[0])) {
            this.log.info("Config file doesn't exist. Writing a new one and loading default options", new Object[0]);
            this.state = new IdentityHashMap();
            this.doSave(this.state);
            return;
        }
        try {
            read = Files.readString(this.path, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw ctx2.cause(e).detail("Failed to read config file at " + String.valueOf(this.path)).uncheckedReportError();
        }
        try {
            parsed = new SnParser(read).parseTopLevel(ctx2);
        }
        catch (ReportedException e) {
            this.log.warn("Aborting config load, unrecoverable parse error", new Object[0]);
            return;
        }
        MatchedUnparsedConfig matched = new MatchedUnparsedConfig(this.schema, parsed.view(ctx2));
        ValidatedConfig validated = matched.parseAndValidate();
        this.state = new IdentityHashMap(validated.toMap());
        this.log.info("Loaded {} options.", this.state.size());
        for (Consumer<ReadableConfig> hook : this.reloadHooks) {
            hook.accept(this);
        }
        this.saveLater();
    }

    public void watchForChanges() {
        QuatlibBase qlib = QuatlibBase.inst();
        if (qlib == null) {
            throw new IllegalStateException("watchForChanges before ModderNameLib is set up");
        }
        SharedConfigFileWatcher watcher = qlib.watcher;
        if (watcher == null) {
            throw new IllegalStateException("ModderNameLib SharedConfigFileWatcher is null");
        }
        watcher.watch(this.path, () -> {
            long now;
            long lastFilewatcherDebounce = this.filewatcherDebounce;
            this.filewatcherDebounce = now = System.currentTimeMillis();
            if (now - lastFilewatcherDebounce >= 500L) {
                if (now - this.lastIngameSave < 10000L) {
                    this.log.info("Only been {}ms since last save, ignoring change to {}", now - this.lastIngameSave, this.path.getFileName());
                } else {
                    this.load();
                }
            }
        });
    }

    public HalfDecentConfigFile addReloadHook(Consumer<ReadableConfig> hook) {
        this.reloadHooks.add(hook);
        return this;
    }

    public static HalfDecentConfigFile make(CtxChain ctx, ConfigSection schema, Path path, LogFacade log, Executor background) {
        ctx = ctx.detail("Config file at " + String.valueOf(path.getParent().getFileName()) + "/" + String.valueOf(path.getFileName()));
        HalfDecentConfigFile cfg = new HalfDecentConfigFile(ctx, schema, path, log, background);
        cfg.load();
        cfg.watchForChanges();
        return cfg;
    }
}

