/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.config.hdc;

import agency.highlysuspect.quatlib.craftless.config.ConfigOpt;
import agency.highlysuspect.quatlib.craftless.config.ConfigSection;
import agency.highlysuspect.quatlib.craftless.config.ReadableConfig;
import agency.highlysuspect.quatlib.craftless.config.SectOrOpt;
import agency.highlysuspect.quatlib.craftless.config.sn.Sn;
import agency.highlysuspect.quatlib.craftless.config.sn.SnWriter;
import agency.highlysuspect.quatlib.craftless.util.IndentStringBuilder;

public class HalfDecentConfigWriter
extends SnWriter {
    public String writeTopLevel(ConfigSection section, ReadableConfig state) {
        IndentStringBuilder out = new IndentStringBuilder();
        this.acceptRootSection(section, state, out);
        return out.toString();
    }

    public void accept(SectOrOpt item, ReadableConfig state, IndentStringBuilder out) {
        if (item instanceof ConfigSection) {
            ConfigSection section = (ConfigSection)item;
            this.acceptSection(section, state, out);
        } else if (item instanceof ConfigOpt) {
            ConfigOpt opt = (ConfigOpt)item;
            this.acceptOption(opt, state, out);
        }
    }

    protected void comment(SectOrOpt item, IndentStringBuilder out) {
        for (String comment : item.getComment()) {
            if (!comment.isEmpty()) {
                out.append("% " + comment);
            }
            out.newline();
        }
    }

    public void acceptRootSection(ConfigSection section, ReadableConfig state, IndentStringBuilder out) {
        this.comment(section, out);
        out.newline();
        for (SectOrOpt item : section.getChildren()) {
            this.accept(item, state, out);
            out.newline().newline();
        }
        out.backspace();
    }

    public void acceptSection(ConfigSection section, ReadableConfig state, IndentStringBuilder out) {
        this.comment(section, out);
        out.append(HalfDecentConfigWriter.escapeAndQuoteIfNeeded(section.getName())).append(" = {").newline().increaseIndent();
        for (SectOrOpt item : section.getChildren()) {
            this.accept(item, state, out);
            out.newline().newline();
        }
        out.backspace().backspace();
        out.decreaseIndent().newline().append("}");
    }

    public <T> void acceptOption(ConfigOpt<T> opt, ReadableConfig state, IndentStringBuilder out) {
        this.comment(opt, out);
        out.append(HalfDecentConfigWriter.escapeAndQuoteIfNeeded(opt.getName())).append(" = ");
        T item = state.get(opt);
        Sn<?> sn = opt.write(item);
        this.accept(sn, out);
    }
}

