/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.facet;

import agency.highlysuspect.quatlib.craftless.facet.FacetBucket;
import agency.highlysuspect.quatlib.craftless.facet.Latch;
import agency.highlysuspect.quatlib.craftless.facet.dgen.DgenHelper;
import agency.highlysuspect.quatlib.craftless.facet.facets.BlockEntityTypeFacetBuilder;
import agency.highlysuspect.quatlib.craftless.facet.facets.DispenserBehaviorFacetBuilder;
import agency.highlysuspect.quatlib.craftless.facet.facets.FacetBuilder;
import agency.highlysuspect.quatlib.craftless.facet.facets.LangFacetBuilder;
import agency.highlysuspect.quatlib.craftless.facet.facets.RegFacetBuilder;
import agency.highlysuspect.quatlib.craftless.facet.facets.SoundEventFacetBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public interface Gen {
    public void gen(Ctx var1, Consumer<Gen> var2);

    public static void run(Ctx ctx, Gen ... topLevelGens) {
        List<Gen> gensToRun = Arrays.asList(topLevelGens);
        while (!gensToRun.isEmpty()) {
            ArrayList<Gen> more = new ArrayList<Gen>();
            for (Gen gen : gensToRun) {
                gen.gen(ctx, more::add);
            }
            gensToRun = more;
        }
    }

    public static class Ctx {
        public final List<FacetBuilder> facetBuilders = new ArrayList<FacetBuilder>();
        @Nullable
        public final DgenHelper dgen;

        public Ctx(@Nullable DgenHelper dgen) {
            this.dgen = dgen;
        }

        public void buildFacets(FacetBuilder.BuildCtx ctx, FacetBucket bucket) {
            for (FacetBuilder builder : this.facetBuilders) {
                builder.build(ctx, bucket);
            }
            this.facetBuilders.clear();
        }

        public <T> T getService(Class<T> key) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Unknown service " + key.getName());
        }

        public <T extends FacetBuilder> T add(T facet) {
            this.facetBuilders.add(facet);
            return facet;
        }

        public RegFacetBuilder reg(Latch<?> latch, Supplier<?> thing) {
            return this.add(new RegFacetBuilder(latch, thing));
        }

        public <T extends BlockEntity> BlockEntityTypeFacetBuilder blockEntity(Latch<BlockEntityType<T>> latch) {
            return this.add(new BlockEntityTypeFacetBuilder(latch));
        }

        public DispenserBehaviorFacetBuilder dispenser(Latch<? extends Item> latch) {
            return this.add(new DispenserBehaviorFacetBuilder(latch));
        }

        public DispenserBehaviorFacetBuilder dispenser(Latch<? extends Item> latch, DispenseItemBehavior behavior) {
            return this.dispenser(latch).behavior(behavior);
        }

        public LangFacetBuilder lang(String file) {
            return this.add(new LangFacetBuilder(file));
        }

        public SoundEventFacetBuilder sound(Latch<SoundEvent> sound) {
            return this.add(new SoundEventFacetBuilder(sound));
        }
    }
}

