/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.facet;

import agency.highlysuspect.quatlib.craftless.facet.Id;
import agency.highlysuspect.quatlib.craftless.facet.Idable;
import agency.highlysuspect.quatlib.craftless.facet.LatchPool;
import agency.highlysuspect.quatlib.craftless.facet.RegType;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Latch<T>
implements Supplier<T>,
Idable {
    public final RegType<? super T> type;
    public final Id id;
    @Nullable
    private T thing;

    Latch(RegType<? super T> type, Id id, @Nullable T thing) {
        this.type = Objects.requireNonNull(type, "null type");
        this.id = Objects.requireNonNull(id, "null id");
        this.thing = thing;
    }

    @Deprecated(forRemoval=true)
    public static <T> Latch<T> open(RegType<? super T> type, Id id) {
        return LatchPool.INST.get(type, id);
    }

    @Override
    @NotNull
    public T get() {
        if (this.thing == null) {
            throw new IllegalStateException("tried to read from open latch: " + String.valueOf(this));
        }
        return this.thing;
    }

    public void shut(T registered) {
        if (this.thing != null) {
            throw new IllegalStateException("tried to shut latch twice: " + String.valueOf(this));
        }
        if (registered == null) {
            throw new IllegalArgumentException("tried to shut latch with null thing: " + String.valueOf(this));
        }
        this.thing = registered;
    }

    public <X extends T> Latch<X> downcast() {
        return this;
    }

    @Override
    public Id getId() {
        return this.id;
    }

    public String toString() {
        return String.valueOf(this.type) + "->" + String.valueOf(this.id) + " " + String.valueOf(this.thing == null ? "(open)" : this.thing);
    }
}

