/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.facet.dgen;

import agency.highlysuspect.quatlib.craftless.QuatlibBase;
import agency.highlysuspect.quatlib.craftless.facet.FileGenner;
import agency.highlysuspect.quatlib.craftless.util.PhysicalVersion;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class DgenHelper
implements FileGenner {
    public final String modid;
    private final String propNameBase;
    public final Set<PhysicalVersion> supportedVersions;

    public DgenHelper(String modid) {
        this.modid = modid;
        this.propNameBase = "quatlib.dgen." + modid;
        this.supportedVersions = Arrays.stream(System.getProperty(this.propNameBase + ".versions", "").split(";")).map(String::trim).filter(s -> !s.isEmpty()).map(PhysicalVersion::parse).collect(Collectors.toSet());
        if (this.supportedVersions.isEmpty()) {
            throw new IllegalStateException("Mod " + modid + " doesn't seem to have any supported versions");
        }
    }

    @Override
    public void writeFile(@Nullable PhysicalVersion ver, String subpath, String toWrite) {
        Object propName = ver == null ? this.propNameBase : this.propNameBase + "." + String.valueOf((Object)ver);
        String prop = System.getProperty((String)propName);
        if (prop == null) {
            throw new IllegalArgumentException("Can't find system property " + (String)propName);
        }
        Path path = Paths.get(prop, new String[0]).resolve(subpath);
        try {
            QuatlibBase.LOG.info("Writing to file {}", path);
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.writeString(path, (CharSequence)toWrite, StandardCharsets.UTF_8, new OpenOption[0]);
            } else if (Files.exists(path, new LinkOption[0]) && !Files.readString(path).equals(toWrite)) {
                Files.writeString(path, (CharSequence)toWrite, StandardCharsets.UTF_8, new OpenOption[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("failed to write file to " + String.valueOf(path), e);
        }
    }
}

