/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.failure;

import agency.highlysuspect.quatlib.craftless.failure.FailureRoot;
import agency.highlysuspect.quatlib.craftless.failure.ReportedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface CtxChain {
    @Nullable
    public CtxChain getParent();

    public CtxChain detail(String var1);

    public CtxChain cause(Throwable var1);

    public CtxChain path(String var1);

    public void reportWarning();

    public ReportedException reportError();

    default public void sneakyReportError() {
        this.reportError();
    }

    default public RuntimeException uncheckedReportError() {
        this.reportError();
        CtxChain ctxChain = this;
        if (ctxChain instanceof ThrowableLink) {
            ThrowableLink t = (ThrowableLink)ctxChain;
            return new RuntimeException(t.cause.getMessage(), t.cause);
        }
        return new RuntimeException(this.thisSegmentString());
    }

    public String thisSegmentString();

    public static final class ThrowableLink
    extends Base
    implements CtxChain {
        public final Throwable cause;

        ThrowableLink(@Nullable CtxChain parent, @NotNull FailureRoot root, Throwable cause) {
            super(parent, root);
            this.cause = cause;
        }

        @Override
        public String thisSegmentString() {
            return this.cause.getMessage();
        }
    }

    public static final class PathLink
    extends Base
    implements CtxChain {
        public final String pathSegment;

        PathLink(@Nullable CtxChain parent, @NotNull FailureRoot root, String pathSegment) {
            super(parent, root);
            this.pathSegment = pathSegment;
        }

        @Override
        public String thisSegmentString() {
            return this.pathSegment;
        }

        @Override
        public String toString() {
            CtxChain ctxChain = this.getParent();
            if (ctxChain instanceof PathLink) {
                PathLink otherLink = (PathLink)ctxChain;
                return String.valueOf(otherLink) + "." + this.pathSegment;
            }
            return super.toString();
        }
    }

    public static final class StringLink
    extends Base
    implements CtxChain {
        public final String message;

        StringLink(@Nullable CtxChain parent, @NotNull FailureRoot root, String message) {
            super(parent, root);
            this.message = message;
        }

        @Override
        public String thisSegmentString() {
            return this.message;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class Base
    implements CtxChain {
        @Nullable
        CtxChain parent;
        @NotNull
        protected FailureRoot root;

        protected Base(@Nullable CtxChain parent, @NotNull FailureRoot root) {
            this.parent = parent;
            this.root = root;
        }

        @Override
        public CtxChain detail(String message) {
            return new StringLink(this, this.root, message);
        }

        @Override
        public CtxChain cause(Throwable cause) {
            return new ThrowableLink(this, this.root, cause);
        }

        @Override
        public CtxChain path(String pathSegment) {
            return new PathLink(this, this.root, pathSegment);
        }

        @Override
        public void reportWarning() {
            this.root.reportWarning(this);
        }

        @Override
        public ReportedException reportError() {
            this.root.reportError(this);
            return new ReportedException();
        }

        @Override
        @Nullable
        public CtxChain getParent() {
            return this.parent;
        }

        public String toString() {
            if (this.parent == null) {
                return this.thisSegmentString();
            }
            return String.valueOf(this.parent) + ", " + this.thisSegmentString();
        }
    }
}

