/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.failure;

import agency.highlysuspect.quatlib.craftless.failure.CtxChain;
import agency.highlysuspect.quatlib.craftless.failure.FailureListener;
import agency.highlysuspect.quatlib.craftless.failure.FailureLogger;
import agency.highlysuspect.quatlib.craftless.util.LogFacade;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class FailureRoot
implements FailureListener {
    private final List<FailureListener> listeners = new ArrayList<FailureListener>(2);
    private final ReentrantLock lock = new ReentrantLock();
    private final String name;

    public FailureRoot(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportWarning(CtxChain warning) {
        this.lock.lock();
        try {
            if (this.listeners.isEmpty()) {
                new FailureLogger(LogFacade.Sysout.INSTANCE).reportWarning(warning);
            } else {
                for (FailureListener listener : this.listeners) {
                    listener.reportWarning(warning);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportError(CtxChain error) {
        this.lock.lock();
        try {
            if (this.listeners.isEmpty()) {
                new FailureLogger(LogFacade.Sysout.INSTANCE).reportError(error);
            } else {
                for (FailureListener listener : this.listeners) {
                    listener.reportError(error);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public FailureRoot addListener(FailureListener listener) {
        this.lock.lock();
        try {
            this.listeners.add(listener);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public CtxChain context() {
        return new CtxChain.StringLink(null, this, this.name);
    }
}

