/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.util;

import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum TwelveDirection implements StringRepresentable
{
    UP_NORTH(Direction.UP, Direction.NORTH),
    UP_SOUTH(Direction.UP, Direction.SOUTH),
    UP_EAST(Direction.UP, Direction.EAST),
    UP_WEST(Direction.UP, Direction.WEST),
    NORTH(Direction.NORTH, null),
    SOUTH(Direction.SOUTH, null),
    EAST(Direction.EAST, null),
    WEST(Direction.WEST, null),
    DOWN_NORTH(Direction.DOWN, Direction.NORTH),
    DOWN_SOUTH(Direction.DOWN, Direction.SOUTH),
    DOWN_EAST(Direction.DOWN, Direction.EAST),
    DOWN_WEST(Direction.DOWN, Direction.WEST);

    @NotNull
    public final Direction primaryDirection;
    @Nullable
    public final Direction secondaryDirection;

    private TwelveDirection(Direction primaryDirection, Direction secondaryDirection) {
        this.primaryDirection = primaryDirection;
        this.secondaryDirection = secondaryDirection;
    }

    public static TwelveDirection get(Direction primary, @Nullable Direction secondary) {
        if (primary == Direction.UP && secondary == null) {
            return UP_NORTH;
        }
        if (primary == Direction.DOWN && secondary == null) {
            return DOWN_NORTH;
        }
        return switch (primary) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
            case Direction.UP -> {
                switch (secondary) {
                    case SOUTH: {
                        yield UP_SOUTH;
                    }
                    case EAST: {
                        yield UP_EAST;
                    }
                    case WEST: {
                        yield UP_WEST;
                    }
                }
                yield UP_NORTH;
            }
            case Direction.DOWN -> {
                switch (secondary) {
                    case SOUTH: {
                        yield DOWN_SOUTH;
                    }
                    case EAST: {
                        yield DOWN_EAST;
                    }
                    case WEST: {
                        yield DOWN_WEST;
                    }
                }
                yield DOWN_NORTH;
            }
        };
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

