/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftful.neo.client;

import agency.highlysuspect.quatlib.craftful.client.QuatlibClientMc;
import agency.highlysuspect.quatlib.craftful.neo.QuatlibNeoforge;
import agency.highlysuspect.quatlib.craftless.client.MyBlockEntityRendererProvider;
import agency.highlysuspect.quatlib.craftless.client.MyScreenConstructor;
import agency.highlysuspect.quatlib.craftless.facet.Latch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

@Mod(value="modder_name_lib", dist={Dist.CLIENT})
public class QuatlibClientNeoforge
extends QuatlibClientMc {
    protected final IEventBus modBus;
    private final List<MenuScreenEntry<?, ?>> menuScreensToRegister = new ArrayList();
    private final List<BlockEntityRendererEntry<?>> blockEntityRenderersToRegister = new ArrayList();
    private final Map<Latch<? extends Block>, RenderType> renderTypesToRegister = new HashMap<Latch<? extends Block>, RenderType>();

    public QuatlibClientNeoforge() {
        this.modBus = QuatlibNeoforge.inst().modBus;
        this.modBus.addListener(RegisterMenuScreensEvent.class, this::actuallyRegisterMenuScreens);
        this.modBus.addListener(EntityRenderersEvent.RegisterRenderers.class, this::actuallySetBlockEntityRenderers);
        this.modBus.addListener(FMLClientSetupEvent.class, this::actuallySetRenderTypes);
    }

    @Override
    public <T extends AbstractContainerMenu, U extends Screen> void registerMenuScreen(Latch<MenuType<T>> type, MyScreenConstructor<T, U> cons) {
        this.menuScreensToRegister.add(new MenuScreenEntry<T, U>(type, cons));
    }

    @Override
    public <T extends BlockEntity> void setBlockEntityRenderer(Latch<? extends BlockEntityType<T>> type, MyBlockEntityRendererProvider<? super T> renderer) {
        this.blockEntityRenderersToRegister.add(new BlockEntityRendererEntry<T>(type, this.adaptRendererProvider(renderer)));
    }

    @Override
    public void setRenderType(Latch<? extends Block> block, RenderType type) {
        this.renderTypesToRegister.put(block, type);
    }

    public void actuallyRegisterMenuScreens(RegisterMenuScreensEvent e) {
        this.menuScreensToRegister.forEach(it -> it.doIt(e));
    }

    private void actuallySetBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        this.blockEntityRenderersToRegister.forEach(entry -> entry.register(event));
    }

    private void actuallySetRenderTypes(FMLClientSetupEvent e) {
        e.enqueueWork(() -> this.renderTypesToRegister.forEach((handle, layer) -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)handle.get()), (RenderType)layer)));
    }

    public static QuatlibClientNeoforge inst() {
        return (QuatlibClientNeoforge)INST;
    }

    private record MenuScreenEntry<T extends AbstractContainerMenu, U extends Screen>(Latch<MenuType<T>> type, MyScreenConstructor<T, U> cons) {
        void doIt(RegisterMenuScreensEvent e) {
            e.register(this.type.get(), this.cons::create);
        }
    }

    private record BlockEntityRendererEntry<T extends BlockEntity>(Latch<? extends BlockEntityType<T>> type, BlockEntityRendererProvider<? super T> renderer) {
        private void register(EntityRenderersEvent.RegisterRenderers e) {
            e.registerBlockEntityRenderer(this.type.get(), this.renderer);
        }
    }
}

