/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftful.neo.client.model;

import agency.highlysuspect.quatlib.craftful.client.model.IQuadView;
import agency.highlysuspect.quatlib.craftful.client.model.SortedUvBounds;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.client.model.IQuadTransformer;

public class BakedQuadView
implements IQuadView<BakedQuad> {
    private final boolean swapRedAndBlue;
    private BakedQuad q;
    private static final int vertexStride = IQuadTransformer.STRIDE;
    private static final int vertexColorOffset = IQuadTransformer.COLOR;
    private static final int vertexUOffset = IQuadTransformer.UV0;
    private static final int vertexVOffset = vertexUOffset + 1;

    public BakedQuadView(boolean swapRedAndBlue) {
        this.swapRedAndBlue = swapRedAndBlue;
    }

    @Override
    public void fromVanilla(BakedQuad quad, Direction cullFace) {
        this.q = quad;
    }

    @Override
    public BakedQuad keep() {
        return this.q;
    }

    @Override
    public void enableWriting() {
        int[] vertsCopy = new int[this.q.getVertices().length];
        System.arraycopy(this.q.getVertices(), 0, vertsCopy, 0, vertsCopy.length);
        this.q = new BakedQuad(vertsCopy, this.q.getTintIndex(), this.q.getDirection(), this.q.getSprite(), this.q.isShade());
    }

    @Override
    public int getTintIndex() {
        return this.q.getTintIndex();
    }

    @Override
    public void setTintAllVerts(int tint) {
        int[] verts = this.q.getVertices();
        if (this.swapRedAndBlue) {
            tint = (tint & 0xFF0000) >> 16 | (tint & 0xFF) << 16 | tint & 0xFF00FF00;
        }
        verts[BakedQuadView.vertexColorOffset] = tint;
        verts[BakedQuadView.vertexStride + BakedQuadView.vertexColorOffset] = tint;
        verts[2 * BakedQuadView.vertexStride + BakedQuadView.vertexColorOffset] = tint;
        verts[3 * BakedQuadView.vertexStride + BakedQuadView.vertexColorOffset] = tint;
    }

    @Override
    public float getU(int vert) {
        return Float.intBitsToFloat(this.q.getVertices()[vert * vertexStride + vertexUOffset]);
    }

    @Override
    public float getV(int vert) {
        return Float.intBitsToFloat(this.q.getVertices()[vert * vertexStride + vertexVOffset]);
    }

    @Override
    public void setUv(int vert, float u, float v) {
        int[] verts = this.q.getVertices();
        verts[vert * BakedQuadView.vertexStride + BakedQuadView.vertexUOffset] = Float.floatToRawIntBits(u);
        verts[vert * BakedQuadView.vertexStride + BakedQuadView.vertexVOffset] = Float.floatToRawIntBits(v);
    }

    @Override
    public void retexture(SortedUvBounds myBounds, TextureAtlasSprite from, TextureAtlasSprite to) {
        myBounds.retexture(this, from, to);
    }
}

