/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.config.sn;

import agency.highlysuspect.quatlib.craftless.config.sn.Sn;
import agency.highlysuspect.quatlib.craftless.config.sn.SnList;
import agency.highlysuspect.quatlib.craftless.config.sn.SnMap;
import agency.highlysuspect.quatlib.craftless.config.sn.SnStr;
import agency.highlysuspect.quatlib.craftless.util.IndentStringBuilder;

public class SnWriter {
    public String write(Sn<?> sn) {
        IndentStringBuilder out = new IndentStringBuilder();
        this.accept(sn, out);
        return out.toString();
    }

    public void accept(Sn<?> sn, IndentStringBuilder out) {
        if (sn instanceof SnList) {
            SnList snList = (SnList)sn;
            this.acceptList(snList, out);
        } else if (sn instanceof SnMap) {
            SnMap snMap = (SnMap)sn;
            this.acceptMap(snMap, out);
        } else if (sn instanceof SnStr) {
            SnStr snStr = (SnStr)sn;
            this.acceptStr(snStr, out);
        }
    }

    public void acceptList(SnList list, IndentStringBuilder out) {
        out.append("[").newline().increaseIndent();
        for (Sn child : list) {
            this.accept(child, out);
            out.newline();
        }
        out.backspace();
        out.decreaseIndent().newline().append("]");
    }

    public void acceptMap(SnMap map, IndentStringBuilder out) {
        out.append("{").newline().increaseIndent();
        map.forEach((key, value) -> {
            out.append(SnWriter.escapeAndQuoteIfNeeded(key));
            out.append(" = ");
            this.accept((Sn<?>)value, out);
            out.newline();
        });
        out.backspace();
        out.decreaseIndent().newline().append("}");
    }

    public void acceptStr(SnStr str, IndentStringBuilder out) {
        out.append(SnWriter.escapeAndQuoteIfNeeded(str.value()));
    }

    protected static boolean requireQuoting(int c) {
        return c == 10 || c == 9 || c == 92 || c == 34 || c == 61 || c == 123 || c == 125 || c == 91 || c == 93 || c == 44;
    }

    protected static boolean requireEscaping(int c) {
        return c == 10 || c == 9 || c == 92 || c == 34;
    }

    protected static boolean needsQuotes(String s) {
        return s.isEmpty() || s.trim().length() != s.length() || s.chars().anyMatch(SnWriter::requireQuoting);
    }

    protected static String escapeAndQuote(String s) {
        StringBuilder escaped = new StringBuilder("\"");
        s.chars().forEach(c -> {
            if (SnWriter.requireEscaping(c)) {
                escaped.append("\\");
            }
            if (c == 10) {
                escaped.append('n');
            } else if (c == 9) {
                escaped.append('t');
            } else {
                escaped.append((char)c);
            }
        });
        return escaped.append("\"").toString();
    }

    protected static String escapeAndQuoteIfNeeded(String s) {
        if (SnWriter.needsQuotes(s)) {
            return SnWriter.escapeAndQuote(s);
        }
        return s;
    }
}

