/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.util;

import agency.highlysuspect.quatlib.craftless.failure.CtxChain;
import agency.highlysuspect.quatlib.craftless.util.LogFacade;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Season1CrummyConfigUpgrader {
    private final LogFacade log;
    private final CtxChain ctx;
    protected final Pattern OOPS_ALL_HASHES = Pattern.compile("^#*$");
    protected final Pattern HASHHASH_STUFF_HASHHASH = Pattern.compile("^##(.*)##$");
    protected final Pattern KEY_COLON_VALUE = Pattern.compile("^(.*):(.*)$");

    public Season1CrummyConfigUpgrader(LogFacade log, CtxChain ctx) {
        this.log = log;
        this.ctx = ctx;
    }

    public Season1CrummyConfigUpgrader configureForPackages() {
        return this;
    }

    public void upgrade(Path from, Path to) {
        try {
            this.doUpgrade(from, to);
        }
        catch (Exception e) {
            throw this.ctx.cause(e).detail("Failed to upgrade old config file").uncheckedReportError();
        }
    }

    protected void doUpgrade(Path from, Path to) throws Exception {
        if (Files.notExists(from, new LinkOption[0])) {
            return;
        }
        this.log.info("Upgrading config file '{}' to the Season 2 format, putting the result in '{}'", from.getFileName(), to.getFileName());
        List<String> oldLines = Files.readAllLines(from, StandardCharsets.UTF_8);
        ArrayList<Object> newLines = new ArrayList<Object>();
        boolean wroteAnyHeader = false;
        for (String line : oldLines) {
            if (this.OOPS_ALL_HASHES.matcher(line).matches()) continue;
            Matcher hhshhM = this.HASHHASH_STUFF_HASHHASH.matcher(line);
            if (hhshhM.matches()) {
                if (wroteAnyHeader) {
                    newLines.add("}");
                }
                String sectionName = hhshhM.group(1);
                newLines.add(sectionName.trim() + " {");
                wroteAnyHeader = true;
                continue;
            }
            if (line.trim().startsWith("#")) continue;
            Matcher kcvM = this.KEY_COLON_VALUE.matcher(line);
            if (kcvM.matches()) {
                newLines.add(kcvM.group(1) + " = " + kcvM.group(2));
                continue;
            }
            newLines.add(line);
        }
        if (wroteAnyHeader) {
            newLines.add("}");
        }
        Files.write(to, newLines, StandardCharsets.UTF_8, new OpenOption[0]);
        Files.deleteIfExists(from);
        this.log.info("Upgraded config successfully.", new Object[0]);
    }
}

