/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftful.client.model;

import agency.highlysuspect.quatlib.craftful.client.model.IQuadView;
import agency.highlysuspect.quatlib.craftless.util.QuatUtil;
import net.minecraft.class_1058;
import net.minecraft.class_3532;

public class SortedUvBounds {
    float minU;
    float maxU;
    float minV;
    float maxV;

    public <Q> void initFrom(IQuadView<Q> quad) {
        float x0 = quad.getU(0);
        float x1 = quad.getU(1);
        float x2 = quad.getU(2);
        float u3 = quad.getU(3);
        this.minU = Math.min(Math.min(x0, x1), Math.min(x2, u3));
        this.maxU = Math.max(Math.max(x0, x1), Math.max(x2, u3));
        float v0 = quad.getV(0);
        float v1 = quad.getV(1);
        float v2 = quad.getV(2);
        float v3 = quad.getV(3);
        this.minV = Math.min(Math.min(v0, v1), Math.min(v2, v3));
        this.maxV = Math.max(Math.max(v0, v1), Math.max(v2, v3));
    }

    public boolean displaysSprite(class_1058 sprite) {
        return sprite.method_4594() <= this.minU && sprite.method_4577() >= this.maxU && sprite.method_4593() <= this.minV && sprite.method_4575() >= this.maxV;
    }

    public <Q> void retexture(IQuadView<Q> quad, class_1058 from, class_1058 to) {
        this.doRetexture(quad, from, to.method_4594(), to.method_4577(), to.method_4593(), to.method_4575());
    }

    public <Q> void prepareNormalizedSpriteBake(IQuadView<Q> quad, class_1058 from) {
        this.doRetexture(quad, from, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    private <Q> void doRetexture(IQuadView<Q> quad, class_1058 from, float toMinU, float toMaxU, float toMinV, float toMaxV) {
        float remappedMinU = QuatUtil.rangeRemap(this.minU, from.method_4594(), from.method_4577(), toMinU, toMaxU);
        float remappedMaxU = QuatUtil.rangeRemap(this.maxU, from.method_4594(), from.method_4577(), toMinU, toMaxU);
        float remappedMinV = QuatUtil.rangeRemap(this.minV, from.method_4593(), from.method_4575(), toMinV, toMaxV);
        float remappedMaxV = QuatUtil.rangeRemap(this.maxV, from.method_4593(), from.method_4575(), toMinV, toMaxV);
        for (int i = 0; i < 4; ++i) {
            quad.setUv(i, class_3532.method_15347((float)quad.getU(i), (float)this.minU) ? remappedMinU : remappedMaxU, class_3532.method_15347((float)quad.getV(i), (float)this.minV) ? remappedMinV : remappedMaxV);
        }
    }
}

