/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.config;

import agency.highlysuspect.quatlib.craftless.config.ConfigOpt;
import agency.highlysuspect.quatlib.craftless.config.ReadableConfig;
import agency.highlysuspect.quatlib.craftless.config.WritableConfig;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ConfigDiff
implements ReadableConfig,
WritableConfig,
WritableConfig.Handle {
    private final WritableConfig base;
    private final Map<ConfigOpt<?>, Object> changes = new IdentityHashMap();

    public ConfigDiff(WritableConfig base) {
        this.base = base;
    }

    @Override
    public <T> T get(ConfigOpt<T> opt) {
        Object changed = this.changes.get(opt);
        if (changed != null) {
            return (T)changed;
        }
        return this.base.get(opt);
    }

    @Override
    public void modify(Consumer<WritableConfig.Handle> modifier) {
        modifier.accept(this);
    }

    @Override
    public <T> WritableConfig.Handle set(ConfigOpt<T> opt, T value) {
        T underlying = this.base.get(opt);
        if (Objects.equals(value, underlying)) {
            this.changes.remove(opt);
        } else {
            this.changes.put(opt, value);
        }
        return this;
    }

    public int changeCount() {
        return this.changes.size();
    }

    public boolean isChanged(ConfigOpt<?> opt) {
        return this.changes.containsKey(opt);
    }

    public void forEachChange(ChangeConsumer c) {
        this.changes.forEach(c::acceptErased);
    }

    public void flushChanges() {
        this.base.modify(h -> this.forEachChange(h::set));
        this.changes.clear();
    }

    public static interface ChangeConsumer {
        public <T> void accept(ConfigOpt<T> var1, T var2);

        default public <T> void acceptErased(ConfigOpt<?> opt, Object value) {
            this.accept(opt, value);
        }
    }
}

