/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.facet;

import agency.highlysuspect.quatlib.craftless.facet.Idable;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class Id
implements Comparable<Id>,
Idable {
    public final String ns;
    public final String path;

    public Id(String ns, String path) {
        this.ns = Objects.requireNonNull(ns, () -> "null namespace; path is " + path);
        this.path = Objects.requireNonNull(path, () -> "null path; namespace is " + ns);
    }

    public static Id minecraft(String path) {
        return new Id("minecraft", path);
    }

    public static Id parse(String s) {
        int c = s.indexOf(58);
        if (c == -1) {
            return Id.minecraft(s);
        }
        return new Id(s.substring(0, c), s.substring(c + 1));
    }

    public String ns() {
        return this.ns;
    }

    public String path() {
        return this.path;
    }

    public Id mapPath(UnaryOperator<String> op) {
        return new Id(this.ns, (String)op.apply(this.path));
    }

    public Id prefixFolders(@NotNull String prefix) {
        Objects.requireNonNull(prefix, () -> "null prefix passed to prefixPath on " + String.valueOf(this));
        return new Id(this.ns, prefix.endsWith("/") ? prefix + this.path : prefix + "/" + this.path);
    }

    public Id formatPath(Object ... args) {
        return new Id(this.ns, String.format(this.path, args));
    }

    public String toLangKey(@NotNull String domain) {
        return domain + "." + this.ns + "." + this.path.replace('/', '.');
    }

    public String toSubtitleKey() {
        return this.ns + ".subtitle." + this.path.replace('/', '.');
    }

    public String toString() {
        return this.ns + ":" + this.path;
    }

    public String toStringOmitMinecraft() {
        return this.ns.equals("minecraft") ? this.path : this.toString();
    }

    @Override
    public Id getId() {
        return this;
    }

    @Override
    public int compareTo(@NotNull Id other) {
        int x = this.ns.compareTo(other.ns);
        if (x != 0) {
            return x;
        }
        return this.path.compareTo(other.path);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Id id = (Id)o;
        return this.ns.equals(id.ns) && this.path.equals(id.path);
    }

    public int hashCode() {
        return 31 * this.ns.hashCode() + this.path.hashCode();
    }
}

