/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.facet.facets;

import agency.highlysuspect.quatlib.craftless.QuatlibBase;
import agency.highlysuspect.quatlib.craftless.facet.FacetBucket;
import agency.highlysuspect.quatlib.craftless.facet.Latch;
import agency.highlysuspect.quatlib.craftless.facet.facets.FacetBuilder;
import agency.highlysuspect.quatlib.craftless.facet.facets.LangFacet;
import agency.highlysuspect.quatlib.craftless.facet.facets.RegFacet;
import agency.highlysuspect.quatlib.craftless.facet.facets.SoundEffectBuilder;
import agency.highlysuspect.quatlib.craftless.facet.facets.SoundEventFacet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_3414;
import org.jetbrains.annotations.Nullable;

public class SoundEventFacetBuilder
implements FacetBuilder {
    final Latch<class_3414> latch;
    Supplier<class_3414> creator;
    List<SoundEffectBuilder> effects = new ArrayList<SoundEffectBuilder>();
    @Nullable
    String subtitleKey;
    Map<String, String> subtitleValues = new HashMap<String, String>(4);

    public SoundEventFacetBuilder(Latch<class_3414> latch) {
        this.latch = Objects.requireNonNull(latch);
        this.creator = () -> QuatlibBase.inst().createVariableRangeSoundEvent(latch.id);
        this.subtitleKey = latch.id.toSubtitleKey();
    }

    public SoundEventFacetBuilder creator(Supplier<class_3414> creator) {
        this.creator = creator;
        return this;
    }

    public SoundEventFacetBuilder effects(SoundEffectBuilder ... effects) {
        this.effects.addAll(Arrays.asList(effects));
        return this;
    }

    public SoundEventFacetBuilder subtitleKey(@Nullable String subtitleKey) {
        this.subtitleKey = subtitleKey;
        return this;
    }

    public SoundEventFacetBuilder subtitle(String file, String value) {
        this.subtitleValues.put(file, value);
        return this;
    }

    public SoundEventFacetBuilder effect(String name) {
        SoundEffectBuilder e = new SoundEffectBuilder(name);
        this.effects.add(e);
        return this;
    }

    private SoundEffectBuilder lastEffect() {
        if (this.effects.isEmpty()) {
            throw new IllegalStateException("call effect() first");
        }
        return this.effects.get(this.effects.size() - 1);
    }

    public SoundEventFacetBuilder type(String type) {
        this.lastEffect().type(type);
        return this;
    }

    public SoundEventFacetBuilder volume(float volume) {
        this.lastEffect().volume(volume);
        return this;
    }

    public SoundEventFacetBuilder pitch(float pitch) {
        this.lastEffect().pitch(pitch);
        return this;
    }

    public SoundEventFacetBuilder volume(double volume) {
        this.lastEffect().volume(volume);
        return this;
    }

    public SoundEventFacetBuilder pitch(double pitch) {
        this.lastEffect().pitch(pitch);
        return this;
    }

    @Override
    public void build(FacetBuilder.BuildCtx ctx, FacetBucket facets) {
        facets.add(new RegFacet(this.latch, this.creator));
        if (ctx.dgen == null) {
            return;
        }
        if (this.subtitleKey != null) {
            this.subtitleValues.forEach((file, subtitleValue) -> facets.add(new LangFacet((String)file, this.subtitleKey, (String)subtitleValue)));
        }
        facets.add(new SoundEventFacet(this.latch.id, this.effects, this.subtitleKey));
    }
}

