/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.util;

import agency.highlysuspect.quatlib.craftless.util.LogFacade;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SharedConfigFileWatcher {
    final WatchService watcher;
    final Object lock = new Object();
    final Set<Path> watchedDirectories = new HashSet<Path>();
    final Map<String, Runnable> changeActionsByFilename = new HashMap<String, Runnable>();
    static Thread watcherThread;
    private final LogFacade log;

    public SharedConfigFileWatcher(LogFacade log) {
        WatchService theWatcher;
        this.log = log;
        try {
            theWatcher = FileSystems.getDefault().newWatchService();
        }
        catch (Exception e) {
            log.warn("ModderNameLib failed to make WatchService", e);
            theWatcher = null;
        }
        this.watcher = theWatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watch(Path path, Runnable onChangeAction) {
        Object object = this.lock;
        synchronized (object) {
            String filename;
            if (this.watcher == null) {
                this.log.warn("Can't watch {} for changes (my WatchService is null)", path);
                return;
            }
            Path dir = path.getParent();
            if (dir == null) {
                throw new IllegalArgumentException("can't watch root of filesystem, path " + String.valueOf(path));
            }
            if (!this.watchedDirectories.contains(dir)) {
                try {
                    dir.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
                }
                catch (Exception e) {
                    this.log.warn("Failed to register {} to WatchService", dir, e);
                    return;
                }
                this.watchedDirectories.add(dir);
            }
            if (this.changeActionsByFilename.containsKey(filename = path.getFileName().toString())) {
                this.log.warn("Already watching {}", path);
            } else {
                this.changeActionsByFilename.put(filename, onChangeAction);
                this.log.info("Watching {} for changes", path);
            }
            if (watcherThread == null) {
                watcherThread = new Thread(this::watchJob, "ModderNameLib Config Watcher");
                watcherThread.setPriority(1);
                watcherThread.setDaemon(true);
                watcherThread.start();
            }
        }
    }

    private void watchJob() {
        try {
            while (!Thread.interrupted()) {
                WatchKey key = this.watcher.take();
                if (!key.isValid()) continue;
                for (WatchEvent<?> event : key.pollEvents()) {
                    Path path;
                    Runnable action;
                    Object obj;
                    if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY || !((obj = event.context()) instanceof Path) || (action = this.changeActionsByFilename.get((path = (Path)obj).getFileName().toString())) == null) continue;
                    action.run();
                }
                key.reset();
            }
        }
        catch (Throwable e) {
            this.log.warn("ModderNameLib filewatcher thread crashed", e);
        }
    }
}

