/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;

public class SnocList<T>
extends AbstractCollection<T> {
    private static final SnocList<?> EMPTY = new SnocList();
    final SnocList<T> head;
    final T tail;
    final int sizeCache;
    final int hashCache;

    public SnocList(SnocList<T> head, T tail) {
        this.head = head;
        this.tail = tail;
        this.sizeCache = head.sizeCache + 1;
        this.hashCache = head.hashCache * 31 ^ tail.hashCode();
    }

    public SnocList() {
        this.head = null;
        this.tail = null;
        this.sizeCache = 0;
        this.hashCache = 0;
    }

    public static <T> SnocList<T> empty() {
        return EMPTY;
    }

    public SnocList<T> snoc(T elem) {
        return new SnocList<T>(this, elem);
    }

    @Override
    public int size() {
        return this.sizeCache;
    }

    public SnocList<T> head() {
        return this.head;
    }

    @Override
    public Iterator<T> iterator() {
        return new ForwardSnocerator(this);
    }

    public Iterator<T> revIterator() {
        return new ReverseSnocerator(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnocList<T> other = (SnocList<T>)o;
        if (other.sizeCache != this.sizeCache) {
            return false;
        }
        if (this.sizeCache == 0) {
            return true;
        }
        if (other.hashCache != this.hashCache) {
            return false;
        }
        SnocList<T> self = this;
        while (!self.isEmpty()) {
            T myTail = self.tail;
            T itTail = other.tail;
            if (!Objects.equals(myTail, itTail)) {
                return false;
            }
            self = self.head;
            other = other.head;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.hashCache;
    }

    @Override
    public String toString() {
        ArrayList<String> stringified = new ArrayList<String>(this.sizeCache);
        for (T thing : this) {
            stringified.add(thing.toString());
        }
        return String.join((CharSequence)".", stringified);
    }

    static class ForwardSnocerator<T>
    implements Iterator<T> {
        final SnocList<T> end;
        int steps;

        public ForwardSnocerator(SnocList<T> end) {
            this.end = end;
            this.steps = end.sizeCache - 1;
        }

        @Override
        public boolean hasNext() {
            return this.steps > -1;
        }

        @Override
        public T next() {
            SnocList<T> s = this.end;
            for (int i = 0; i < this.steps; ++i) {
                s = s.head;
            }
            --this.steps;
            return s.tail;
        }
    }

    static class ReverseSnocerator<T>
    implements Iterator<T> {
        SnocList<T> cursor;

        public ReverseSnocerator(SnocList<T> list) {
            this.cursor = list;
        }

        @Override
        public boolean hasNext() {
            return !this.cursor.isEmpty();
        }

        @Override
        public T next() {
            Object thing = this.cursor.tail;
            this.cursor = this.cursor.head;
            return thing;
        }
    }
}

