/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.torch_hit.handler;

import it.crystalnest.cobweb.api.item.ItemUtils;
import it.crystalnest.torch_hit.Constants;
import it.crystalnest.torch_hit.compat.SoulFired;
import it.crystalnest.torch_hit.config.ModConfig;
import it.crystalnest.torch_hit.platform.Services;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Repairable;
import org.jetbrains.annotations.Nullable;

public final class AttackHandler {
    private AttackHandler() {
    }

    public static void handle(Entity entity, Entity directEntity, LivingEntity target) {
        if (entity instanceof LivingEntity) {
            InteractionHand interactionHand;
            LivingEntity attacker = (LivingEntity)entity;
            if (entity.equals((Object)directEntity) && !entity.level().isClientSide && !entity.isSpectator() && AttackHandler.canAttack(attacker, target) && (interactionHand = AttackHandler.getInteractionHand(attacker)) != null && !target.fireImmune()) {
                boolean directHit;
                ItemStack item = attacker.getItemInHand(interactionHand);
                boolean bl = directHit = interactionHand == InteractionHand.MAIN_HAND;
                if (directHit || AttackHandler.isAllowedTool(attacker.getMainHandItem().getItem())) {
                    AttackHandler.attack(attacker, (Entity)target, item, directHit);
                }
            }
        }
    }

    private static void attack(LivingEntity attacker, Entity target, ItemStack item, boolean directHit) {
        AttackHandler.consumeItem(attacker, item, directHit, AttackHandler.torchHit(target, item, directHit ? ModConfig.getDirectHitDuration() : ModConfig.getIndirectHitDuration()));
    }

    private static void consumeItem(LivingEntity attacker, ItemStack item, boolean directHit, int seconds) {
        Player player;
        if (!(attacker instanceof Player) || !(player = (Player)attacker).isCreative()) {
            ItemStack tool;
            Object object;
            if ((AttackHandler.isCandle(item) && ModConfig.getConsumeCandle().booleanValue() || AttackHandler.isTorch(item) && ModConfig.getConsumeTorch().booleanValue()) && (directHit || ModConfig.getConsumeWithIndirectHits().booleanValue()) && (ModConfig.getConsumeWithoutFire().booleanValue() || seconds > 0)) {
                item.shrink(1);
            } else if (ModConfig.getIndirectHitToolDamage() > 0 && (object = attacker.getMainHandItem()) instanceof ItemStack && (tool = object).has(DataComponents.TOOL) && tool.has(DataComponents.REPAIRABLE) && tool.has(DataComponents.MAX_DAMAGE) && (object = tool.get(DataComponents.MAX_DAMAGE)) instanceof Integer) {
                Object tag;
                Repairable repairable;
                Integer durability = (Integer)object;
                object = tool.get(DataComponents.REPAIRABLE);
                if (object instanceof Repairable && (object = (repairable = (Repairable)object).items().unwrapKey()) instanceof Optional && ((Optional)(tag = object)).isPresent() && ((TagKey)((Optional)tag).get()).toString().equals(ItemTags.WOODEN_TOOL_MATERIALS.toString())) {
                    tool.hurtAndBreak((durability * ModConfig.getIndirectHitToolDamage() + 99) / 100, attacker, EquipmentSlot.MAINHAND);
                }
            }
        }
    }

    private static int torchHit(Entity target, ItemStack item, int defaultSeconds) {
        int seconds = AttackHandler.getFireSeconds(item, target, defaultSeconds);
        if (seconds > 0) {
            if (Services.PLATFORM.isModLoaded("soul_fire_d")) {
                SoulFired.setOnFire(item, target, seconds);
            } else {
                target.igniteForSeconds((float)seconds);
            }
        }
        return seconds;
    }

    private static int getFireSeconds(ItemStack item, Entity target, int seconds) {
        if (Math.random() * 100.0 < (double)ModConfig.getFireChance().intValue()) {
            if (Services.PLATFORM.isModLoaded("soul_fire_d")) {
                return seconds;
            }
            if (Constants.isSoulTorch(item)) {
                return target instanceof AbstractPiglin ? seconds * 2 : seconds + 2;
            }
            return seconds;
        }
        return 0;
    }

    private static boolean isAllowedTool(Item item) {
        return !ModConfig.getIndirectHitToolList().isEmpty() && ModConfig.getIndirectHitToolList().stream().anyMatch(toolType -> ItemUtils.getKey((Item)item).toString().matches(".*:([^_]+_)*" + toolType + "(_[^_]+)*"));
    }

    @Nullable
    private static InteractionHand getInteractionHand(LivingEntity attacker) {
        if (AttackHandler.isValidItem(attacker.getMainHandItem())) {
            return InteractionHand.MAIN_HAND;
        }
        if (AttackHandler.isValidItem(attacker.getOffhandItem())) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    private static boolean isValidItem(ItemStack item) {
        return AttackHandler.isTorch(item) || AttackHandler.isCandle(item);
    }

    private static boolean isTorch(ItemStack item) {
        return item.is(Items.TORCH) && ModConfig.getVanillaTorchesEnabled() != false || ModConfig.getExtraTorchItems().contains(ItemUtils.getKey((Item)item.getItem()).toString()) || Constants.isSoulTorch(item);
    }

    private static boolean isCandle(ItemStack item) {
        return ModConfig.getAllowCandles() != false && item.is(ItemTags.CANDLES);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean canAttack(LivingEntity attacker, LivingEntity target) {
        if (!(attacker instanceof Player)) {
            if (ModConfig.getFireFromMobs() == false) return false;
        }
        if (!attacker.canAttack(target)) return false;
        if (!(attacker instanceof Player)) return true;
        Player attackerPlayer = (Player)attacker;
        if (!(target instanceof Player)) return true;
        Player targetPlayer = (Player)target;
        if (!attackerPlayer.canHarmPlayer(targetPlayer)) return false;
        return true;
    }
}

