/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.torch_hit.handler;

import it.crystalnest.cobweb.api.item.ItemUtils;
import it.crystalnest.torch_hit.Constants;
import it.crystalnest.torch_hit.compat.SoulFired;
import it.crystalnest.torch_hit.config.ModConfig;
import it.crystalnest.torch_hit.platform.Services;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_1834;
import net.minecraft.class_3489;
import net.minecraft.class_5418;
import org.jetbrains.annotations.Nullable;

public final class AttackHandler {
    private AttackHandler() {
    }

    public static void handle(class_1297 entity, class_1297 directEntity, class_1309 target) {
        if (entity instanceof class_1309) {
            class_1268 interactionHand;
            class_1309 attacker = (class_1309)entity;
            if (entity.equals((Object)directEntity) && !entity.method_37908().field_9236 && !entity.method_7325() && AttackHandler.canAttack(attacker, target) && (interactionHand = AttackHandler.getInteractionHand(attacker)) != null && !target.method_5753()) {
                boolean directHit;
                class_1799 item = attacker.method_5998(interactionHand);
                boolean bl = directHit = interactionHand == class_1268.field_5808;
                if (directHit || AttackHandler.isAllowedTool(attacker.method_6047().method_7909())) {
                    AttackHandler.attack(attacker, (class_1297)target, item, directHit);
                }
            }
        }
    }

    private static void attack(class_1309 attacker, class_1297 target, class_1799 item, boolean directHit) {
        AttackHandler.consumeItem(attacker, item, directHit, AttackHandler.torchHit(target, item, directHit ? ModConfig.getDirectHitDuration() : ModConfig.getIndirectHitDuration()));
    }

    private static void consumeItem(class_1309 attacker, class_1799 item, boolean directHit, int seconds) {
        class_1657 player;
        if (!(attacker instanceof class_1657) || !(player = (class_1657)attacker).method_7337()) {
            if ((AttackHandler.isCandle(item) && ModConfig.getConsumeCandle().booleanValue() || AttackHandler.isTorch(item) && ModConfig.getConsumeTorch().booleanValue()) && (directHit || ModConfig.getConsumeWithIndirectHits().booleanValue()) && (ModConfig.getConsumeWithoutFire().booleanValue() || seconds > 0)) {
                item.method_7934(1);
            } else {
                class_1831 tieredItem;
                class_1792 class_17922 = attacker.method_6047().method_7909();
                if (class_17922 instanceof class_1831 && (tieredItem = (class_1831)class_17922).method_8022() == class_1834.field_8922 && ModConfig.getIndirectHitToolDamage() > 0) {
                    attacker.method_6047().method_7970((tieredItem.method_8022().method_8025() * ModConfig.getIndirectHitToolDamage() + 99) / 100, attacker, class_1304.field_6173);
                }
            }
        }
    }

    private static int torchHit(class_1297 target, class_1799 item, int defaultSeconds) {
        int seconds = AttackHandler.getFireSeconds(item, target, defaultSeconds);
        if (seconds > 0) {
            if (Services.PLATFORM.isModLoaded("soul_fire_d")) {
                SoulFired.setOnFire(item, target, seconds);
            } else {
                target.method_5639((float)seconds);
            }
        }
        return seconds;
    }

    private static int getFireSeconds(class_1799 item, class_1297 target, int seconds) {
        if (Math.random() * 100.0 < (double)ModConfig.getFireChance().intValue()) {
            if (Services.PLATFORM.isModLoaded("soul_fire_d")) {
                return seconds;
            }
            if (Constants.isSoulTorch(item)) {
                return target instanceof class_5418 ? seconds * 2 : seconds + 2;
            }
            return seconds;
        }
        return 0;
    }

    private static boolean isAllowedTool(class_1792 item) {
        return !ModConfig.getIndirectHitToolList().isEmpty() && ModConfig.getIndirectHitToolList().stream().anyMatch(toolType -> ItemUtils.getKey((class_1792)item).toString().matches(".*:([^_]+_)*" + toolType + "(_[^_]+)*"));
    }

    @Nullable
    private static class_1268 getInteractionHand(class_1309 attacker) {
        if (AttackHandler.isValidItem(attacker.method_6047())) {
            return class_1268.field_5808;
        }
        if (AttackHandler.isValidItem(attacker.method_6079())) {
            return class_1268.field_5810;
        }
        return null;
    }

    private static boolean isValidItem(class_1799 item) {
        return AttackHandler.isTorch(item) || AttackHandler.isCandle(item);
    }

    private static boolean isTorch(class_1799 item) {
        return item.method_31574(class_1802.field_8810) && ModConfig.getVanillaTorchesEnabled() != false || ModConfig.getExtraTorchItems().contains(ItemUtils.getKey((class_1792)item.method_7909()).toString()) || Constants.isSoulTorch(item);
    }

    private static boolean isCandle(class_1799 item) {
        return ModConfig.getAllowCandles() != false && item.method_31573(class_3489.field_26989);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean canAttack(class_1309 attacker, class_1309 target) {
        if (!(attacker instanceof class_1657)) {
            if (ModConfig.getFireFromMobs() == false) return false;
        }
        if (!attacker.method_18395(target)) return false;
        if (!(attacker instanceof class_1657)) return true;
        class_1657 attackerPlayer = (class_1657)attacker;
        if (!(target instanceof class_1657)) return true;
        class_1657 targetPlayer = (class_1657)target;
        if (!attackerPlayer.method_7256(targetPlayer)) return false;
        return true;
    }
}

