/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.torch_hit.config;

import it.crystalnest.cobweb.api.config.CommonConfig;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ModConfig
extends CommonConfig {
    public static final ModConfig CONFIG = (ModConfig)ModConfig.register((String)"torch_hit", ModConfig::new);
    private ModConfigSpec.IntValue directHitDuration;
    private ModConfigSpec.IntValue indirectHitDuration;
    private ModConfigSpec.ConfigValue<List<? extends String>> indirectHitToolList;
    private ModConfigSpec.IntValue indirectHitToolDamage;
    private ModConfigSpec.ConfigValue<List<? extends String>> extraTorchItems;
    private ModConfigSpec.ConfigValue<List<? extends String>> extraSoulTorchItems;
    private ModConfigSpec.BooleanValue vanillaTorchesEnabled;
    private ModConfigSpec.ConfigValue<Boolean> allowCandles;
    private ModConfigSpec.ConfigValue<Boolean> consumeCandle;
    private ModConfigSpec.BooleanValue consumeTorch;
    private ModConfigSpec.BooleanValue consumeWithoutFire;
    private ModConfigSpec.BooleanValue consumeWithIndirectHit;
    private ModConfigSpec.IntValue fireChance;
    private ModConfigSpec.BooleanValue fireFromMobs;

    private ModConfig(ModConfigSpec.Builder builder) {
        super(builder);
    }

    public static Integer getDirectHitDuration() {
        return (Integer)ModConfig.CONFIG.directHitDuration.get();
    }

    public static Integer getIndirectHitDuration() {
        return (Integer)ModConfig.CONFIG.indirectHitDuration.get();
    }

    public static List<? extends String> getIndirectHitToolList() {
        return (List)ModConfig.CONFIG.indirectHitToolList.get();
    }

    public static Integer getIndirectHitToolDamage() {
        return (Integer)ModConfig.CONFIG.indirectHitToolDamage.get();
    }

    public static List<? extends String> getExtraTorchItems() {
        return (List)ModConfig.CONFIG.extraTorchItems.get();
    }

    public static List<? extends String> getExtraSoulTorchItems() {
        return (List)ModConfig.CONFIG.extraSoulTorchItems.get();
    }

    public static Boolean getVanillaTorchesEnabled() {
        return (Boolean)ModConfig.CONFIG.vanillaTorchesEnabled.get();
    }

    public static Boolean getAllowCandles() {
        return (Boolean)ModConfig.CONFIG.allowCandles.get();
    }

    public static Boolean getConsumeCandle() {
        return (Boolean)ModConfig.CONFIG.consumeCandle.get();
    }

    public static Boolean getConsumeTorch() {
        return (Boolean)ModConfig.CONFIG.consumeTorch.get();
    }

    public static Boolean getConsumeWithoutFire() {
        return (Boolean)ModConfig.CONFIG.consumeWithoutFire.get();
    }

    public static Boolean getConsumeWithIndirectHits() {
        return (Boolean)ModConfig.CONFIG.consumeWithIndirectHit.get();
    }

    public static Integer getFireChance() {
        return (Integer)ModConfig.CONFIG.fireChance.get();
    }

    public static Boolean getFireFromMobs() {
        return (Boolean)ModConfig.CONFIG.fireFromMobs.get();
    }

    protected void define(ModConfigSpec.Builder builder) {
        int maxDuration = 8;
        this.directHitDuration = builder.comment(" Fire damage duration for direct (main hand) hits.").defineInRange("direct hit duration", 4, 1, maxDuration);
        this.indirectHitDuration = builder.comment(" Fire damage duration for indirect (offhand + tool) hits.").defineInRange("indirect hit duration", 2, 1, maxDuration);
        this.indirectHitToolList = builder.comment(new String[]{" List of tools that allow for an indirect hit when a torch is being held in the offhand.", " Leave empty to disable indirect hits.", " Insert either item categories or specific item IDs."}).defineListAllowEmpty("indirect tools", () -> List.of("sword", "axe", "pickaxe", "shovel", "hoe"), x$0 -> this.stringListValidator(x$0));
        this.indirectHitToolDamage = builder.comment(new String[]{" How much Indirect Hits should damage wooden tools (in percentage).", " 0 to disable."}).defineInRange("indirect hit tool damage", 33, 0, 100);
        this.extraTorchItems = builder.comment(" List of item ids that should be considered as a Torch.").defineListAllowEmpty("extra torch items", () -> List.of("bonetorch:bonetorch", "torchmaster:megatorch", "hardcore_torches:lit_torch", "magnumtorch:diamond_magnum_torch", "magnumtorch:emerald_magnum_torch", "magnumtorch:amethyst_magnum_torch", "magical_torches:mega_torch", "magical_torches:grand_torch", "magical_torches:medium_torch", "magical_torches:small_torch", "pgwbandedtorches:banded_torch_white", "pgwbandedtorches:banded_torch_orange", "pgwbandedtorches:banded_torch_magenta", "pgwbandedtorches:banded_torch_light_blue", "pgwbandedtorches:banded_torch_yellow", "pgwbandedtorches:banded_torch_lime", "pgwbandedtorches:banded_torch_pink", "pgwbandedtorches:banded_torch_gray", "pgwbandedtorches:banded_torch_light_gray", "pgwbandedtorches:banded_torch_cyan", "pgwbandedtorches:banded_torch_purple", "pgwbandedtorches:banded_torch_blue", "pgwbandedtorches:banded_torch_brown", "pgwbandedtorches:banded_torch_green", "pgwbandedtorches:banded_torch_red", "pgwbandedtorches:banded_torch_black"), x$0 -> this.stringListValidator(x$0));
        this.extraSoulTorchItems = builder.comment(" List of item ids that should be considered as a Soul Torch.").defineListAllowEmpty("extra soul torch items", () -> List.of("pgwbandedtorches:banded_soul_torch_white", "pgwbandedtorches:banded_soul_torch_orange", "pgwbandedtorches:banded_soul_torch_magenta", "pgwbandedtorches:banded_soul_torch_light_blue", "pgwbandedtorches:banded_soul_torch_yellow", "pgwbandedtorches:banded_soul_torch_lime", "pgwbandedtorches:banded_soul_torch_pink", "pgwbandedtorches:banded_soul_torch_gray", "pgwbandedtorches:banded_soul_torch_light_gray", "pgwbandedtorches:banded_soul_torch_cyan", "pgwbandedtorches:banded_soul_torch_purple", "pgwbandedtorches:banded_soul_torch_blue", "pgwbandedtorches:banded_soul_torch_brown", "pgwbandedtorches:banded_soul_torch_green", "pgwbandedtorches:banded_soul_torch_red", "pgwbandedtorches:banded_soul_torch_black"), x$0 -> this.stringListValidator(x$0));
        this.vanillaTorchesEnabled = builder.comment(new String[]{" Whether Vanilla torches can set targets on fire.", " If false, only the items specified by [extra torch items] and [extra soul torch items] will set targets on fire."}).define("vanilla torches enabled", true);
        this.allowCandles = builder.comment(" Whether to allow candles to act as torches.").define("allow candles", true);
        this.consumeCandle = builder.comment(new String[]{" Whether candles should break upon use.", "Effective only if [allowCandles] is enabled."}).define("consume candle", true);
        this.consumeTorch = builder.comment(" Whether torches should break upon use.").define("consume torch", false);
        this.consumeWithoutFire = builder.comment(new String[]{" Whether to break the torch/candle upon use even if no fire was set.", " Effective only if [fire chance] and at least one of [consume torch] and [consume candle] are set different from default."}).define("consume without fire", false);
        this.consumeWithIndirectHit = builder.comment(new String[]{" Whether to break the torch/candle upon indirect hits.", " Effective only if [consume torch] is set to true."}).define("consume with indirect hits", false);
        this.fireChance = builder.comment(" Chance (in percentage) for torches/candles to set targets on fire.").defineInRange("fire chance", 100, 1, 100);
        this.fireFromMobs = builder.comment(new String[]{" Whether mobs wielding a torch can set their targets on fire.", " Generally useful only when other mods tweak mobs to wield torches."}).define("fire from mobs", true);
    }
}

