package uk.co.cablepost.bb_boat_hud.editor;

import imgui.*;
import imgui.type.ImBoolean;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import uk.co.cablepost.bb_boat_hud.client.AnchorType;
import uk.co.cablepost.bb_boat_hud.client.BbBoatHudClient;
import uk.co.cablepost.bb_boat_hud.client.HudModule;
import uk.co.cablepost.bb_boat_hud.client.HudModulePlacement;
import uk.co.cablepost.bb_boat_hud.config.ModConfig;
import xyz.breadloaf.imguimc.theme.ImGuiDarkTheme;

import java.util.*;

@Environment(EnvType.CLIENT)
public class EditorScreen extends NonDockableImGuiScreen {

    EditorScreenEnum screenEnum = EditorScreenEnum.ACTIVE_MODULES;

    public EditorScreen() {
        super(class_2561.method_43470("BBBoatHud Editor"), true);
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    //? if <1.21.3 {
    /*@Override
    protected void applyBlur(float delta) {
    }
    *///?}
    //? if >=1.21.3 {
    @Override
    protected void method_57734() {
    }
    //?}

    @Override
    public void method_25419() {
        AutoConfig.getConfigHolder(ModConfig.class).save();
        super.method_25419();
    }

    @Override
    protected List<NonDockableImGuiWindow> initImGui() {
        return List.of(
            new NonDockableImGuiWindow(
                new ImGuiDarkTheme(), // Theme
                class_2561.method_43470("BB Boat HUD"), // Title
                () -> {
                    ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

                    if(screenEnum == EditorScreenEnum.ACTIVE_MODULES) {
                        ImGui.text("Modules on screen:");

                        for (int i = config.modulePlacements.size() - 1; i >= 0; i--) {

                            HudModule hudModule = BbBoatHudClient.HUD_MODULES.get(class_2960.method_60654(config.modulePlacements.get(i).identifier));

                            String name = "(" + i + ") " + config.modulePlacements.get(i).identifier;
                            if(hudModule == null){
                                name = "[NOT FOUND!] " + name;
                            }

                            if (ImGui.beginMenu(name, true)) {
                                ImGui.text("Anchor:");

                                boolean[] anchorTopLeft = new boolean[]{config.modulePlacements.get(i).anchorType == AnchorType.TOP_LEFT};
                                boolean[] anchorTopCenter = new boolean[]{config.modulePlacements.get(i).anchorType == AnchorType.TOP_CENTER};
                                boolean[] anchorTopRight = new boolean[]{config.modulePlacements.get(i).anchorType == AnchorType.TOP_RIGHT};
                                boolean[] anchorMiddleLeft = new boolean[]{config.modulePlacements.get(i).anchorType == AnchorType.MIDDLE_LEFT};
                                boolean[] anchorMiddleCenter = new boolean[]{config.modulePlacements.get(i).anchorType == AnchorType.MIDDLE_CENTER};
                                boolean[] anchorMiddleRight = new boolean[]{config.modulePlacements.get(i).anchorType == AnchorType.MIDDLE_RIGHT};
                                boolean[] anchorBottomLeft = new boolean[]{config.modulePlacements.get(i).anchorType == AnchorType.BOTTOM_LEFT};
                                boolean[] anchorBottomCenter = new boolean[]{config.modulePlacements.get(i).anchorType == AnchorType.BOTTOM_CENTER};
                                boolean[] anchorBottomRight = new boolean[]{config.modulePlacements.get(i).anchorType == AnchorType.BOTTOM_RIGHT};

                                if (ImGui.checkbox("Top Left", anchorTopLeft[0])) {
                                    config.modulePlacements.get(i).anchorType = AnchorType.TOP_LEFT;
                                }
                                if (ImGui.checkbox("Top Center", anchorTopCenter[0])) {
                                    config.modulePlacements.get(i).anchorType = AnchorType.TOP_CENTER;
                                }
                                if (ImGui.checkbox("Top Right", anchorTopRight[0])) {
                                    config.modulePlacements.get(i).anchorType = AnchorType.TOP_RIGHT;
                                }

                                if (ImGui.checkbox("Middle Left", anchorMiddleLeft[0])) {
                                    config.modulePlacements.get(i).anchorType = AnchorType.MIDDLE_LEFT;
                                }
                                if (ImGui.checkbox("Middle Center", anchorMiddleCenter[0])) {
                                    config.modulePlacements.get(i).anchorType = AnchorType.MIDDLE_CENTER;
                                }
                                if (ImGui.checkbox("Middle Right", anchorMiddleRight[0])) {
                                    config.modulePlacements.get(i).anchorType = AnchorType.MIDDLE_RIGHT;
                                }

                                if (ImGui.checkbox("Bottom Left", anchorBottomLeft[0])) {
                                    config.modulePlacements.get(i).anchorType = AnchorType.BOTTOM_LEFT;
                                }
                                if (ImGui.checkbox("Bottom Center", anchorBottomCenter[0])) {
                                    config.modulePlacements.get(i).anchorType = AnchorType.BOTTOM_CENTER;
                                }
                                if (ImGui.checkbox("Bottom Right", anchorBottomRight[0])) {
                                    config.modulePlacements.get(i).anchorType = AnchorType.BOTTOM_RIGHT;
                                }

                                ImGui.separator();

                                try {
                                    int[] offset = new int[]{config.modulePlacements.get(i).xOffset, config.modulePlacements.get(i).yOffset};

                                    ImGui.sliderInt2("Offset", offset, -300, 300);

                                    config.modulePlacements.get(i).xOffset = offset[0];
                                    config.modulePlacements.get(i).yOffset = offset[1];
                                } catch (NumberFormatException ignored) {
                                }

                                try {
                                    float[] scale = new float[]{config.modulePlacements.get(i).scale};
                                    if (ImGui.sliderFloat("Scale", scale, 0.1f, 10f)) {
                                        config.modulePlacements.get(i).scale = scale[0];
                                    }
                                } catch (NumberFormatException ignored) {
                                }

                                try {
                                    float[] rotation = new float[]{config.modulePlacements.get(i).angle};
                                    if (ImGui.sliderFloat("Rotation", rotation, -180f, 180f)) {
                                        config.modulePlacements.get(i).angle = rotation[0];
                                    }
                                } catch (NumberFormatException ignored) {
                                }

                                ImGui.separator();

                                if (ImGui.button("Remove")) {
                                    config.modulePlacements.remove(i);
                                }

                                ImGui.endMenu();
                            }
                        }

                        ImGui.separator();

                        if (ImGui.button("Add Module")) {
                            screenEnum = EditorScreenEnum.MODULES_LIBRARY;
                        }

                        if (ImGui.button("Configure Vanilla HUD")) {
                            screenEnum = EditorScreenEnum.VANILLA_HUD;
                        }
                    }
                    else if(screenEnum == EditorScreenEnum.MODULES_LIBRARY){
                        ImGui.text("Modules Library:");

                        Map<String, List<String>> hudModulesSplit = new HashMap<>();

                        for(var hudModule : BbBoatHudClient.HUD_MODULES.entrySet()) {
                            String name = hudModule.getKey().toString();

                            String[] splitByColon = name.split(":");

                            List<String> fullSplit = new ArrayList<>();
                            fullSplit.add(splitByColon[0]);
                            fullSplit.addAll(Arrays.stream(splitByColon[1].split("/")).toList().stream().skip(1).toList());

                            hudModulesSplit.put(
                                name,
                                fullSplit
                            );
                        }

                        HudModuleFolder rootFolder = new HudModuleFolder();
                        rootFolder.folderName = "/";

                        for(var hudModuleSplit : hudModulesSplit.entrySet()) {
                            HudModuleFolder folder = rootFolder;

                            for(int i = 0; i < hudModuleSplit.getValue().size(); i++) {
                                if(i == hudModuleSplit.getValue().size() - 1){
                                    folder.filesByFullPath.add(hudModuleSplit.getKey());
                                    folder.filesByLastPart.add(hudModuleSplit.getValue().get(i));
                                    continue;
                                }

                                int finalI = i;
                                var optionalExistingSubFolder = folder.subFolders.stream().filter(x -> Objects.equals(x.folderName, hudModuleSplit.getValue().get(finalI))).findFirst();

                                if(optionalExistingSubFolder.isPresent()){
                                    folder = optionalExistingSubFolder.get();
                                }
                                else{
                                    HudModuleFolder subFolder = new HudModuleFolder();
                                    subFolder.folderName = hudModuleSplit.getValue().get(i);

                                    folder.subFolders.add(subFolder);
                                    folder = subFolder;
                                }
                            }
                        }

                        if(renderLibFolder(config, rootFolder)){
                            screenEnum = EditorScreenEnum.ACTIVE_MODULES;
                        }

                        ImGui.separator();

                        if (ImGui.button("Back")) {
                            screenEnum = EditorScreenEnum.ACTIVE_MODULES;
                        }
                    }
                    else if(screenEnum == EditorScreenEnum.VANILLA_HUD) {
                        ImGui.text("Vanilla HUD");

                        VanillaHudModuleConfigWithName[] vanillaHudModuleConfigs = new VanillaHudModuleConfigWithName[] {
                            new VanillaHudModuleConfigWithName("Hotbar", config.hotbar),
                            new VanillaHudModuleConfigWithName("Experience Bar", config.experienceBar),
                            new VanillaHudModuleConfigWithName("Experience Level", config.experienceLevel),
                            new VanillaHudModuleConfigWithName("Held Item Tooltip", config.heldItemTooltip),
                            new VanillaHudModuleConfigWithName("Armor Bar", config.armorBar),
                            new VanillaHudModuleConfigWithName("Health Bar", config.healthBar),
                            new VanillaHudModuleConfigWithName("Food Bar", config.foodBar),
                            new VanillaHudModuleConfigWithName("Oxygen Bar", config.oxygenBar),
                            new VanillaHudModuleConfigWithName("Boss Bar", config.bossBar),
                            new VanillaHudModuleConfigWithName("Action Bar Message", config.overlayMessage),
                        };

                        for (int i = 0; i < vanillaHudModuleConfigs.length; i++) {
                            if (ImGui.beginMenu(vanillaHudModuleConfigs[i].name, true)) {

                                ImBoolean renderBefore = new ImBoolean(vanillaHudModuleConfigs[i].moduleConfig.render);
                                ImGui.checkbox("Render", renderBefore);
                                vanillaHudModuleConfigs[i].moduleConfig.render = renderBefore.get();

                                try {
                                    int[] offset = new int[]{vanillaHudModuleConfigs[i].moduleConfig.xOffset, vanillaHudModuleConfigs[i].moduleConfig.yOffset};

                                    ImGui.sliderInt2("Offset", offset, -300, 300);

                                    vanillaHudModuleConfigs[i].moduleConfig.xOffset = offset[0];
                                    vanillaHudModuleConfigs[i].moduleConfig.yOffset = offset[1];
                                } catch (NumberFormatException ignored) {
                                }

                                ImGui.endMenu();
                            }
                        }

                        ImGui.separator();

                        if (ImGui.button("Back")) {
                            screenEnum = EditorScreenEnum.ACTIVE_MODULES;
                        }
                    }
                },
                false // Can close
            )
        );
    }

    private static boolean renderLibFolder(ModConfig config, HudModuleFolder folder){
        boolean toReturn = false;

        for(int i = 0; i < folder.filesByFullPath.size(); i++) {
            if (ImGui.button(folder.filesByLastPart.get(i))) {
                HudModulePlacement hudModulePlacement = new HudModulePlacement();

                hudModulePlacement.identifier = folder.filesByFullPath.get(i);
                hudModulePlacement.anchorType = AnchorType.MIDDLE_CENTER;
                hudModulePlacement.xOffset = 0;
                hudModulePlacement.yOffset = 0;

                config.modulePlacements.add(hudModulePlacement);

                toReturn = true;
            }
        }

        if(!folder.filesByFullPath.isEmpty() && !folder.subFolders.isEmpty()) {
            ImGui.separator();
        }

        for(var subFolder : folder.subFolders) {
            if (ImGui.beginMenu(subFolder.folderName, true)) {
                //ImGui.text(subFolder.folderName);
                if(renderLibFolder(config, subFolder)){
                    toReturn = true;
                }
                ImGui.endMenu();
            }
        }

        return toReturn;
    }
}