package uk.co.cablepost.bb_boat_hud.editor;

import xyz.breadloaf.imguimc.Imguimc;

import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class NonDockableImGuiScreen  extends class_437 {
    List<NonDockableImGuiWindow> windows;
    boolean closeWhenNoWindows;
    boolean alreadyInitialised;

    protected NonDockableImGuiScreen(class_2561 component, boolean closeWhenNoWindows) {
        super(component);
        this.closeWhenNoWindows = closeWhenNoWindows;
        this.alreadyInitialised = false;
    }

    protected List<NonDockableImGuiWindow> initImGui() {
        return List.of();
    }

    protected void method_25426() {
        super.method_25426();
        if (!this.alreadyInitialised) {
            this.windows = this.initImGui();
            Iterator var1 = this.windows.iterator();

            while(var1.hasNext()) {
                NonDockableImGuiWindow window = (NonDockableImGuiWindow)var1.next();
                Imguimc.pushRenderable(window);
            }

            this.alreadyInitialised = true;
        }

    }

    public void method_25419() {
        Iterator var1 = this.windows.iterator();

        while(var1.hasNext()) {
            NonDockableImGuiWindow window = (NonDockableImGuiWindow)var1.next();
            Imguimc.pullRenderable(window);
        }

        super.method_25419();
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
        if (this.closeWhenNoWindows) {
            boolean foundOpen = false;
            Iterator var6 = this.windows.iterator();

            while(var6.hasNext()) {
                NonDockableImGuiWindow window = (NonDockableImGuiWindow)var6.next();
                if (window.open.get()) {
                    foundOpen = true;
                }
            }

            if (!foundOpen) {
                this.method_25419();
            }
        }

    }

    protected void pushWindow(NonDockableImGuiWindow window) {
        this.windows.add(window);
        Imguimc.pushRenderable(window);
    }

    protected void pullWindow(NonDockableImGuiWindow window) {
        this.windows.remove(window);
        Imguimc.pullRenderableAfterRender(window);
    }
}
