package uk.co.cablepost.bb_boat_hud.editor;

import imgui.ImGui;
import imgui.flag.ImGuiWindowFlags;
import imgui.type.ImBoolean;
import net.minecraft.class_2561;
import xyz.breadloaf.imguimc.Imguimc;
import xyz.breadloaf.imguimc.interfaces.Renderable;
import xyz.breadloaf.imguimc.interfaces.Theme;
import xyz.breadloaf.imguimc.screen.ImGuiWindow;
import xyz.breadloaf.imguimc.screen.WindowRenderer;

public class NonDockableImGuiWindow implements Renderable {
    Theme theme;
    class_2561 name;
    WindowRenderer renderer;
    public boolean canClose;
    ImBoolean open;

    public NonDockableImGuiWindow(Theme theme, class_2561 name, WindowRenderer renderer, boolean canClose) {
        this.theme = theme;
        this.name = name;
        this.renderer = renderer;
        this.canClose = canClose;
        this.open = new ImBoolean(true);
    }

    public String getName() {
        return this.name.method_54160();
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void render() {
        if (!this.open.get()) {
            Imguimc.pullRenderableAfterRender(this);
        } else {
            //ImGui.setNextWindowSize(100, 100);
            if (this.canClose) {
                ImGui.begin(this.getName(), this.open, ImGuiWindowFlags.NoDocking | ImGuiWindowFlags.AlwaysAutoResize);
            } else {
                ImGui.begin(this.getName(), ImGuiWindowFlags.NoDocking);
            }

            this.renderer.renderWindow();
            ImGui.end();
        }
    }
}
