package uk.co.cablepost.bb_boat_hud.mixin;

import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_1657;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import uk.co.cablepost.bb_boat_hud.client.BbBoatHudClient;
import uk.co.cablepost.bb_boat_hud.config.ModConfig;

@Mixin(class_329.class)
public class InGameHudMixin {

    @Inject(method = "renderOverlayMessage", at = @At("HEAD"), cancellable = true)
    private void renderOverlayMessage(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

        if(!config.overlayMessage.render && BbBoatHudClient.FPS > 0){
            ci.cancel();
            return;
        }

        context.method_51448().method_22903();
        if(BbBoatHudClient.FPS > 0) {
            context.method_51448().method_46416(config.overlayMessage.xOffset, config.overlayMessage.yOffset, 0f);
        }
    }

    @Inject(method = "renderOverlayMessage", at = @At("RETURN"))
    private void renderOverlayMessageReturn(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        context.method_51448().method_22909();
    }

    @Inject(method = "renderHotbar", at = @At("HEAD"), cancellable = true)
    private void renderHotbar(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

        if(!config.hotbar.render && BbBoatHudClient.FPS > 0){
            ci.cancel();
            return;
        }

        context.method_51448().method_22903();
        if(BbBoatHudClient.FPS > 0) {
            context.method_51448().method_46416(config.hotbar.xOffset, config.hotbar.yOffset, 0f);
        }
    }

    @Inject(method = "renderHotbar", at = @At("RETURN"))
    private void renderHotbarReturn(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        context.method_51448().method_22909();
    }

    @Inject(method = "renderExperienceBar", at = @At("HEAD"), cancellable = true)
    private void renderExperienceBar(class_332 context, int x, CallbackInfo ci) {
        ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

        if(!config.experienceBar.render && BbBoatHudClient.FPS > 0){
            ci.cancel();
            return;
        }

        context.method_51448().method_22903();
        if(BbBoatHudClient.FPS > 0) {
            context.method_51448().method_46416(config.experienceBar.xOffset, config.experienceBar.yOffset, 0f);
        }
    }

    @Inject(method = "renderExperienceBar", at = @At("RETURN"))
    private void renderExperienceBarReturn(class_332 context, int x, CallbackInfo ci) {
        context.method_51448().method_22909();
    }

    @Inject(method = "renderExperienceLevel", at = @At("HEAD"), cancellable = true)
    private void renderExperienceLevel(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

        if(!config.experienceLevel.render && BbBoatHudClient.FPS > 0){
            ci.cancel();
            return;
        }

        context.method_51448().method_22903();
        if(BbBoatHudClient.FPS > 0) {
            context.method_51448().method_46416(config.experienceLevel.xOffset, config.experienceLevel.yOffset, 0f);
        }
    }

    @Inject(method = "renderExperienceLevel", at = @At("RETURN"))
    private void renderExperienceLevelReturn(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        context.method_51448().method_22909();
    }

    @Inject(method = "renderHeldItemTooltip", at = @At("HEAD"), cancellable = true)
    private void renderHeldItemTooltip(class_332 context, CallbackInfo ci) {
        ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

        if(!config.heldItemTooltip.render && BbBoatHudClient.FPS > 0){
            ci.cancel();
            return;
        }

        context.method_51448().method_22903();
        if(BbBoatHudClient.FPS > 0) {
            context.method_51448().method_46416(config.heldItemTooltip.xOffset, config.heldItemTooltip.yOffset, 0f);
        }
    }

    @Inject(method = "renderHeldItemTooltip", at = @At("RETURN"))
    private void renderHeldItemTooltipReturn(class_332 context, CallbackInfo ci) {
        context.method_51448().method_22909();
    }

    @Inject(method = "renderArmor", at = @At("HEAD"), cancellable = true)
    private static void renderArmor(class_332 context, class_1657 player, int i, int j, int k, int x, CallbackInfo ci) {
        ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

        if(!config.armorBar.render && BbBoatHudClient.FPS > 0){
            ci.cancel();
            return;
        }

        context.method_51448().method_22903();
        if(BbBoatHudClient.FPS > 0) {
            context.method_51448().method_46416(config.armorBar.xOffset, config.armorBar.yOffset, 0f);
        }
    }

    @Inject(method = "renderArmor", at = @At("RETURN"))
    private static void renderArmorReturn(class_332 context, class_1657 player, int i, int j, int k, int x, CallbackInfo ci) {
        context.method_51448().method_22909();
    }

    @Inject(method = "renderHealthBar", at = @At("HEAD"), cancellable = true)
    private void renderHealthBar(class_332 context, class_1657 player, int x, int y, int lines, int regeneratingHeartIndex, float maxHealth, int lastHealth, int health, int absorption, boolean blinking, CallbackInfo ci) {
        ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

        if(!config.healthBar.render && BbBoatHudClient.FPS > 0){
            ci.cancel();
            return;
        }

        context.method_51448().method_22903();
        if(BbBoatHudClient.FPS > 0) {
            context.method_51448().method_46416(config.healthBar.xOffset, config.healthBar.yOffset, 0f);
        }
    }

    @Inject(method = "renderHealthBar", at = @At("RETURN"))
    private void renderHealthBarReturn(class_332 context, class_1657 player, int x, int y, int lines, int regeneratingHeartIndex, float maxHealth, int lastHealth, int health, int absorption, boolean blinking, CallbackInfo ci) {
        context.method_51448().method_22909();
    }

    @Inject(method = "renderFood", at = @At("HEAD"), cancellable = true)
    private void renderFood(class_332 context, class_1657 player, int top, int right, CallbackInfo ci) {
        ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

        if(!config.foodBar.render && BbBoatHudClient.FPS > 0){
            ci.cancel();
            return;
        }

        context.method_51448().method_22903();
        if(BbBoatHudClient.FPS > 0) {
            context.method_51448().method_46416(config.foodBar.xOffset, config.foodBar.yOffset, 0f);
        }
    }

    @Inject(method = "renderFood", at = @At("RETURN"))
    private void renderFoodReturn(class_332 context, class_1657 player, int top, int right, CallbackInfo ci) {
        context.method_51448().method_22909();
    }

    //? if <1.21.3 {
    /*@Inject(method = "renderStatusBars(Lnet/minecraft/client/gui/DrawContext;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawGuiTexture(Lnet/minecraft/util/Identifier;IIII)V"))
    private void renderOxygenStart(DrawContext context, CallbackInfo ci) {
        context.getMatrices().push();

        ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

        if(!config.oxygenBar.render){
            context.getMatrices().translate(99999, 0, 0f);
        }
        else{
            context.getMatrices().translate(config.oxygenBar.xOffset, config.oxygenBar.yOffset, 0f);
        }
    }

    @Inject(method = "renderStatusBars(Lnet/minecraft/client/gui/DrawContext;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawGuiTexture(Lnet/minecraft/util/Identifier;IIII)V", shift = At.Shift.AFTER))
    private void renderOxygenEnd(DrawContext context, CallbackInfo ci) {
        context.getMatrices().pop();
    }
    *///?}
    //? if >=1.21.3 {
    @Inject(method = "renderAirBubbles(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/entity/player/PlayerEntity;III)V", at = @At("HEAD"), cancellable = true)
    private void renderAirBubbles(class_332 context, class_1657 player, int heartCount, int top, int left, CallbackInfo ci) {
        ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

        if(!config.oxygenBar.render && BbBoatHudClient.FPS > 0){
            ci.cancel();
            return;
        }

        context.method_51448().method_22903();
        if(BbBoatHudClient.FPS > 0) {
            context.method_51448().method_46416(config.oxygenBar.xOffset, config.oxygenBar.yOffset, 0f);
        }
    }

    @Inject(method = "renderAirBubbles(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/entity/player/PlayerEntity;III)V", at = @At("RETURN"))
    private void renderAirBubblesReturn(class_332 context, class_1657 player, int heartCount, int top, int left, CallbackInfo ci) {
        context.method_51448().method_22909();
    }
    //?}
}
