/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bb_boat_hud.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

public class TextToLuaParser {
    public static LuaTable parse(class_2561 text) {
        JsonObject jsonObject = class_2561.class_2562.method_10874((class_2561)text, (class_7225.class_7874)class_5455.field_40585).getAsJsonObject();
        LuaTable luaMessage = new LuaTable();
        ArrayList<LuaTable> textLua = new ArrayList<LuaTable>();
        TextToLuaParser.parseTextJsonToLua(jsonObject, textLua);
        int c = 1;
        for (LuaTable t : textLua) {
            luaMessage.set(c, (LuaValue)t);
            ++c;
        }
        return luaMessage;
    }

    private static void parseTextJsonToLua(JsonObject jsonObject, List<LuaTable> list) {
        String content = "";
        int color = -1;
        if (jsonObject.has("text")) {
            content = jsonObject.getAsJsonPrimitive("text").getAsString().replaceAll("\ub030", "\u2b50").replaceAll("[^a-zA-Z0-9\\s!@#$%^&*\u2b50()\\-=_+\\[\\]{}|;:'\",.<>?/\\\\]", "").trim();
        }
        if (jsonObject.has("color")) {
            String colorStr = jsonObject.getAsJsonPrimitive("color").getAsString();
            if (colorStr.startsWith("#")) {
                color = 0xFF000000 | Integer.parseInt(colorStr.substring(1), 16);
            } else if (Objects.equals(colorStr, "dark_red")) {
                color = 0xAA0000;
            } else if (Objects.equals(colorStr, "red")) {
                color = 0xFF5555;
            } else if (Objects.equals(colorStr, "gold")) {
                color = 0xFFAA00;
            } else if (Objects.equals(colorStr, "yellow")) {
                color = 0xFFFF55;
            } else if (Objects.equals(colorStr, "dark_green")) {
                color = 43520;
            } else if (Objects.equals(colorStr, "green")) {
                color = 0x55FF55;
            } else if (Objects.equals(colorStr, "aqua")) {
                color = 0x55FFFF;
            } else if (Objects.equals(colorStr, "dark_aqua")) {
                color = 43690;
            } else if (Objects.equals(colorStr, "dark_blue")) {
                color = 170;
            } else if (Objects.equals(colorStr, "blue")) {
                color = 0x5555FF;
            } else if (Objects.equals(colorStr, "light_purple")) {
                color = 0xFF55FF;
            } else if (Objects.equals(colorStr, "dark_purple")) {
                color = 0xAA00AA;
            } else if (Objects.equals(colorStr, "white")) {
                color = 0xFFFFFF;
            } else if (Objects.equals(colorStr, "gray")) {
                color = 0xAAAAAA;
            } else if (Objects.equals(colorStr, "dark_gray")) {
                color = 0x555555;
            } else if (Objects.equals(colorStr, "black")) {
                color = 0;
            }
        }
        if (!content.isEmpty()) {
            LuaTable luaTable = new LuaTable();
            luaTable.set("content", content);
            luaTable.set("color", color);
            list.add(luaTable);
        }
        if (jsonObject.has("extra")) {
            JsonArray extra = jsonObject.getAsJsonArray("extra");
            for (JsonElement jsonElement : extra) {
                if (jsonElement.isJsonPrimitive()) {
                    LuaTable luaTable = new LuaTable();
                    luaTable.set("content", jsonElement.getAsString().trim());
                    luaTable.set("color", -1);
                    list.add(luaTable);
                    continue;
                }
                TextToLuaParser.parseTextJsonToLua(jsonElement.getAsJsonObject(), list);
            }
        }
    }
}

