/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bb_boat_hud.editor;

import imgui.ImGui;
import imgui.type.ImBoolean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import uk.co.cablepost.bb_boat_hud.client.AnchorType;
import uk.co.cablepost.bb_boat_hud.client.BbBoatHudClient;
import uk.co.cablepost.bb_boat_hud.client.HudModule;
import uk.co.cablepost.bb_boat_hud.client.HudModulePlacement;
import uk.co.cablepost.bb_boat_hud.config.ModConfig;
import uk.co.cablepost.bb_boat_hud.editor.EditorScreenEnum;
import uk.co.cablepost.bb_boat_hud.editor.HudModuleFolder;
import uk.co.cablepost.bb_boat_hud.editor.NonDockableImGuiScreen;
import uk.co.cablepost.bb_boat_hud.editor.NonDockableImGuiWindow;
import uk.co.cablepost.bb_boat_hud.editor.VanillaHudModuleConfigWithName;
import xyz.breadloaf.imguimc.interfaces.Theme;
import xyz.breadloaf.imguimc.theme.ImGuiDarkTheme;

@Environment(value=EnvType.CLIENT)
public class EditorScreen
extends NonDockableImGuiScreen {
    EditorScreenEnum screenEnum = EditorScreenEnum.ACTIVE_MODULES;

    public EditorScreen() {
        super((class_2561)class_2561.method_43470((String)"BBBoatHud Editor"), true);
    }

    public boolean method_25421() {
        return false;
    }

    protected void method_57734() {
    }

    @Override
    public void method_25419() {
        AutoConfig.getConfigHolder(ModConfig.class).save();
        super.method_25419();
    }

    @Override
    protected List<NonDockableImGuiWindow> initImGui() {
        return List.of(new NonDockableImGuiWindow((Theme)new ImGuiDarkTheme(), (class_2561)class_2561.method_43470((String)"BB Boat HUD"), () -> {
            ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
            if (this.screenEnum == EditorScreenEnum.ACTIVE_MODULES) {
                ImGui.text((String)"Modules on screen:");
                for (int i = config.modulePlacements.size() - 1; i >= 0; --i) {
                    void var4_8;
                    HudModule hudModule = BbBoatHudClient.HUD_MODULES.get(class_2960.method_60654((String)config.modulePlacements.get((int)i).identifier));
                    String string = "(" + i + ") " + config.modulePlacements.get((int)i).identifier;
                    if (hudModule == null) {
                        String string2 = "[NOT FOUND!] " + string;
                    }
                    if (!ImGui.beginMenu((String)var4_8, (boolean)true)) continue;
                    ImGui.text((String)"Anchor:");
                    boolean[] numberFormatException = new boolean[]{config.modulePlacements.get((int)i).anchorType == AnchorType.TOP_LEFT};
                    boolean[] anchorTopCenter = new boolean[]{config.modulePlacements.get((int)i).anchorType == AnchorType.TOP_CENTER};
                    boolean[] anchorTopRight = new boolean[]{config.modulePlacements.get((int)i).anchorType == AnchorType.TOP_RIGHT};
                    boolean[] anchorMiddleLeft = new boolean[]{config.modulePlacements.get((int)i).anchorType == AnchorType.MIDDLE_LEFT};
                    boolean[] anchorMiddleCenter = new boolean[]{config.modulePlacements.get((int)i).anchorType == AnchorType.MIDDLE_CENTER};
                    boolean[] anchorMiddleRight = new boolean[]{config.modulePlacements.get((int)i).anchorType == AnchorType.MIDDLE_RIGHT};
                    boolean[] anchorBottomLeft = new boolean[]{config.modulePlacements.get((int)i).anchorType == AnchorType.BOTTOM_LEFT};
                    boolean[] anchorBottomCenter = new boolean[]{config.modulePlacements.get((int)i).anchorType == AnchorType.BOTTOM_CENTER};
                    boolean[] anchorBottomRight = new boolean[]{config.modulePlacements.get((int)i).anchorType == AnchorType.BOTTOM_RIGHT};
                    if (ImGui.checkbox((String)"Top Left", (boolean)numberFormatException[0])) {
                        config.modulePlacements.get((int)i).anchorType = AnchorType.TOP_LEFT;
                    }
                    if (ImGui.checkbox((String)"Top Center", (boolean)anchorTopCenter[0])) {
                        config.modulePlacements.get((int)i).anchorType = AnchorType.TOP_CENTER;
                    }
                    if (ImGui.checkbox((String)"Top Right", (boolean)anchorTopRight[0])) {
                        config.modulePlacements.get((int)i).anchorType = AnchorType.TOP_RIGHT;
                    }
                    if (ImGui.checkbox((String)"Middle Left", (boolean)anchorMiddleLeft[0])) {
                        config.modulePlacements.get((int)i).anchorType = AnchorType.MIDDLE_LEFT;
                    }
                    if (ImGui.checkbox((String)"Middle Center", (boolean)anchorMiddleCenter[0])) {
                        config.modulePlacements.get((int)i).anchorType = AnchorType.MIDDLE_CENTER;
                    }
                    if (ImGui.checkbox((String)"Middle Right", (boolean)anchorMiddleRight[0])) {
                        config.modulePlacements.get((int)i).anchorType = AnchorType.MIDDLE_RIGHT;
                    }
                    if (ImGui.checkbox((String)"Bottom Left", (boolean)anchorBottomLeft[0])) {
                        config.modulePlacements.get((int)i).anchorType = AnchorType.BOTTOM_LEFT;
                    }
                    if (ImGui.checkbox((String)"Bottom Center", (boolean)anchorBottomCenter[0])) {
                        config.modulePlacements.get((int)i).anchorType = AnchorType.BOTTOM_CENTER;
                    }
                    if (ImGui.checkbox((String)"Bottom Right", (boolean)anchorBottomRight[0])) {
                        config.modulePlacements.get((int)i).anchorType = AnchorType.BOTTOM_RIGHT;
                    }
                    ImGui.separator();
                    try {
                        int[] offset = new int[]{config.modulePlacements.get((int)i).xOffset, config.modulePlacements.get((int)i).yOffset};
                        ImGui.sliderInt2((String)"Offset", (int[])offset, (int)-300, (int)300);
                        config.modulePlacements.get((int)i).xOffset = offset[0];
                        config.modulePlacements.get((int)i).yOffset = offset[1];
                    }
                    catch (NumberFormatException offset) {
                        // empty catch block
                    }
                    try {
                        float[] scale = new float[]{config.modulePlacements.get((int)i).scale};
                        if (ImGui.sliderFloat((String)"Scale", (float[])scale, (float)0.1f, (float)10.0f)) {
                            config.modulePlacements.get((int)i).scale = scale[0];
                        }
                    }
                    catch (NumberFormatException scale) {
                        // empty catch block
                    }
                    try {
                        float[] rotation = new float[]{config.modulePlacements.get((int)i).angle};
                        if (ImGui.sliderFloat((String)"Rotation", (float[])rotation, (float)-180.0f, (float)180.0f)) {
                            config.modulePlacements.get((int)i).angle = rotation[0];
                        }
                    }
                    catch (NumberFormatException numberFormatException2) {
                        // empty catch block
                    }
                    ImGui.separator();
                    if (ImGui.button((String)"Remove")) {
                        config.modulePlacements.remove(i);
                    }
                    ImGui.endMenu();
                }
                ImGui.separator();
                if (ImGui.button((String)"Add Module")) {
                    this.screenEnum = EditorScreenEnum.MODULES_LIBRARY;
                }
                if (ImGui.button((String)"Configure Vanilla HUD")) {
                    this.screenEnum = EditorScreenEnum.VANILLA_HUD;
                }
            } else if (this.screenEnum == EditorScreenEnum.MODULES_LIBRARY) {
                ImGui.text((String)"Modules Library:");
                HashMap hudModulesSplit = new HashMap();
                for (Map.Entry<class_2960, HudModule> entry : BbBoatHudClient.HUD_MODULES.entrySet()) {
                    String string = entry.getKey().toString();
                    String[] splitByColon = string.split(":");
                    ArrayList<String> fullSplit = new ArrayList<String>();
                    fullSplit.add(splitByColon[0]);
                    fullSplit.addAll(Arrays.stream(splitByColon[1].split("/")).toList().stream().skip(1L).toList());
                    hudModulesSplit.put(string, fullSplit);
                }
                HudModuleFolder rootFolder = new HudModuleFolder();
                rootFolder.folderName = "/";
                for (Map.Entry entry : hudModulesSplit.entrySet()) {
                    HudModuleFolder folder = rootFolder;
                    for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                        if (i == ((List)entry.getValue()).size() - 1) {
                            folder.filesByFullPath.add((String)entry.getKey());
                            folder.filesByLastPart.add((String)((List)entry.getValue()).get(i));
                            continue;
                        }
                        int finalI = i;
                        Optional<HudModuleFolder> optionalExistingSubFolder = folder.subFolders.stream().filter(x -> Objects.equals(x.folderName, ((List)hudModuleSplit.getValue()).get(finalI))).findFirst();
                        if (optionalExistingSubFolder.isPresent()) {
                            folder = optionalExistingSubFolder.get();
                            continue;
                        }
                        HudModuleFolder subFolder = new HudModuleFolder();
                        subFolder.folderName = (String)((List)entry.getValue()).get(i);
                        folder.subFolders.add(subFolder);
                        folder = subFolder;
                    }
                }
                if (EditorScreen.renderLibFolder(config, rootFolder)) {
                    this.screenEnum = EditorScreenEnum.ACTIVE_MODULES;
                }
                ImGui.separator();
                if (ImGui.button((String)"Back")) {
                    this.screenEnum = EditorScreenEnum.ACTIVE_MODULES;
                }
            } else if (this.screenEnum == EditorScreenEnum.VANILLA_HUD) {
                ImGui.text((String)"Vanilla HUD");
                VanillaHudModuleConfigWithName[] vanillaHudModuleConfigs = new VanillaHudModuleConfigWithName[]{new VanillaHudModuleConfigWithName("Hotbar", config.hotbar), new VanillaHudModuleConfigWithName("Experience Bar", config.experienceBar), new VanillaHudModuleConfigWithName("Experience Level", config.experienceLevel), new VanillaHudModuleConfigWithName("Held Item Tooltip", config.heldItemTooltip), new VanillaHudModuleConfigWithName("Armor Bar", config.armorBar), new VanillaHudModuleConfigWithName("Health Bar", config.healthBar), new VanillaHudModuleConfigWithName("Food Bar", config.foodBar), new VanillaHudModuleConfigWithName("Oxygen Bar", config.oxygenBar), new VanillaHudModuleConfigWithName("Boss Bar", config.bossBar), new VanillaHudModuleConfigWithName("Action Bar Message", config.overlayMessage)};
                for (int i = 0; i < vanillaHudModuleConfigs.length; ++i) {
                    if (!ImGui.beginMenu((String)vanillaHudModuleConfigs[i].name, (boolean)true)) continue;
                    ImBoolean imBoolean = new ImBoolean(vanillaHudModuleConfigs[i].moduleConfig.render);
                    ImGui.checkbox((String)"Render", (ImBoolean)imBoolean);
                    vanillaHudModuleConfigs[i].moduleConfig.render = imBoolean.get();
                    try {
                        int[] nArray = new int[]{vanillaHudModuleConfigs[i].moduleConfig.xOffset, vanillaHudModuleConfigs[i].moduleConfig.yOffset};
                        ImGui.sliderInt2((String)"Offset", (int[])nArray, (int)-300, (int)300);
                        vanillaHudModuleConfigs[i].moduleConfig.xOffset = nArray[0];
                        vanillaHudModuleConfigs[i].moduleConfig.yOffset = nArray[1];
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ImGui.endMenu();
                }
                ImGui.separator();
                if (ImGui.button((String)"Back")) {
                    this.screenEnum = EditorScreenEnum.ACTIVE_MODULES;
                }
            }
        }, false));
    }

    private static boolean renderLibFolder(ModConfig config, HudModuleFolder folder) {
        boolean toReturn = false;
        for (int i = 0; i < folder.filesByFullPath.size(); ++i) {
            if (!ImGui.button((String)folder.filesByLastPart.get(i))) continue;
            HudModulePlacement hudModulePlacement = new HudModulePlacement();
            hudModulePlacement.identifier = folder.filesByFullPath.get(i);
            hudModulePlacement.anchorType = AnchorType.MIDDLE_CENTER;
            hudModulePlacement.xOffset = 0;
            hudModulePlacement.yOffset = 0;
            config.modulePlacements.add(hudModulePlacement);
            toReturn = true;
        }
        if (!folder.filesByFullPath.isEmpty() && !folder.subFolders.isEmpty()) {
            ImGui.separator();
        }
        for (HudModuleFolder subFolder : folder.subFolders) {
            if (!ImGui.beginMenu((String)subFolder.folderName, (boolean)true)) continue;
            if (EditorScreen.renderLibFolder(config, subFolder)) {
                toReturn = true;
            }
            ImGui.endMenu();
        }
        return toReturn;
    }
}

