package uk.co.cablepost.bb_boat_hud.client;

import com.mojang.blaze3d.systems.RenderSystem;
import org.luaj.vm2.*;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.jse.JsePlatform;

import java.util.*;
import java.util.function.Consumer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_746;
import net.minecraft.class_7833;

public class HudModule {
    private final class_2960 identifier;
    private final Globals globals;
    private LuaValue chunk = null;
    public String error = null;
    public boolean runOutOfBoat = false;
    public Map<Integer, class_1109> soundInstances = new HashMap<>();

    private List<Consumer<class_332>> drawCalls = new ArrayList<>();

    public HudModule(class_2960 identifier, String luaCode){
        this.identifier = identifier;

        globals = JsePlatform.standardGlobals();
        //globals.load(new JseBaseLib());
        //globals.load(new JseMathLib());
        //globals.load(new TableLib());
        //globals.load(new StringLib());

        globals.set("offsetPosition", new offsetPosition());
        globals.set("offsetPosition3d", new offsetPosition3d());
        globals.set("offsetRotation", new offsetRotation());
        globals.set("offsetRotation3d", new offsetRotation3d());
        globals.set("offsetScale", new offsetScale());
        globals.set("offsetScale3d", new offsetScale3d());

        globals.set("renderText", new renderText());
        globals.set("renderBoatLabsText", new renderBoatLabsText());
        globals.set("renderRect", new renderRect());
        globals.set("renderTexture", new renderTexture());
        globals.set("renderTextureCropped", new renderTextureCropped());
        globals.set("renderPlayerHead", new renderPlayerHead());

        globals.set("playSound", new playSound());
        globals.set("stopSound", new stopSound());

        try {
            chunk = globals.load(luaCode);
            runLua();// Get the initial values from the module on if can be run when not in a boat, or if should handle racing scoreboard data
        }
        catch (LuaError e) {
            error = "Error loading component: " + identifier.toString() + "\n\n" + e.getMessage();
        }
    }

    public class_2960 getIdentifier() {
        return identifier;
    }

    public String render(class_332 drawContext){
        if(this.error != null){
            return this.error;
        }

        for(var drawCall : drawCalls){
            drawCall.accept(drawContext);
        }

        return null;
    }

    public void runLua(){
        this.drawCalls.clear();

        if(this.chunk == null){
            return;
        }

        class_243 horizontalVelocity = BbBoatHudClient.VELOCITY.method_18805(1, 0, 1);

        double speed = BbBoatHudClient.VELOCITY.method_1033() * 20d;
        double horizontalSpeed = horizontalVelocity.method_1033() * 20d;

        double driftAngle = Math.toDegrees(Math.acos(horizontalVelocity.method_1026(BbBoatHudClient.ROTATION_VECTOR) / horizontalVelocity.method_1033() * BbBoatHudClient.ROTATION_VECTOR.method_1033()));
        if(Double.isNaN(driftAngle)){
            driftAngle = 0;
        }

        // editorMode is no longer used - we use web-based configuration now
        globals.set("editorMode", LuaBoolean.FALSE);

        globals.set("speed", speed);
        globals.set("horizontalSpeed", horizontalSpeed);
        globals.set("driftAngle", (horizontalVelocity.method_1036(BbBoatHudClient.ROTATION_VECTOR).field_1351 < 0) ? driftAngle : -driftAngle);
        globals.set("gForce", LuaDouble.valueOf((double) Math.round(BbBoatHudClient.G * 1000) / 1000));
        globals.set("ping", BbBoatHudClient.PLAYER_LIST_ENTRY == null ? 0 : BbBoatHudClient.PLAYER_LIST_ENTRY.method_2959());
        globals.set("fps", BbBoatHudClient.FPS);
        globals.set("pressingForward", LuaBoolean.valueOf(BbBoatHudClient.PRESSING_FORWARD));
        globals.set("pressingBack", LuaBoolean.valueOf(BbBoatHudClient.PRESSING_BACK));
        globals.set("pressingLeft", LuaBoolean.valueOf(BbBoatHudClient.PRESSING_LEFT));
        globals.set("pressingRight", LuaBoolean.valueOf(BbBoatHudClient.PRESSING_RIGHT));
        globals.set("angularVelocity", LuaBoolean.valueOf(BbBoatHudClient.ANGULAR_VELOCITY));

        if(class_310.method_1551().field_1724 instanceof class_746 clientPlayer) {
            globals.set("xpLevel", LuaInteger.valueOf(clientPlayer.field_7520));
            globals.set("playerName", LuaString.valueOf(clientPlayer.method_7334().getName()));
        }
        else{
            globals.set("xpLevel", LuaInteger.valueOf(0));
            globals.set("playerName", LuaString.valueOf(""));
        }

        //globals.set("overlayMessage", LuaString.valueOf(BbBoatHudClient.OVERLAY_MESSAGE.trim()));

        if(BbBoatHudClient.LUA_OVERLAY_MESSAGE != null){
            // Overlay message
            globals.set("overlayMessage", BbBoatHudClient.LUA_OVERLAY_MESSAGE);
        }
        else{
            globals.set("overlayMessage", LuaValue.tableOf());
        }

        if(BbBoatHudClient.LUA_SCOREBOARD != null){
            // Overlay message
            globals.set("timingSystemScoreboard", BbBoatHudClient.LUA_SCOREBOARD);
        }
        else{
            globals.set("timingSystemScoreboard", LuaValue.tableOf());
        }

        globals.set("horizontalCollision", LuaBoolean.valueOf(BbBoatHudClient.HORIZONTAL_COLLISION));
        globals.set("isOnGround", LuaBoolean.valueOf(BbBoatHudClient.IS_ON_GROUND));
        globals.set("isInBoat", LuaBoolean.valueOf(BbBoatHudClient.IN_BOAT));

        try {
            this.error = null;
            chunk.call();

            // If a module sets runOutOfBoat to true, it means the module should be run weather in a boat or not
            if(globals.get("runOutOfBoat").isboolean() && globals.get("runOutOfBoat").toboolean()){
                runOutOfBoat = true;
            }
            else{
                runOutOfBoat = false;
            }

            // If a module sets hookTimingSystemScoreboardForRaces to true, it means they intend to handle the timing system scoreboard mod protocol for races,
            // so the server will send that instead of the vanilla one
            if(globals.get("hookTimingSystemScoreboardForRaces").isboolean() && globals.get("hookTimingSystemScoreboardForRaces").toboolean()){
                BbBoatHudClient.MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_RACES = true;
            }

            // If a module sets hookTimingSystemScoreboardForTimeTrials to true, it means they intend to handle the timing system scoreboard mod protocol for time trials,
            // so the server will send that instead of the vanilla one
            if(globals.get("hookTimingSystemScoreboardForTimeTrials").isboolean() && globals.get("hookTimingSystemScoreboardForTimeTrials").toboolean()){
                BbBoatHudClient.MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_TIME_TRIALS = true;
            }
        }
        catch (LuaError e){
            this.error = "Error running component: " + identifier +
                "\n" + "Line: " + e.getLine() + "\n\n" +
                e.getErrorMessage()
            ;
        }
    }

    class offsetPosition extends VarArgFunction {
        public Varargs invoke(Varargs v) {
            int xValue = v.checkint(1);
            int yValue = v.checkint(2);
            LuaFunction funcValue = v.checkfunction(3);

            drawCalls.add(drawContext -> {
                drawContext.method_51448().method_22903();
                drawContext.method_51448().method_46416(xValue, yValue, 0);
            });

            funcValue.call();

            drawCalls.add(drawContext -> {
                drawContext.method_51448().method_22909();
            });

            return LuaValue.NIL;
        }
    }

    class offsetPosition3d extends VarArgFunction {
        public Varargs invoke(Varargs v) {
            int xValue = v.checkint(1);
            int yValue = v.checkint(2);
            int zValue = v.checkint(3);
            LuaFunction funcValue = v.checkfunction(4);

            drawCalls.add(drawContext -> {
                drawContext.method_51448().method_22903();
                drawContext.method_51448().method_46416(xValue, yValue, zValue);
            });

            funcValue.call();

            drawCalls.add(drawContext -> {
                drawContext.method_51448().method_22909();
            });

            return LuaValue.NIL;
        }
    }

    class offsetRotation extends VarArgFunction {
        public Varargs invoke(Varargs v) {
            double rot = v.checkdouble(1);
            LuaFunction funcValue = v.checkfunction(2);

            drawCalls.add(drawContext -> {
                drawContext.method_51448().method_22903();
                drawContext.method_51448().method_22907(class_7833.field_40718.rotationDegrees((float) rot));
            });

            funcValue.call();

            drawCalls.add(drawContext -> {
                drawContext.method_51448().method_22909();
            });

            return LuaValue.NIL;
        }
    }

    class offsetRotation3d extends VarArgFunction {
        public Varargs invoke(Varargs v) {
            double rot = v.checkdouble(1);
            AxisEnum axis = AxisEnum.valueOf(v.checkjstring(2));
            LuaFunction funcValue = v.checkfunction(3);

            drawCalls.add(drawContext -> {
                drawContext.method_51448().method_22903();

                if (axis == AxisEnum.X) {
                    drawContext.method_51448().method_22907(class_7833.field_40714.rotationDegrees((float) rot));
                } else if (axis == AxisEnum.Y) {
                    drawContext.method_51448().method_22907(class_7833.field_40716.rotationDegrees((float) rot));
                } else {
                    drawContext.method_51448().method_22907(class_7833.field_40718.rotationDegrees((float) rot));
                }
            });

            funcValue.call();

            drawCalls.add(drawContext -> {
                drawContext.method_51448().method_22909();
            });

            return LuaValue.NIL;
        }
    }

    class offsetScale extends VarArgFunction {
        public Varargs invoke(Varargs v) {
            double xValue = v.checkdouble(1);
            double yValue = v.checkdouble(2);
            LuaFunction funcValue = v.checkfunction(3);

            drawCalls.add(drawContext -> {
                drawContext.method_51448().method_22903();
                drawContext.method_51448().method_22905((float) xValue, (float) yValue, 1);
            });

            funcValue.call();

            drawCalls.add(drawContext -> {
                drawContext.method_51448().method_22909();
            });

            return LuaValue.NIL;
        }
    }

    class offsetScale3d extends VarArgFunction {
        public Varargs invoke(Varargs v) {
            double xValue = v.checkdouble(1);
            double yValue = v.checkdouble(2);
            double zValue = v.checkdouble(3);
            LuaFunction funcValue = v.checkfunction(4);

            drawCalls.add(drawContext -> {
                drawContext.method_51448().method_22903();
                drawContext.method_51448().method_22905((float) xValue, (float) yValue, (float) zValue);
            });
            funcValue.call();

            drawCalls.add(drawContext -> {
                drawContext.method_51448().method_22909();
            });

            return LuaValue.NIL;
        }
    }

    class renderText extends VarArgFunction {
        public Varargs invoke(Varargs v) {
            String msgValue = v.checkjstring(1);
            int colorValue = v.checkint(2);
            boolean shadowValue = v.checkboolean(3);
            AnchorType anchorValue = AnchorType.valueOf(v.checkjstring(4));

            class_2561 text = class_2561.method_30163(msgValue);

            drawCalls.add(drawContext -> {
                int width = class_310.method_1551().field_1772.method_27525(text);
                int height = class_310.method_1551().field_1772.field_2000;

                class_241 offset = getOffset(width, height, anchorValue);

                drawContext.method_51439(
                    class_310.method_1551().field_1772,
                    text,
                    (int) offset.field_1343,
                    (int) offset.field_1342,
                    colorValue,
                    shadowValue
                );
            });

            return LuaValue.NIL;
        }
    }

    class renderBoatLabsText extends VarArgFunction {
        public Varargs invoke(Varargs v) {
            String msgValue = v.checkjstring(1);
            int colorValue = v.checkint(2);
            boolean shadowValue = v.checkboolean(3);
            AnchorType anchorValue = AnchorType.valueOf(v.checkjstring(4));

            class_2561 text = class_2561.method_30163(msgValue).method_27661().method_10862(class_2583.field_24360.method_27704(class_2960.method_60655("boatlabs", "boatlabs")));

            drawCalls.add(drawContext -> {
                int width = class_310.method_1551().field_1772.method_27525(text);
                int height = class_310.method_1551().field_1772.field_2000;

                class_241 offset = getOffset(width, height, anchorValue);

                drawContext.method_51439(
                    class_310.method_1551().field_1772,
                    text,
                    (int) offset.field_1343,
                    (int) offset.field_1342,
                    colorValue,
                    shadowValue
                );
            });

            return LuaValue.NIL;
        }
    }

    class renderRect extends VarArgFunction {
        public Varargs invoke(Varargs v) {
            int widthValue = (int)Math.round(v.checkdouble(1) * 10d);
            int heightValue = (int)Math.round(v.checkdouble(2) * 10d);
            int colorValue = v.checkint(3);
            AnchorType anchorValue = AnchorType.valueOf(v.checkjstring(4));

            drawCalls.add(drawContext -> {
                class_241 offset = getOffset((float) widthValue, (float) heightValue, anchorValue);

                drawContext.method_51448().method_22903();
                drawContext.method_51448().method_22905(0.1f, 0.1f, 0.1f);

                RenderSystem.enableBlend();
                drawContext.method_25294(
                    (int) offset.field_1343,
                    (int) offset.field_1342,
                    (int) offset.field_1343 + widthValue,
                    (int) offset.field_1342 + heightValue,
                    colorValue
                );
                RenderSystem.disableBlend();

                drawContext.method_51448().method_22909();
            });

            return LuaValue.NIL;
        }
    }

    class renderTexture extends VarArgFunction {
        public Varargs invoke(Varargs v) {
            String idValue = v.checkjstring(1);
            int widthValue = v.checkint(2);
            int heightValue = v.checkint(3);
            AnchorType anchorValue = AnchorType.valueOf(v.checkjstring(4));

            drawCalls.add(drawContext -> {
                class_241 offset = getOffset(1f, 1f, anchorValue);

                drawContext.method_51448().method_22903();
                drawContext.method_51448().method_22905(widthValue, heightValue, 1f);
                drawContext.method_51448().method_46416(offset.field_1343, offset.field_1342, 0);

                RenderSystem.enableBlend();
                //? if <1.21.3 {
                drawContext.method_25290(
                    class_2960.method_60655(identifier.method_12836(), "textures/bb_boat_hud_modules/" + idValue),
                    0, 0,
                    0, 0,
                    1, 1,
                    1, 1
                );
                //?}
                //? if >=1.21.3 {
                /*drawContext.drawTexture(
                    net.minecraft.client.render.RenderLayer::getGuiTextured,
                    Identifier.of(identifier.getNamespace(), "textures/bb_boat_hud_modules/" + idValue),
                    0, 0,
                    0, 0,
                    1, 1,
                    1, 1
                );
                *///?}
                RenderSystem.disableBlend();

                drawContext.method_51448().method_22909();
            });

            return LuaValue.NIL;
        }
    }

    class renderTextureCropped extends VarArgFunction {
        public Varargs invoke(Varargs v) {
            String idValue = v.checkjstring(1);
            int widthValue = v.checkint(2);
            int heightValue = v.checkint(3);
            int cropStartX_value = v.checkint(4);
            int cropStartY_value = v.checkint(5);
            int cropSizeX_value = v.checkint(6);
            int cropSizeY_value = v.checkint(7);
            AnchorType anchorValue = AnchorType.valueOf(v.checkjstring(8));

            drawCalls.add(drawContext -> {
                class_241 offset = getOffset(1, 1, anchorValue);

                drawContext.method_51448().method_22903();
                drawContext.method_51448().method_46416(offset.field_1343 * widthValue, offset.field_1342 * heightValue, 0);

                RenderSystem.enableBlend();
                //? if <1.21.3 {
                drawContext.method_25290(
                    class_2960.method_60655(identifier.method_12836(), "textures/bb_boat_hud_modules/" + idValue),
                    cropStartX_value,
                    cropStartY_value,
                    cropStartX_value,
                    cropStartY_value,
                    cropSizeX_value,
                    cropSizeY_value,
                    widthValue,
                    heightValue
                );
                //?}
                //? if >=1.21.3 {
                /*drawContext.drawTexture(
                    net.minecraft.client.render.RenderLayer::getGuiTextured,
                    Identifier.of(identifier.getNamespace(), "textures/bb_boat_hud_modules/" + idValue),
                    cropStartX_value,
                    cropStartY_value,
                    cropStartX_value,
                    cropStartY_value,
                    cropSizeX_value,
                    cropSizeY_value,
                    widthValue,
                    heightValue
                );
                *///?}
                RenderSystem.disableBlend();

                drawContext.method_51448().method_22909();
            });

            return LuaValue.NIL;
        }
    }

    class renderPlayerHead extends VarArgFunction {
        public Varargs invoke(Varargs v) {
            String playerUuid = v.checkjstring(1);
            //int widthValue = v.checkint(2);
            //int heightValue = v.checkint(3);
            AnchorType anchorValue = AnchorType.valueOf(v.checkjstring(2));

            drawCalls.add(drawContext -> {
                class_241 offset = getOffset(16f, 16f, anchorValue);

                drawContext.method_51448().method_22903();
                //drawContext.getMatrices().scale(widthValue, heightValue, 1f);
                drawContext.method_51448().method_46416(offset.field_1343, offset.field_1342, 0);

                RenderSystem.enableBlend();
                BbBoatHudClient.drawPlayerHead(drawContext, UUID.fromString(playerUuid));
                RenderSystem.disableBlend();

                drawContext.method_51448().method_22909();
            });

            return LuaValue.NIL;
        }
    }

    class playSound extends VarArgFunction {
        public Varargs invoke(Varargs v) {
            String idValue = v.checkjstring(1);
            double volumeValue = v.checkdouble(2);
            double pitchValue = v.checkdouble(3);

            class_2960 soundIdentifier = class_2960.method_60655(identifier.method_12836(), idValue);

            var soundInstance = new class_1109(
                soundIdentifier,
                class_3419.field_15247,
                (float)volumeValue,
                (float)pitchValue,
                class_1113.method_43221(),
                false,
                0,
                class_1113.class_1114.field_5476,
                0f, 0f, 0f,
                true
            );

            class_310.method_1551().method_1483().method_4873(soundInstance);

            if(class_310.method_1551().field_1687 != null) {
                int soundId = class_310.method_1551().field_1687.field_9229.method_43054();
                soundInstances.put(soundId, soundInstance);
                return LuaNumber.valueOf(soundId);
            }

            return LuaValue.NIL;
        }
    }

    class stopSound extends VarArgFunction {
        public Varargs invoke(Varargs v) {
            int soundId = v.checkint(1);

            var soundInstance = soundInstances.get(soundId);

            if(soundInstance != null) {
                class_310.method_1551().method_1483().method_4870(soundInstance);
                soundInstances.remove(soundId);
            }

            return LuaValue.NIL;
        }
    }

    private static class_241 getOffset(float width, float height, AnchorType anchorType){
        float x = 0;
        float y = 0;

        if(
            anchorType == AnchorType.TOP_CENTER ||
            anchorType == AnchorType.MIDDLE_CENTER ||
            anchorType == AnchorType.BOTTOM_CENTER
        ){
            x = -width/2f;
        }

        if(
            anchorType == AnchorType.TOP_RIGHT ||
            anchorType == AnchorType.MIDDLE_RIGHT ||
            anchorType == AnchorType.BOTTOM_RIGHT
        ){
            x = -width;
        }

        if(
            anchorType == AnchorType.MIDDLE_LEFT ||
            anchorType == AnchorType.MIDDLE_CENTER ||
            anchorType == AnchorType.MIDDLE_RIGHT
        ){
            y = -height/2f;
        }

        if(
            anchorType == AnchorType.BOTTOM_LEFT ||
            anchorType == AnchorType.BOTTOM_CENTER ||
            anchorType == AnchorType.BOTTOM_RIGHT
        ){
            y = -height;
        }

        return new class_241(x, y);
    }
}
