package uk.co.cablepost.bb_boat_hud.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.luaj.vm2.LuaTable;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_5455;

public class TextToLuaParser {
    public static LuaTable parse(class_2561 text) {
        JsonObject jsonObject = class_2561.class_2562.method_10874(text, class_5455.field_40585).getAsJsonObject();

        LuaTable luaMessage = new LuaTable();

        List<LuaTable> textLua = new ArrayList<>();
        parseTextJsonToLua(jsonObject, textLua);

        int c = 1;
        for (LuaTable t : textLua) {
            luaMessage.set(c, t);
            c++;
        }

        return luaMessage;
    }

    private static void parseTextJsonToLua(JsonObject jsonObject, List<LuaTable> list){
        String content = "";
        int color = 0xFFFFFFFF;

        if(jsonObject.has("text")){
            content = jsonObject.getAsJsonPrimitive("text").getAsString().replaceAll("뀰", "⭐").replaceAll("[^a-zA-Z0-9\\s!@#$%^&*⭐()\\-=_+\\[\\]{}|;:'\",.<>?/\\\\]", "").trim();
        }

        if(jsonObject.has("color")){
            String colorStr = jsonObject.getAsJsonPrimitive("color").getAsString();

            if(colorStr.startsWith("#")) {
                color = 0xFF000000 | Integer.parseInt(colorStr.substring(1), 16);
            } else if (Objects.equals(colorStr, "dark_red")) {
                color = 0xAA0000;
            } else if (Objects.equals(colorStr, "red")) {
                color = 0xFF5555;
            } else if (Objects.equals(colorStr, "gold")) {
                color = 0xFFAA00;
            } else if (Objects.equals(colorStr, "yellow")) {
                color = 0xFFFF55;
            } else if (Objects.equals(colorStr, "dark_green")) {
                color = 0x00AA00;
            } else if (Objects.equals(colorStr, "green")) {
                color = 0x55FF55;
            } else if (Objects.equals(colorStr, "aqua")) {
                color = 0x55FFFF;
            } else if (Objects.equals(colorStr, "dark_aqua")) {
                color = 0x00AAAA;
            } else if (Objects.equals(colorStr, "dark_blue")) {
                color = 0x0000AA;
            } else if (Objects.equals(colorStr, "blue")) {
                color = 0x5555FF;
            } else if (Objects.equals(colorStr, "light_purple")) {
                color = 0xFF55FF;
            } else if (Objects.equals(colorStr, "dark_purple")) {
                color = 0xAA00AA;
            } else if (Objects.equals(colorStr, "white")) {
                color = 0xFFFFFF;
            } else if (Objects.equals(colorStr, "gray")) {
                color = 0xAAAAAA;
            } else if (Objects.equals(colorStr, "dark_gray")) {
                color = 0x555555;
            } else if (Objects.equals(colorStr, "black")) {
                color = 0x000000;
            }
        }

        if(!content.isEmpty()){
            LuaTable luaTable = new LuaTable();
            luaTable.set("content", content);
            luaTable.set("color", color);
            list.add(luaTable);
        }

        if(jsonObject.has("extra")){
            JsonArray extra = jsonObject.getAsJsonArray("extra");
            for (JsonElement jsonElement : extra) {
                if(jsonElement.isJsonPrimitive()){
                    LuaTable luaTable = new LuaTable();
                    luaTable.set("content", jsonElement.getAsString().trim());
                    luaTable.set("color", 0xFFFFFFFF);
                    list.add(luaTable);
                }
                else{
                    parseTextJsonToLua(jsonElement.getAsJsonObject(), list);
                }
            }
        }
    }
}
