/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bb_boat_hud.client;

import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.awt.Desktop;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_10255;
import net.minecraft.class_1068;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import net.minecraft.class_640;
import net.minecraft.class_746;
import net.minecraft.class_7532;
import net.minecraft.class_7833;
import net.minecraft.class_8685;
import net.minecraft.class_8710;
import net.minecraft.class_9779;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaTable;
import uk.co.cablepost.bb_boat_hud.client.AnchorType;
import uk.co.cablepost.bb_boat_hud.client.HudModule;
import uk.co.cablepost.bb_boat_hud.client.HudModulePlacement;
import uk.co.cablepost.bb_boat_hud.client.PlayerSkinCache;
import uk.co.cablepost.bb_boat_hud.client.ScoreboardPlayerCache;
import uk.co.cablepost.bb_boat_hud.config.ModConfig;
import uk.co.cablepost.bb_boat_hud.mixin.BoatEntityAccess;
import uk.co.cablepost.bb_boat_hud.network.ScoreboardModColumnTypes;
import uk.co.cablepost.bb_boat_hud.network.ScoreboardModOneOffTypes;
import uk.co.cablepost.bb_boat_hud.network.TimingSystemScoreboardModPayload;
import uk.co.cablepost.bb_boat_hud.webui.ConfigWebServer;

public class BbBoatHudClient
implements ClientModInitializer {
    public static Map<class_2960, HudModule> HUD_MODULES = new HashMap<class_2960, HudModule>();
    public static class_640 PLAYER_LIST_ENTRY = null;
    public static class_243 VELOCITY = new class_243(0.0, 0.0, 0.0);
    public static class_243 LAST_VELOCITY = new class_243(0.0, 0.0, 0.0);
    public static class_243 ROTATION_VECTOR = new class_243(0.0, 0.0, 0.0);
    public static class_243 LAST_ROTATION_VECTOR = new class_243(0.0, 0.0, 0.0);
    public static double G = 0.0;
    public static int FPS = 0;
    public static boolean PRESSING_FORWARD = false;
    public static boolean PRESSING_BACK = false;
    public static boolean PRESSING_LEFT = false;
    public static boolean PRESSING_RIGHT = false;
    public static float ANGULAR_VELOCITY = 0.0f;
    public static boolean HORIZONTAL_COLLISION = false;
    public static boolean IN_BOAT = false;
    public static boolean IS_ON_GROUND = true;
    public static boolean MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_RACES = false;
    public static boolean MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_TIME_TRIALS = false;
    public static boolean MODULES_WANT_TO_HIDE_VANILLA_SCOREBOARD = false;
    @Nullable
    public static List<ScoreboardModColumnTypes> LUA_SCOREBOARD_COLUMN_TYPES = null;
    @Nullable
    public static List<ScoreboardModOneOffTypes> LUA_SCOREBOARD_ONE_OFF_TYPES = null;
    @Nullable
    public static LuaTable LUA_SCOREBOARD = null;
    public static Map<UUID, ScoreboardPlayerCache> PLAYER_NAME_CACHE = new HashMap<UUID, ScoreboardPlayerCache>();
    public static Map<UUID, PlayerSkinCache> PLAYER_SKIN_CACHE = new HashMap<UUID, PlayerSkinCache>();
    private static int FRAME_COUNTER = 0;

    public void onInitializeClient() {
        AutoConfig.register(ModConfig.class, GsonConfigSerializer::new);
        ConfigWebServer.start();
        PayloadTypeRegistry.playC2S().register(TimingSystemScoreboardModPayload.ID, TimingSystemScoreboardModPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(TimingSystemScoreboardModPayload.ID, TimingSystemScoreboardModPayload.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(TimingSystemScoreboardModPayload.ID, TimingSystemScoreboardModPayload::handlePacket);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(this){

            public void method_14491(class_3300 manager) {
                HUD_MODULES.clear();
                Map resources = manager.method_14488("bb_boat_hud_modules", path -> path.method_12832().endsWith(".lua"));
                for (Map.Entry resource : resources.entrySet()) {
                    try {
                        InputStream stream = ((class_3298)resource.getValue()).method_14482();
                        try {
                            String str = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                            HudModule hudModule = new HudModule((class_2960)resource.getKey(), str);
                            HUD_MODULES.put((class_2960)resource.getKey(), hudModule);
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Failed to load module: " + String.valueOf(resource.getKey()));
                    }
                }
            }

            public class_2960 getFabricId() {
                return class_2960.method_60655((String)"bb_boat_hud", (String)"bb_boat_hud_modules");
            }
        });
        ClientTickEvents.END_WORLD_TICK.register(clientWorld -> {
            class_746 patt0$temp = class_310.method_1551().field_1724;
            if (patt0$temp instanceof class_746) {
                class_746 player = patt0$temp;
                class_1297 patt1$temp = player.method_5854();
                if (patt1$temp instanceof class_10255) {
                    class_10255 boat = (class_10255)patt1$temp;
                    IN_BOAT = true;
                    class_243 oldHorizontalVelocity = LAST_VELOCITY.method_18805(1.0, 0.0, 1.0);
                    LAST_VELOCITY = VELOCITY;
                    LAST_ROTATION_VECTOR = ROTATION_VECTOR;
                    VELOCITY = boat.method_18798();
                    ROTATION_VECTOR = boat.method_5720();
                    class_243 horizontalVelocity = VELOCITY.method_18805(1.0, 0.0, 1.0);
                    G = (horizontalVelocity.method_1033() - oldHorizontalVelocity.method_1033()) * 2.040816327;
                    BoatEntityAccess boatEntityAccess = (BoatEntityAccess)boat;
                    PRESSING_FORWARD = boatEntityAccess.getPressingForward();
                    PRESSING_BACK = boatEntityAccess.getPressingBack();
                    PRESSING_LEFT = boatEntityAccess.getPressingLeft();
                    PRESSING_RIGHT = boatEntityAccess.getPressingRight();
                    ANGULAR_VELOCITY = boatEntityAccess.getYawVelocity();
                    HORIZONTAL_COLLISION = boat.field_5976;
                    IS_ON_GROUND = boat.method_24828();
                } else {
                    IN_BOAT = false;
                    LAST_VELOCITY = new class_243(0.0, 0.0, 0.0);
                    LAST_ROTATION_VECTOR = new class_243(0.0, 0.0, 0.0);
                    VELOCITY = new class_243(0.0, 0.0, 0.0);
                    ROTATION_VECTOR = new class_243(0.0, 0.0, 0.0);
                    PRESSING_FORWARD = false;
                    PRESSING_BACK = false;
                    PRESSING_LEFT = false;
                    PRESSING_RIGHT = false;
                    ANGULAR_VELOCITY = 0.0f;
                    HORIZONTAL_COLLISION = false;
                    IS_ON_GROUND = true;
                }
                PLAYER_LIST_ENTRY = Objects.requireNonNull(class_310.method_1551().method_1562()).method_2871(player.method_5667());
                FPS = class_310.method_1551().method_47599();
            } else {
                IN_BOAT = false;
                PLAYER_LIST_ENTRY = null;
                FPS = 0;
            }
            ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
            if (config.runLuaOnTick) {
                BbBoatHudClient.runLua(config);
            }
            try {
                BbBoatHudClient.updatePlayerSkinCache();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        HudRenderCallback.EVENT.register((drawContext, renderTickCounter) -> {
            if (class_310.method_1551().field_1690.field_1842) {
                return;
            }
            if (class_310.method_1551().field_1724 instanceof class_746) {
                BbBoatHudClient.renderHud(drawContext, renderTickCounter);
            }
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"bb_boat_hud").executes(context -> {
            if (class_310.method_1551().field_1755 == null || class_310.method_1551().field_1755 instanceof class_408) {
                if (!ConfigWebServer.isRunning()) {
                    ConfigWebServer.start();
                }
                String url = "http://localhost:" + ConfigWebServer.getPort();
                try {
                    Desktop.getDesktop().browse(new URI(url));
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Opening configuration in your browser..."));
                }
                catch (Exception e) {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Config server started at ").method_10852((class_2561)class_2561.method_43470((String)url).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to open"))).method_10958(new class_2558(class_2558.class_2559.field_11749, url)).method_27706(class_124.field_1078).method_27706(class_124.field_1073))).method_10852((class_2561)class_2561.method_43470((String)" (Click to open)")));
                }
            } else {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Cannot open editor as another screen is open"));
            }
            return 0;
        })));
        ClientPlayConnectionEvents.DISCONNECT.register((networkHandler, client) -> {
            MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_RACES = false;
            MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_TIME_TRIALS = false;
            MODULES_WANT_TO_HIDE_VANILLA_SCOREBOARD = false;
            LUA_SCOREBOARD = null;
            LUA_SCOREBOARD_COLUMN_TYPES = null;
            LUA_SCOREBOARD_ONE_OFF_TYPES = null;
            try {
                for (UUID k : PLAYER_NAME_CACHE.keySet()) {
                    if (PLAYER_NAME_CACHE.get(k).name() != null) continue;
                    PLAYER_NAME_CACHE.remove(k);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((client, world) -> {
            MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_RACES = false;
            MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_TIME_TRIALS = false;
            MODULES_WANT_TO_HIDE_VANILLA_SCOREBOARD = false;
            LUA_SCOREBOARD = null;
            LUA_SCOREBOARD_COLUMN_TYPES = null;
            LUA_SCOREBOARD_ONE_OFF_TYPES = null;
            try {
                for (UUID k : PLAYER_NAME_CACHE.keySet()) {
                    if (PLAYER_NAME_CACHE.get(k).name() != null) continue;
                    PLAYER_NAME_CACHE.remove(k);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static void runLua(ModConfig config) {
        boolean modulesWantToHandleCustomScoreboardForRacesBefore = MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_RACES;
        MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_RACES = false;
        boolean modulesWantToHandleCustomScoreboardForTimeTrialsBefore = MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_TIME_TRIALS;
        MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_TIME_TRIALS = false;
        MODULES_WANT_TO_HIDE_VANILLA_SCOREBOARD = false;
        for (HudModule hudModule : HUD_MODULES.values()) {
            if (!config.modulePlacements.stream().anyMatch(x -> class_2960.method_60654((String)x.identifier).equals((Object)hudModule.getIdentifier())) || !hudModule.runOutOfBoat && !IN_BOAT) continue;
            hudModule.runLua();
        }
        if (modulesWantToHandleCustomScoreboardForRacesBefore != MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_RACES || modulesWantToHandleCustomScoreboardForTimeTrialsBefore != MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_TIME_TRIALS) {
            class_2540 packet = PacketByteBufs.create();
            packet.method_52997(0);
            packet.method_53002(1);
            packet.method_52964(MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_RACES);
            packet.method_52964(false);
            packet.method_52964(MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_TIME_TRIALS);
            packet.method_52964(false);
            ClientPlayNetworking.send((class_8710)new TimingSystemScoreboardModPayload(packet));
        }
    }

    public static void renderHud(class_332 drawContext, class_9779 renderTickCounter) {
        int scaledWidth = class_310.method_1551().method_22683().method_4486();
        int scaledHeight = class_310.method_1551().method_22683().method_4502();
        ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        if (!config.runLuaOnTick && ++FRAME_COUNTER >= config.runLuaSkipFrames) {
            BbBoatHudClient.runLua(config);
            FRAME_COUNTER = 0;
        }
        for (HudModulePlacement hudModulePlacement : config.modulePlacements) {
            HudModule hudModule = HUD_MODULES.get(class_2960.method_60654((String)hudModulePlacement.identifier));
            if (hudModule == null || !hudModule.runOutOfBoat && !IN_BOAT) continue;
            BbBoatHudClient.pushMatrix(drawContext.method_51448());
            if (hudModulePlacement.anchorType == AnchorType.TOP_CENTER || hudModulePlacement.anchorType == AnchorType.MIDDLE_CENTER || hudModulePlacement.anchorType == AnchorType.BOTTOM_CENTER) {
                BbBoatHudClient.translateMatrix(drawContext.method_51448(), (float)scaledWidth / 2.0f, 0.0f);
            }
            if (hudModulePlacement.anchorType == AnchorType.TOP_RIGHT || hudModulePlacement.anchorType == AnchorType.MIDDLE_RIGHT || hudModulePlacement.anchorType == AnchorType.BOTTOM_RIGHT) {
                BbBoatHudClient.translateMatrix(drawContext.method_51448(), scaledWidth, 0.0f);
            }
            if (hudModulePlacement.anchorType == AnchorType.MIDDLE_LEFT || hudModulePlacement.anchorType == AnchorType.MIDDLE_CENTER || hudModulePlacement.anchorType == AnchorType.MIDDLE_RIGHT) {
                BbBoatHudClient.translateMatrix(drawContext.method_51448(), 0.0f, (float)scaledHeight / 2.0f);
            }
            if (hudModulePlacement.anchorType == AnchorType.BOTTOM_LEFT || hudModulePlacement.anchorType == AnchorType.BOTTOM_CENTER || hudModulePlacement.anchorType == AnchorType.BOTTOM_RIGHT) {
                BbBoatHudClient.translateMatrix(drawContext.method_51448(), 0.0f, scaledHeight);
            }
            BbBoatHudClient.translateMatrix(drawContext.method_51448(), hudModulePlacement.xOffset, hudModulePlacement.yOffset);
            BbBoatHudClient.scaleMatrix(drawContext.method_51448(), hudModulePlacement.scale, hudModulePlacement.scale);
            if (Math.abs(hudModulePlacement.angle) > 1.0E-5f) {
                BbBoatHudClient.rotateMatrix(drawContext.method_51448(), hudModulePlacement.angle);
            }
            String error = hudModule.render(drawContext);
            BbBoatHudClient.popMatrix(drawContext.method_51448());
            if (error == null) continue;
            BbBoatHudClient.pushMatrix(drawContext.method_51448());
            BbBoatHudClient.scaleMatrix(drawContext.method_51448(), 0.5f, 0.5f);
            String[] msgLines = error.split("\\r?\\n");
            for (int i = 0; i < msgLines.length; ++i) {
                drawContext.method_51439(class_310.method_1551().field_1772, class_2561.method_30163((String)msgLines[i]), 10, 10 * i + 10, -65536, false);
            }
            BbBoatHudClient.popMatrix(drawContext.method_51448());
        }
    }

    public static class_8685 getSkinTexture(UUID playerUuid) {
        PlayerSkinCache playerSkinCache = PLAYER_SKIN_CACHE.computeIfAbsent(playerUuid, PlayerSkinCache::new);
        return playerSkinCache.skinTextures == null ? class_1068.method_4648((UUID)playerUuid) : playerSkinCache.skinTextures;
    }

    private static void updatePlayerSkinCache() {
        PlayerSkinCache playerSkinCache;
        class_310 minecraftClient = class_310.method_1551();
        long now = System.currentTimeMillis();
        for (UUID k : PLAYER_SKIN_CACHE.keySet()) {
            playerSkinCache = PLAYER_SKIN_CACHE.get(k);
            if (playerSkinCache.callApiThread == null) continue;
            if (playerSkinCache.callApiThread.isAlive()) {
                return;
            }
            playerSkinCache.callApiThread = null;
        }
        for (UUID k : PLAYER_SKIN_CACHE.keySet()) {
            Thread thread;
            playerSkinCache = PLAYER_SKIN_CACHE.get(k);
            if (playerSkinCache.skinTextures != null || playerSkinCache.startedApiThread) continue;
            playerSkinCache.callApiThread = thread = new Thread(() -> {
                ProfileResult profileResult = minecraftClient.method_1495().fetchProfile(playerSkinCache.playerUuid, false);
                if (profileResult != null) {
                    minecraftClient.method_1582().method_52862(profileResult.profile());
                }
            });
            playerSkinCache.startedApiThread = true;
            thread.start();
            return;
        }
        for (UUID k : PLAYER_SKIN_CACHE.keySet()) {
            playerSkinCache = PLAYER_SKIN_CACHE.get(k);
            if (playerSkinCache.skinTextures != null || !playerSkinCache.startedApiThread || playerSkinCache.callApiThread != null) continue;
            ProfileResult profileResult = minecraftClient.method_1495().fetchProfile(playerSkinCache.playerUuid, false);
            playerSkinCache.skinTextures = profileResult != null ? minecraftClient.method_1582().method_52862(profileResult.profile()) : class_1068.method_4648((UUID)playerSkinCache.playerUuid);
        }
    }

    public static void drawPlayerHead(class_332 drawContext, UUID playerUuid) {
        class_8685 skinTextures = BbBoatHudClient.getSkinTexture(playerUuid);
        class_7532.method_52722((class_332)drawContext, (class_8685)skinTextures, (int)0, (int)0, (int)16);
    }

    public static void pushMatrix(class_4587 matrixStack) {
        matrixStack.method_22903();
    }

    public static void popMatrix(class_4587 matrixStack) {
        matrixStack.method_22909();
    }

    public static void enableBlend() {
        RenderSystem.enableBlend();
    }

    public static void disableBlend() {
        RenderSystem.disableBlend();
    }

    public static void translateMatrix(class_4587 matrixStack, float x, float y) {
        matrixStack.method_46416(x, y, 0.0f);
    }

    public static void rotateMatrix(class_4587 matrixStack, float deg) {
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(deg));
    }

    public static void scaleMatrix(class_4587 matrixStack, float x, float y) {
        matrixStack.method_22905(x, y, 1.0f);
    }
}

