/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bb_boat_hud.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1921;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.jse.JsePlatform;
import uk.co.cablepost.bb_boat_hud.client.AnchorType;
import uk.co.cablepost.bb_boat_hud.client.BbBoatHudClient;

public class HudModule {
    private final class_2960 identifier;
    private final Globals globals;
    private LuaValue chunk = null;
    public String error = null;
    public boolean runOutOfBoat = false;
    public Map<Integer, class_1109> soundInstances = new HashMap<Integer, class_1109>();
    private List<Consumer<class_332>> drawCalls = new ArrayList<Consumer<class_332>>();

    public HudModule(class_2960 identifier, String luaCode) {
        this.identifier = identifier;
        this.globals = JsePlatform.standardGlobals();
        this.globals.set("offsetPosition", (LuaValue)new offsetPosition());
        this.globals.set("offsetRotation", (LuaValue)new offsetRotation());
        this.globals.set("offsetScale", (LuaValue)new offsetScale());
        this.globals.set("renderText", (LuaValue)new renderText());
        this.globals.set("renderBoatLabsText", (LuaValue)new renderBoatLabsText());
        this.globals.set("renderRect", (LuaValue)new renderRect());
        this.globals.set("renderTexture", (LuaValue)new renderTexture());
        this.globals.set("renderTextureCropped", (LuaValue)new renderTextureCropped());
        this.globals.set("renderPlayerHead", (LuaValue)new renderPlayerHead());
        this.globals.set("playSound", (LuaValue)new playSound());
        this.globals.set("stopSound", (LuaValue)new stopSound());
        try {
            this.chunk = this.globals.load(luaCode);
            this.runLua();
        }
        catch (LuaError e) {
            this.error = "Error loading component: " + identifier.toString() + "\n\n" + e.getMessage();
        }
    }

    public class_2960 getIdentifier() {
        return this.identifier;
    }

    public String render(class_332 drawContext) {
        if (this.error != null) {
            return this.error;
        }
        for (Consumer<class_332> drawCall : this.drawCalls) {
            drawCall.accept(drawContext);
        }
        return null;
    }

    public void runLua() {
        this.drawCalls.clear();
        if (this.chunk == null) {
            return;
        }
        class_243 horizontalVelocity = BbBoatHudClient.VELOCITY.method_18805(1.0, 0.0, 1.0);
        double speed = BbBoatHudClient.VELOCITY.method_1033() * 20.0;
        double horizontalSpeed = horizontalVelocity.method_1033() * 20.0;
        double driftAngle = Math.toDegrees(Math.acos(horizontalVelocity.method_1026(BbBoatHudClient.ROTATION_VECTOR) / horizontalVelocity.method_1033() * BbBoatHudClient.ROTATION_VECTOR.method_1033()));
        if (Double.isNaN(driftAngle)) {
            driftAngle = 0.0;
        }
        this.globals.set("editorMode", (LuaValue)LuaBoolean.FALSE);
        this.globals.set("speed", speed);
        this.globals.set("horizontalSpeed", horizontalSpeed);
        this.globals.set("driftAngle", horizontalVelocity.method_1036((class_243)BbBoatHudClient.ROTATION_VECTOR).field_1351 < 0.0 ? driftAngle : -driftAngle);
        this.globals.set("gForce", (LuaValue)LuaDouble.valueOf((double)((double)Math.round(BbBoatHudClient.G * 1000.0) / 1000.0)));
        this.globals.set("ping", BbBoatHudClient.PLAYER_LIST_ENTRY == null ? 0 : BbBoatHudClient.PLAYER_LIST_ENTRY.method_2959());
        this.globals.set("fps", BbBoatHudClient.FPS);
        this.globals.set("pressingForward", (LuaValue)LuaBoolean.valueOf((boolean)BbBoatHudClient.PRESSING_FORWARD));
        this.globals.set("pressingBack", (LuaValue)LuaBoolean.valueOf((boolean)BbBoatHudClient.PRESSING_BACK));
        this.globals.set("pressingLeft", (LuaValue)LuaBoolean.valueOf((boolean)BbBoatHudClient.PRESSING_LEFT));
        this.globals.set("pressingRight", (LuaValue)LuaBoolean.valueOf((boolean)BbBoatHudClient.PRESSING_RIGHT));
        this.globals.set("angularVelocity", (LuaValue)LuaBoolean.valueOf((double)BbBoatHudClient.ANGULAR_VELOCITY));
        class_746 class_7462 = class_310.method_1551().field_1724;
        if (class_7462 instanceof class_746) {
            class_746 clientPlayer = class_7462;
            this.globals.set("xpLevel", (LuaValue)LuaInteger.valueOf((int)clientPlayer.field_7520));
            this.globals.set("playerName", (LuaValue)LuaString.valueOf((String)clientPlayer.method_7334().getName()));
        } else {
            this.globals.set("xpLevel", (LuaValue)LuaInteger.valueOf((int)0));
            this.globals.set("playerName", (LuaValue)LuaString.valueOf((String)""));
        }
        if (BbBoatHudClient.LUA_SCOREBOARD != null) {
            this.globals.set("timingSystemScoreboard", (LuaValue)BbBoatHudClient.LUA_SCOREBOARD);
        } else {
            this.globals.set("timingSystemScoreboard", (LuaValue)LuaValue.tableOf());
        }
        this.globals.set("horizontalCollision", (LuaValue)LuaBoolean.valueOf((boolean)BbBoatHudClient.HORIZONTAL_COLLISION));
        this.globals.set("isOnGround", (LuaValue)LuaBoolean.valueOf((boolean)BbBoatHudClient.IS_ON_GROUND));
        this.globals.set("isInBoat", (LuaValue)LuaBoolean.valueOf((boolean)BbBoatHudClient.IN_BOAT));
        try {
            this.error = null;
            this.chunk.call();
            this.runOutOfBoat = this.globals.get("runOutOfBoat").isboolean() && this.globals.get("runOutOfBoat").toboolean();
            if (this.globals.get("hookTimingSystemScoreboardForRaces").isboolean() && this.globals.get("hookTimingSystemScoreboardForRaces").toboolean()) {
                BbBoatHudClient.MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_RACES = true;
            }
            if (this.globals.get("hookTimingSystemScoreboardForTimeTrials").isboolean() && this.globals.get("hookTimingSystemScoreboardForTimeTrials").toboolean()) {
                BbBoatHudClient.MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_TIME_TRIALS = true;
            }
            if (this.globals.get("hideVanillaScoreboard").isboolean() && this.globals.get("hideVanillaScoreboard").toboolean()) {
                BbBoatHudClient.MODULES_WANT_TO_HIDE_VANILLA_SCOREBOARD = true;
            }
        }
        catch (LuaError e) {
            this.error = "Error running component: " + String.valueOf(this.identifier) + e.getErrorMessage();
        }
    }

    private static class_241 getOffset(float width, float height, AnchorType anchorType) {
        float x = 0.0f;
        float y = 0.0f;
        if (anchorType == AnchorType.TOP_CENTER || anchorType == AnchorType.MIDDLE_CENTER || anchorType == AnchorType.BOTTOM_CENTER) {
            x = -width / 2.0f;
        }
        if (anchorType == AnchorType.TOP_RIGHT || anchorType == AnchorType.MIDDLE_RIGHT || anchorType == AnchorType.BOTTOM_RIGHT) {
            x = -width;
        }
        if (anchorType == AnchorType.MIDDLE_LEFT || anchorType == AnchorType.MIDDLE_CENTER || anchorType == AnchorType.MIDDLE_RIGHT) {
            y = -height / 2.0f;
        }
        if (anchorType == AnchorType.BOTTOM_LEFT || anchorType == AnchorType.BOTTOM_CENTER || anchorType == AnchorType.BOTTOM_RIGHT) {
            y = -height;
        }
        return new class_241(x, y);
    }

    class offsetPosition
    extends VarArgFunction {
        offsetPosition() {
        }

        public Varargs invoke(Varargs v) {
            int xValue = v.checkint(1);
            int yValue = v.checkint(2);
            LuaFunction funcValue = v.checkfunction(3);
            HudModule.this.drawCalls.add(drawContext -> {
                BbBoatHudClient.pushMatrix(drawContext.method_51448());
                BbBoatHudClient.translateMatrix(drawContext.method_51448(), xValue, yValue);
            });
            funcValue.call();
            HudModule.this.drawCalls.add(drawContext -> BbBoatHudClient.popMatrix(drawContext.method_51448()));
            return LuaValue.NIL;
        }
    }

    class offsetRotation
    extends VarArgFunction {
        offsetRotation() {
        }

        public Varargs invoke(Varargs v) {
            double rot = v.checkdouble(1);
            LuaFunction funcValue = v.checkfunction(2);
            HudModule.this.drawCalls.add(drawContext -> {
                BbBoatHudClient.pushMatrix(drawContext.method_51448());
                BbBoatHudClient.rotateMatrix(drawContext.method_51448(), (float)rot);
            });
            funcValue.call();
            HudModule.this.drawCalls.add(drawContext -> BbBoatHudClient.popMatrix(drawContext.method_51448()));
            return LuaValue.NIL;
        }
    }

    class offsetScale
    extends VarArgFunction {
        offsetScale() {
        }

        public Varargs invoke(Varargs v) {
            double xValue = v.checkdouble(1);
            double yValue = v.checkdouble(2);
            LuaFunction funcValue = v.checkfunction(3);
            HudModule.this.drawCalls.add(drawContext -> {
                BbBoatHudClient.pushMatrix(drawContext.method_51448());
                BbBoatHudClient.scaleMatrix(drawContext.method_51448(), (float)xValue, (float)yValue);
            });
            funcValue.call();
            HudModule.this.drawCalls.add(drawContext -> BbBoatHudClient.popMatrix(drawContext.method_51448()));
            return LuaValue.NIL;
        }
    }

    class renderText
    extends VarArgFunction {
        renderText() {
        }

        public Varargs invoke(Varargs v) {
            String msgValue = v.checkjstring(1);
            int colorValue = v.checkint(2);
            boolean shadowValue = v.checkboolean(3);
            AnchorType anchorValue = AnchorType.valueOf(v.checkjstring(4));
            class_2561 text = class_2561.method_30163((String)msgValue);
            HudModule.this.drawCalls.add(drawContext -> {
                int width = class_310.method_1551().field_1772.method_27525((class_5348)text);
                Objects.requireNonNull(class_310.method_1551().field_1772);
                int height = 9;
                class_241 offset = HudModule.getOffset(width, height, anchorValue);
                drawContext.method_51439(class_310.method_1551().field_1772, text, (int)offset.field_1343, (int)offset.field_1342, colorValue, shadowValue);
            });
            return LuaValue.NIL;
        }
    }

    class renderBoatLabsText
    extends VarArgFunction {
        renderBoatLabsText() {
        }

        public Varargs invoke(Varargs v) {
            String msgValue = v.checkjstring(1);
            int colorValue = v.checkint(2);
            boolean shadowValue = v.checkboolean(3);
            AnchorType anchorValue = AnchorType.valueOf(v.checkjstring(4));
            class_5250 text = class_2561.method_30163((String)msgValue).method_27661().method_10862(class_2583.field_24360.method_27704(class_2960.method_60655((String)"boatlabs", (String)"boatlabs")));
            HudModule.this.drawCalls.add(arg_0 -> renderBoatLabsText.lambda$invoke$0((class_2561)text, anchorValue, colorValue, shadowValue, arg_0));
            return LuaValue.NIL;
        }

        private static /* synthetic */ void lambda$invoke$0(class_2561 text, AnchorType anchorValue, int colorValue, boolean shadowValue, class_332 drawContext) {
            int width = class_310.method_1551().field_1772.method_27525((class_5348)text);
            Objects.requireNonNull(class_310.method_1551().field_1772);
            int height = 9;
            class_241 offset = HudModule.getOffset(width, height, anchorValue);
            drawContext.method_51439(class_310.method_1551().field_1772, text, (int)offset.field_1343, (int)offset.field_1342, colorValue, shadowValue);
        }
    }

    class renderRect
    extends VarArgFunction {
        renderRect() {
        }

        public Varargs invoke(Varargs v) {
            int widthValue = (int)Math.round(v.checkdouble(1) * 10.0);
            int heightValue = (int)Math.round(v.checkdouble(2) * 10.0);
            int colorValue = v.checkint(3);
            AnchorType anchorValue = AnchorType.valueOf(v.checkjstring(4));
            HudModule.this.drawCalls.add(drawContext -> {
                class_241 offset = HudModule.getOffset(widthValue, heightValue, anchorValue);
                BbBoatHudClient.pushMatrix(drawContext.method_51448());
                BbBoatHudClient.scaleMatrix(drawContext.method_51448(), 0.1f, 0.1f);
                BbBoatHudClient.enableBlend();
                drawContext.method_25294((int)offset.field_1343, (int)offset.field_1342, (int)offset.field_1343 + widthValue, (int)offset.field_1342 + heightValue, colorValue);
                BbBoatHudClient.disableBlend();
                BbBoatHudClient.popMatrix(drawContext.method_51448());
            });
            return LuaValue.NIL;
        }
    }

    class renderTexture
    extends VarArgFunction {
        renderTexture() {
        }

        public Varargs invoke(Varargs v) {
            String idValue = v.checkjstring(1);
            int widthValue = v.checkint(2);
            int heightValue = v.checkint(3);
            AnchorType anchorValue = AnchorType.valueOf(v.checkjstring(4));
            HudModule.this.drawCalls.add(drawContext -> {
                class_241 offset = HudModule.getOffset(1.0f, 1.0f, anchorValue);
                BbBoatHudClient.pushMatrix(drawContext.method_51448());
                BbBoatHudClient.scaleMatrix(drawContext.method_51448(), widthValue, heightValue);
                BbBoatHudClient.translateMatrix(drawContext.method_51448(), offset.field_1343, offset.field_1342);
                BbBoatHudClient.enableBlend();
                drawContext.method_25290(class_1921::method_62277, class_2960.method_60655((String)HudModule.this.identifier.method_12836(), (String)("textures/bb_boat_hud_modules/" + idValue)), 0, 0, 0.0f, 0.0f, 1, 1, 1, 1);
                BbBoatHudClient.disableBlend();
                BbBoatHudClient.popMatrix(drawContext.method_51448());
            });
            return LuaValue.NIL;
        }
    }

    class renderTextureCropped
    extends VarArgFunction {
        renderTextureCropped() {
        }

        public Varargs invoke(Varargs v) {
            String idValue = v.checkjstring(1);
            int widthValue = v.checkint(2);
            int heightValue = v.checkint(3);
            int cropStartX_value = v.checkint(4);
            int cropStartY_value = v.checkint(5);
            int cropSizeX_value = v.checkint(6);
            int cropSizeY_value = v.checkint(7);
            AnchorType anchorValue = AnchorType.valueOf(v.checkjstring(8));
            HudModule.this.drawCalls.add(drawContext -> {
                class_241 offset = HudModule.getOffset(1.0f, 1.0f, anchorValue);
                BbBoatHudClient.pushMatrix(drawContext.method_51448());
                BbBoatHudClient.translateMatrix(drawContext.method_51448(), offset.field_1343 * (float)widthValue, offset.field_1342 * (float)heightValue);
                BbBoatHudClient.enableBlend();
                drawContext.method_25290(class_1921::method_62277, class_2960.method_60655((String)HudModule.this.identifier.method_12836(), (String)("textures/bb_boat_hud_modules/" + idValue)), cropStartX_value, cropStartY_value, (float)cropStartX_value, (float)cropStartY_value, cropSizeX_value, cropSizeY_value, widthValue, heightValue);
                BbBoatHudClient.disableBlend();
                BbBoatHudClient.popMatrix(drawContext.method_51448());
            });
            return LuaValue.NIL;
        }
    }

    class renderPlayerHead
    extends VarArgFunction {
        renderPlayerHead() {
        }

        public Varargs invoke(Varargs v) {
            String playerUuid = v.checkjstring(1);
            AnchorType anchorValue = AnchorType.valueOf(v.checkjstring(2));
            HudModule.this.drawCalls.add(drawContext -> {
                class_241 offset = HudModule.getOffset(16.0f, 16.0f, anchorValue);
                BbBoatHudClient.pushMatrix(drawContext.method_51448());
                BbBoatHudClient.translateMatrix(drawContext.method_51448(), offset.field_1343, offset.field_1342);
                BbBoatHudClient.enableBlend();
                BbBoatHudClient.drawPlayerHead(drawContext, UUID.fromString(playerUuid));
                BbBoatHudClient.disableBlend();
                BbBoatHudClient.popMatrix(drawContext.method_51448());
            });
            return LuaValue.NIL;
        }
    }

    class playSound
    extends VarArgFunction {
        playSound() {
        }

        public Varargs invoke(Varargs v) {
            String idValue = v.checkjstring(1);
            double volumeValue = v.checkdouble(2);
            double pitchValue = v.checkdouble(3);
            class_2960 soundIdentifier = class_2960.method_60655((String)HudModule.this.identifier.method_12836(), (String)idValue);
            class_1109 soundInstance = new class_1109(soundIdentifier, class_3419.field_15247, (float)volumeValue, (float)pitchValue, class_1113.method_43221(), false, 0, class_1113.class_1114.field_5476, 0.0, 0.0, 0.0, true);
            class_310.method_1551().method_1483().method_4873((class_1113)soundInstance);
            if (class_310.method_1551().field_1687 != null) {
                int soundId = class_310.method_1551().field_1687.field_9229.method_43054();
                HudModule.this.soundInstances.put(soundId, soundInstance);
                return LuaNumber.valueOf((int)soundId);
            }
            return LuaValue.NIL;
        }
    }

    class stopSound
    extends VarArgFunction {
        stopSound() {
        }

        public Varargs invoke(Varargs v) {
            int soundId = v.checkint(1);
            class_1109 soundInstance = HudModule.this.soundInstances.get(soundId);
            if (soundInstance != null) {
                class_310.method_1551().method_1483().method_4870((class_1113)soundInstance);
                HudModule.this.soundInstances.remove(soundId);
            }
            return LuaValue.NIL;
        }
    }
}

