renderTexture("hibii/background.png", 182, 31, "MIDDLE_CENTER")

offsetPosition(-60, 5, function()
    offsetPosition(-2, 0, function()
        if(pressingLeft) then
            renderTexture("hibii/left_on.png", 17, 8, "MIDDLE_RIGHT")
        else
            renderTexture("hibii/left_off.png", 17, 8, "MIDDLE_RIGHT")
        end
    end)

    offsetPosition(2, 0, function()
        if(pressingRight) then
            renderTexture("hibii/right_on.png", 17, 8, "MIDDLE_LEFT")
        else
            renderTexture("hibii/right_off.png", 17, 8, "MIDDLE_LEFT")
        end
    end)
end)

offsetPosition(0, 16, function()
    if(pressingForward) then
        renderTexture("hibii/forward_on.png", 61, 5, "MIDDLE_LEFT")
    else
        renderTexture("hibii/forward_off.png", 61, 5, "MIDDLE_LEFT")
    end

    if(pressingBack) then
        renderTexture("hibii/back_on.png", 61, 5, "MIDDLE_RIGHT")
    else
        renderTexture("hibii/back_off.png", 61, 5, "MIDDLE_RIGHT")
    end
end)

offsetPosition(0, -16, function()
    renderTexture("hibii/speedometer_empty.png", 182, 5, "TOP_CENTER")

    local speedCrop = speed * 2.3
    if(speedCrop > 182) then
        speedCrop = 182
    end

    renderTextureCropped("hibii/speedometer_full.png", 182, 5, 0, 0, speedCrop, 5, "TOP_CENTER")
end)

-- Speed label
offsetPosition(-60, -5, function()
    renderText(
        string.format("%00i", speed) .. " m/s",
        0xFFFFFFFF,
        true,
        "MIDDLE_CENTER"
    )
end)

-- drift angle label
offsetPosition(0, -5, function()
    renderText(
        string.format("%00i", math.abs(driftAngle)) .. " °",
        0xFFFFFFFF,
        true,
        "MIDDLE_CENTER"
    )
end)

-- gForce label
local gForceRounded = tonumber(string.format("%00i", math.abs(gForce) * 100)) / 100
offsetPosition(60, -5, function()
    renderText(
        gForceRounded .. " g",
        0xFFFFFFFF,
        true,
        "MIDDLE_CENTER"
    )
end)

-- ping icon
offsetPosition(30, 7, function()
    local tex = "hibii/ping_0.png"

    if(ping <= 10) then
        tex = "hibii/ping_5.png"
    elseif(ping < 150) then
        tex = "hibii/ping_4.png"
    elseif(ping < 300) then
        tex = "hibii/ping_3.png"
    elseif(ping < 600) then
        tex = "hibii/ping_2.png"
    elseif(ping < 1000) then
        tex = "hibii/ping_1.png"
    end

    renderTexture(tex, 10, 7, "MIDDLE_CENTER")
end)

-- player name label
offsetPosition(40, 7, function()
    renderText(
        playerName,
        0xFFFFFFFF,
        true,
        "MIDDLE_LEFT"
    )
end)
