local totalTimeStr = ""
local totalTimeColor = 0xFFFFFFFF

local splitTimeStr = ""
local splitTimeColor = 0xFFFFFFFF

if(editorMode) then
    totalTimeStr = "00:00.00"
    totalTimeColor = 0xFFFFFF00
    splitTimeStr = "-01.00"
    splitTimeColor = 0xFF0000
else
    if(#overlayMessage == 1) then
        local overlayMessageSplit = {}
        for s in overlayMessage[1].content:gmatch("%S+") do
            table.insert(overlayMessageSplit, s)
        end

        totalTimeColor = overlayMessage[1].color
        splitTimeColor = overlayMessage[1].color

        totalTimeStr = overlayMessageSplit[1]

        if(string.find(totalTimeColor, "%.") == false) then
            -- Not in a time trial
            return
        end

        if(#overlayMessageSplit == 2) then
            splitTimeStr = overlayMessageSplit[2]
        end
    elseif(#overlayMessage == 2 and overlayMessage[2].content ~= "⭐") then
        totalTimeStr = overlayMessage[1].content
        totalTimeColor = overlayMessage[1].color

        splitTimeStr = overlayMessage[2].content
        splitTimeColor = overlayMessage[2].color
    else
        return
    end
end

renderRect(100, 15, 0x55666666, "MIDDLE_CENTER")

offsetPosition(-47, 0, function()
    renderText(
        totalTimeStr,
        totalTimeColor,
        false,
        "MIDDLE_LEFT"
    )
end)

offsetPosition(47, 0, function()
    renderText(
        splitTimeStr,
        splitTimeColor,
        false,
        "MIDDLE_RIGHT"
    )
end)