/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bb_boat_hud.webui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import uk.co.cablepost.bb_boat_hud.client.AnchorType;
import uk.co.cablepost.bb_boat_hud.client.BbBoatHudClient;
import uk.co.cablepost.bb_boat_hud.client.HudModule;
import uk.co.cablepost.bb_boat_hud.client.HudModulePlacement;
import uk.co.cablepost.bb_boat_hud.config.ModConfig;
import uk.co.cablepost.bb_boat_hud.webui.WebUI;

public class ConfigWebServer {
    private static Thread serverThread;
    private static volatile boolean running;
    private static final int PORT = 8765;
    private static final Gson gson;

    public static void start() {
        if (running) {
            return;
        }
        running = true;
        serverThread = new Thread(() -> {
            try (ServerSocket serverSocket = new ServerSocket(8765);){
                System.out.println("BB Boat HUD Config Server started on http://localhost:8765");
                while (running) {
                    try {
                        Socket socket = serverSocket.accept();
                        new Thread(() -> ConfigWebServer.handleClient(socket)).start();
                    }
                    catch (Exception e) {
                        if (!running) continue;
                        System.err.println("Error accepting connection: " + e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Failed to start config web server: " + e.getMessage());
            }
        });
        serverThread.setDaemon(true);
        serverThread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void handleClient(Socket socket) {
        try (Socket socket2 = socket;
             BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
             PrintWriter out = new PrintWriter(socket.getOutputStream(), true);){
            String line;
            String requestLine = in.readLine();
            if (requestLine == null) {
                return;
            }
            String[] parts = requestLine.split(" ");
            if (parts.length < 2) {
                return;
            }
            String method = parts[0];
            String fullUrl = parts[1];
            String path = fullUrl.contains("?") ? fullUrl.substring(0, fullUrl.indexOf("?")) : fullUrl;
            HashMap<String, String> headers = new HashMap<String, String>();
            while ((line = in.readLine()) != null && !line.isEmpty()) {
                int colonIndex = line.indexOf(58);
                if (colonIndex <= 0) continue;
                headers.put(line.substring(0, colonIndex).trim().toLowerCase(), line.substring(colonIndex + 1).trim());
            }
            String body = null;
            if (headers.containsKey("content-length")) {
                int contentLength = Integer.parseInt((String)headers.get("content-length"));
                char[] bodyChars = new char[contentLength];
                in.read(bodyChars, 0, contentLength);
                body = new String(bodyChars);
            }
            ConfigWebServer.handleRequest(method, path, fullUrl, body, out);
            return;
        }
        catch (Exception e) {
            System.err.println("Error handling client: " + e.getMessage());
        }
    }

    private static void handleRequest(String method, String path, String fullUrl, String body, PrintWriter out) {
        try {
            if ("OPTIONS".equals(method)) {
                ConfigWebServer.sendResponse(out, 200, "", "text/plain");
                return;
            }
            if ("/".equals(path) && "GET".equals(method)) {
                ConfigWebServer.sendResponse(out, 200, WebUI.getHTML(), "text/html");
            } else if ("/script.js".equals(path) && "GET".equals(method)) {
                ConfigWebServer.sendResponse(out, 200, WebUI.getJS(), "text/javascript");
            } else if ("/style.css".equals(path) && "GET".equals(method)) {
                ConfigWebServer.sendResponse(out, 200, WebUI.getCSS(), "text/css");
            } else if ("/api/config".equals(path) && "GET".equals(method)) {
                ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
                String json = gson.toJson((Object)config);
                ConfigWebServer.sendResponse(out, 200, json, "application/json");
            } else if ("/api/modules".equals(path) && "GET".equals(method)) {
                HashMap modules = new HashMap();
                for (Map.Entry<class_2960, HudModule> entry : BbBoatHudClient.HUD_MODULES.entrySet()) {
                    String name = entry.getKey().toString();
                    String[] splitByColon = name.split(":");
                    ArrayList<String> pathParts = new ArrayList<String>();
                    pathParts.add(splitByColon[0]);
                    if (splitByColon.length > 1) {
                        pathParts.addAll(Arrays.stream(splitByColon[1].split("/")).skip(1L).toList());
                    }
                    modules.put(name, pathParts);
                }
                String json = gson.toJson(modules);
                ConfigWebServer.sendResponse(out, 200, json, "application/json");
            } else if ("/api/modules/placements".equals(path) && "POST".equals(method)) {
                HudModulePlacement[] placements = (HudModulePlacement[])gson.fromJson(body, HudModulePlacement[].class);
                class_310.method_1551().execute(() -> {
                    ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
                    config.modulePlacements = new ArrayList<HudModulePlacement>(Arrays.asList(placements));
                    AutoConfig.getConfigHolder(ModConfig.class).save();
                });
                ConfigWebServer.sendResponse(out, 200, "{\"success\": true}", "application/json");
            } else if ("/api/modules/add".equals(path) && "POST".equals(method)) {
                Map data = (Map)gson.fromJson(body, Map.class);
                String identifier = (String)data.get("identifier");
                class_310.method_1551().execute(() -> {
                    HudModulePlacement placement = new HudModulePlacement();
                    placement.identifier = identifier;
                    placement.anchorType = AnchorType.MIDDLE_CENTER;
                    placement.xOffset = 0;
                    placement.yOffset = 0;
                    placement.scale = 1.0f;
                    placement.angle = 0.0f;
                    ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
                    config.modulePlacements.add(placement);
                    AutoConfig.getConfigHolder(ModConfig.class).save();
                });
                ConfigWebServer.sendResponse(out, 200, "{\"success\": true}", "application/json");
            } else if ("/api/vanilla".equals(path) && "POST".equals(method)) {
                ModConfig newConfig = (ModConfig)gson.fromJson(body, ModConfig.class);
                class_310.method_1551().execute(() -> {
                    ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
                    config.hotbar = newConfig.hotbar;
                    config.experienceBar = newConfig.experienceBar;
                    config.experienceLevel = newConfig.experienceLevel;
                    config.heldItemTooltip = newConfig.heldItemTooltip;
                    config.armorBar = newConfig.armorBar;
                    config.healthBar = newConfig.healthBar;
                    config.foodBar = newConfig.foodBar;
                    config.oxygenBar = newConfig.oxygenBar;
                    config.bossBar = newConfig.bossBar;
                    config.overlayMessage = newConfig.overlayMessage;
                    AutoConfig.getConfigHolder(ModConfig.class).save();
                });
                ConfigWebServer.sendResponse(out, 200, "{\"success\": true}", "application/json");
            } else {
                ConfigWebServer.sendResponse(out, 404, "Not Found", "text/plain");
            }
        }
        catch (Exception e) {
            System.err.println("Error processing request: " + e.getMessage());
            e.printStackTrace();
            ConfigWebServer.sendResponse(out, 500, "Internal Server Error", "text/plain");
        }
    }

    private static void sendResponse(PrintWriter out, int statusCode, String body, String contentType) {
        out.println("HTTP/1.1 " + statusCode + " " + ConfigWebServer.getStatusMessage(statusCode));
        out.println("Content-Type: " + contentType + "; charset=UTF-8");
        out.println("Content-Length: " + body.getBytes(StandardCharsets.UTF_8).length);
        out.println("Access-Control-Allow-Origin: *");
        out.println("Access-Control-Allow-Methods: GET, POST, OPTIONS");
        out.println("Access-Control-Allow-Headers: Content-Type");
        out.println("Connection: close");
        out.println();
        out.print(body);
        out.flush();
    }

    private static String getStatusMessage(int statusCode) {
        return switch (statusCode) {
            case 200 -> "OK";
            case 404 -> "Not Found";
            case 405 -> "Method Not Allowed";
            case 500 -> "Internal Server Error";
            default -> "Unknown";
        };
    }

    public static void stop() {
        running = false;
        if (serverThread != null) {
            serverThread.interrupt();
            serverThread = null;
        }
        System.out.println("BB Boat HUD Config Server stopped");
    }

    public static boolean isRunning() {
        return running;
    }

    public static int getPort() {
        return 8765;
    }

    static {
        running = false;
        gson = new GsonBuilder().setPrettyPrinting().create();
    }
}

