local totalTimeStr = ""
local totalTimeColor = 0xFFFFFFFF

local splitTimeStr = ""
local splitTimeColor = 0xFFFFFFFF

if(editorMode) then
    totalTimeStr = "00:00.00"
    totalTimeColor = 0xFFFFFF00
    splitTimeStr = "-01.00"
    splitTimeColor = 0xFF0000
elseif(#overlayMessage == 1) then
    local overlayMessageSplit = {}
    for s in overlayMessage[1].content:gmatch("%S+") do
        table.insert(overlayMessageSplit, s)
    end

    totalTimeColor = overlayMessage[1].color
    splitTimeColor = overlayMessage[1].color

    totalTimeStr = overlayMessageSplit[1]

    if(string.find(totalTimeColor, "%.") == false) then
        -- Not in a time trial
        return
    end

    if(#overlayMessageSplit == 2) then
        splitTimeStr = overlayMessageSplit[2]
    end
elseif(#overlayMessage == 2 and overlayMessage[2].content ~= "⭐") then
    totalTimeStr = overlayMessage[1].content
    totalTimeColor = overlayMessage[1].color

    splitTimeStr = overlayMessage[2].content
    splitTimeColor = overlayMessage[2].color
elseif((#overlayMessage == 8 or #overlayMessage == 9) and overlayMessage[1].content == "Lap:") then
    totalTimeStr = overlayMessage[8].content

    if(#overlayMessage == 9) then
        splitTimeStr = overlayMessage[9].content
        splitTimeColor = overlayMessage[9].color
    end
else
    return
end


offsetScale(0.4, 0.4, function()
    offsetRotation(45, function()
        renderTexture("bodkin_boats/diamonds/background.png", 128, 128, "MIDDLE_CENTER")
    end)
end)

offsetPosition(0, -5.5, function()
    renderText(
        totalTimeStr,
        totalTimeColor,
        false,
        "MIDDLE_CENTER"
    )
end)

offsetPosition(0, 8.5, function()
    offsetScale(0.8, 0.8, function()
        renderText(
            splitTimeStr,
            splitTimeColor,
            false,
            "MIDDLE_CENTER"
        )
    end)
end)