package uk.co.cablepost.bb_boat_hud.client;

import com.mojang.authlib.yggdrasil.ProfileResult;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10255;
import net.minecraft.class_1068;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_640;
import net.minecraft.class_746;
import net.minecraft.class_7532;
import net.minecraft.class_7833;
import net.minecraft.class_8685;
import net.minecraft.class_9779;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaTable;
import uk.co.cablepost.bb_boat_hud.BbBoatHud;
import uk.co.cablepost.bb_boat_hud.config.ModConfig;
import uk.co.cablepost.bb_boat_hud.mixin.BoatEntityAccess;
import uk.co.cablepost.bb_boat_hud.network.ScoreboardModColumnTypes;
import uk.co.cablepost.bb_boat_hud.network.ScoreboardModOneOffTypes;
import uk.co.cablepost.bb_boat_hud.network.TimingSystemScoreboardModPayload;
import uk.co.cablepost.bb_boat_hud.webui.ConfigWebServer;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.*;

public class BbBoatHudClient implements ClientModInitializer {
    public static Map<class_2960, HudModule> HUD_MODULES = new HashMap<>();

    public static class_640 PLAYER_LIST_ENTRY = null;
    public static class_243 VELOCITY = new class_243(0, 0, 0);
    public static class_243 LAST_VELOCITY = new class_243(0, 0, 0);
    public static class_243 ROTATION_VECTOR = new class_243(0, 0, 0);
    public static class_243 LAST_ROTATION_VECTOR = new class_243(0, 0, 0);
    public static double G = 0d;
    public static int FPS = 0;
    public static boolean PRESSING_FORWARD = false;
    public static boolean PRESSING_BACK = false;
    public static boolean PRESSING_LEFT = false;
    public static boolean PRESSING_RIGHT = false;
    public static float ANGULAR_VELOCITY = 0f;
    public static @Nullable LuaTable LUA_OVERLAY_MESSAGE = null;
    public static boolean HORIZONTAL_COLLISION = false;
    public static boolean IN_BOAT = false;
    public static boolean IS_ON_GROUND = true;

    public static boolean MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_RACES = false;
    public static boolean MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_TIME_TRIALS = false;

    public static @Nullable List<ScoreboardModColumnTypes> LUA_SCOREBOARD_COLUMN_TYPES = null;
    public static @Nullable List<ScoreboardModOneOffTypes> LUA_SCOREBOARD_ONE_OFF_TYPES = null;
    public static @Nullable LuaTable LUA_SCOREBOARD = null;

    public static Map<UUID, ScoreboardPlayerCache> PLAYER_NAME_CACHE = new HashMap<>();
    public static Map<UUID, PlayerSkinCache> PLAYER_SKIN_CACHE = new HashMap<>();

    private static int FRAME_COUNTER = 0;

    @Override
    public void onInitializeClient() {
        AutoConfig.register(ModConfig.class, GsonConfigSerializer::new);

        // Start web server for configuration
        ConfigWebServer.start();

        PayloadTypeRegistry.playC2S().register(TimingSystemScoreboardModPayload.ID, TimingSystemScoreboardModPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(TimingSystemScoreboardModPayload.ID, TimingSystemScoreboardModPayload.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(TimingSystemScoreboardModPayload.ID, TimingSystemScoreboardModPayload::handlePacket);

        ResourceManagerHelper.get(class_3264.field_14188).registerReloadListener(
            new SimpleSynchronousResourceReloadListener() {
                @Override
                public void method_14491(class_3300 manager) {
                    HUD_MODULES.clear();

                    Map<class_2960, class_3298> resources = manager.method_14488("bb_boat_hud_modules", path -> path.method_12832().endsWith(".lua"));

                    for(Map.Entry<class_2960, class_3298> resource : resources.entrySet()) {
                        try(InputStream stream = resource.getValue().method_14482()) {
                            String str = IOUtils.toString(stream, StandardCharsets.UTF_8);
                            HudModule hudModule = new HudModule(resource.getKey(), str);
                            HUD_MODULES.put(resource.getKey(), hudModule);
                        } catch(Exception e) {
                            // TODO
                            System.out.println("Failed to load module: " + resource.getKey());
                        }
                    }
                }

                @Override
                public class_2960 getFabricId() {
                    return class_2960.method_60655(BbBoatHud.MOD_ID, "bb_boat_hud_modules");
                }
            }
        );

        ClientTickEvents.END_WORLD_TICK.register(clientWorld -> {
            if (
                class_310.method_1551().field_1724 instanceof class_746 player
            ) {
                if(
                    //? if <1.21.3 {
                    /*player.getVehicle() instanceof BoatEntity boat
                     *///?}
                    //? if >=1.21.3 {
                    player.method_5854() instanceof class_10255 boat
                    //?}
                ){
                    IN_BOAT = true;

                    class_243 oldHorizontalVelocity = LAST_VELOCITY.method_18805(1, 0, 1);

                    LAST_VELOCITY = VELOCITY;
                    LAST_ROTATION_VECTOR = ROTATION_VECTOR;

                    VELOCITY = boat.method_18798();
                    ROTATION_VECTOR = boat.method_5720();

                    class_243 horizontalVelocity = VELOCITY.method_18805(1, 0, 1);
                    G = (horizontalVelocity.method_1033() - oldHorizontalVelocity.method_1033()) * 2.040816327d; // 20 tps / 9.8 m/s²

                    BoatEntityAccess boatEntityAccess = (BoatEntityAccess) boat;
                    PRESSING_FORWARD = boatEntityAccess.getPressingForward();
                    PRESSING_BACK = boatEntityAccess.getPressingBack();
                    PRESSING_LEFT = boatEntityAccess.getPressingLeft();
                    PRESSING_RIGHT = boatEntityAccess.getPressingRight();

                    ANGULAR_VELOCITY = boatEntityAccess.getYawVelocity();

                    HORIZONTAL_COLLISION = boat.field_5976;

                    IS_ON_GROUND = boat.method_24828();
                }
                else{
                    IN_BOAT = false;

                    LAST_VELOCITY = new class_243(0, 0, 0);
                    LAST_ROTATION_VECTOR = new class_243(0, 0, 0);

                    VELOCITY = new class_243(0, 0, 0);
                    ROTATION_VECTOR = new class_243(0, 0, 0);

                    PRESSING_FORWARD = false;
                    PRESSING_BACK = false;
                    PRESSING_LEFT = false;
                    PRESSING_RIGHT = false;

                    ANGULAR_VELOCITY = 0f;

                    HORIZONTAL_COLLISION = false;

                    IS_ON_GROUND = true;
                }

                PLAYER_LIST_ENTRY = Objects.requireNonNull(class_310.method_1551().method_1562()).method_2871(player.method_5667());

                FPS = class_310.method_1551().method_47599();

                if(
                    class_310.method_1551().field_1705.field_2018 instanceof class_2561 text &&
                    class_310.method_1551().field_1705.field_2041 > 0
                ) {
                    try {
                        LUA_OVERLAY_MESSAGE = TextToLuaParser.parse(text);
                    }
                    catch (Exception ignored){
                        LUA_OVERLAY_MESSAGE = null;
                    }
                }
                else{
                    LUA_OVERLAY_MESSAGE = null;
                }
            }
            else{
                IN_BOAT = false;
                PLAYER_LIST_ENTRY = null;
                FPS = 0;
                LUA_OVERLAY_MESSAGE = null;
            }

            ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();
            if(config.runLuaOnTick) {
                runLua(config);
            }

            try {
                updatePlayerSkinCache();
            }catch (Exception ignored){}
        });

        HudRenderCallback.EVENT.register((drawContext, renderTickCounter) -> {
            if(class_310.method_1551().field_1690.field_1842){
                return;
            }

            // No longer opening editor screen here - use web UI instead

            if (class_310.method_1551().field_1724 instanceof class_746) {
                renderHud(drawContext, renderTickCounter);
            }
        });

        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register(
            ClientCommandManager.literal("bb_boat_hud").executes(context -> {
                if(
                    (
                        class_310.method_1551().field_1755 == null ||
                        class_310.method_1551().field_1755 instanceof class_408
                    )
                ) {
                    // Start web server if not running
                    if (!ConfigWebServer.isRunning()) {
                        ConfigWebServer.start();
                    }
                    
                    // Open browser to configuration page
                    String url = "http://localhost:" + ConfigWebServer.getPort();
                    try {
                        java.awt.Desktop.getDesktop().browse(new java.net.URI(url));
                        context.getSource().sendFeedback(class_2561.method_43470("Opening configuration in your browser..."));
                    } catch (Exception e) {
                        context.getSource().sendFeedback(
                            class_2561.method_43470("Config server started at ")
                                .method_10852(class_2561.method_43470(url).method_27694(style ->
                                    style
                                        .method_10949(new class_2568(class_2568.class_5247.field_24342, class_2561.method_43470("Click to open")))
                                        .method_10958(new class_2558(class_2558.class_2559.field_11749, url))
                                        .method_27706(class_124.field_1078)
                                        .method_27706(class_124.field_1073)
                                ))
                                .method_10852(class_2561.method_43470(" (Click to open)"))
                        );
                    }
                }
                else{
                    context.getSource().sendFeedback(class_2561.method_43470("Cannot open editor as another screen is open"));
                }

                return 0;
            })
        ));

        ClientPlayConnectionEvents.DISCONNECT.register((networkHandler, client) -> {
            MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_RACES = false;
            MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_TIME_TRIALS = false;
            LUA_SCOREBOARD = null;
            LUA_SCOREBOARD_COLUMN_TYPES = null;
            LUA_SCOREBOARD_ONE_OFF_TYPES = null;

            try {
                for (var k : PLAYER_NAME_CACHE.keySet()) {
                    if (PLAYER_NAME_CACHE.get(k).name() == null) {
                        PLAYER_NAME_CACHE.remove(k);
                    }
                }
            }catch (Exception ignored){}
        });

        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((client, world) -> {
            MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_RACES = false;
            MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_TIME_TRIALS = false;
            LUA_SCOREBOARD = null;
            LUA_SCOREBOARD_COLUMN_TYPES = null;
            LUA_SCOREBOARD_ONE_OFF_TYPES = null;

            try {
                for (var k : PLAYER_NAME_CACHE.keySet()) {
                    if (PLAYER_NAME_CACHE.get(k).name() == null) {
                        PLAYER_NAME_CACHE.remove(k);
                    }
                }
            }catch (Exception ignored){}
        });
    }

    public static void runLua(ModConfig config){
        boolean modulesWantToHandleCustomScoreboardForRacesBefore = MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_RACES;
        MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_RACES = false;

        boolean modulesWantToHandleCustomScoreboardForTimeTrialsBefore = MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_TIME_TRIALS;
        MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_TIME_TRIALS = false;

        for(var hudModule : HUD_MODULES.values()) {
            if(config.modulePlacements.stream().anyMatch(x -> class_2960.method_60654(x.identifier).equals(hudModule.getIdentifier()))){
                if(hudModule.runOutOfBoat || IN_BOAT) {
                    hudModule.runLua();
                }
            }
        }

        if(
            modulesWantToHandleCustomScoreboardForRacesBefore != MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_RACES ||
            modulesWantToHandleCustomScoreboardForTimeTrialsBefore != MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_TIME_TRIALS
        ){
            // A setting has changed so need to tell server
            class_2540 packet = PacketByteBufs.create();
            packet.method_52997(0);// Packet type
            packet.method_53002(1);// Protocol version
            packet.method_52964(MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_RACES);
            packet.method_52964(false);// Don't disable vanilla scoreboard for races (for now)
            packet.method_52964(MODULES_WANT_TO_HANDLE_CUSTOM_SCOREBOARD_FOR_TIME_TRIALS);
            packet.method_52964(false);// Don't disable vanilla scoreboard for time trials (for now)
            ClientPlayNetworking.send(new TimingSystemScoreboardModPayload(packet));
        }
    }

    public static void renderHud(class_332 drawContext, class_9779 renderTickCounter) {
        int scaledWidth = class_310.method_1551().method_22683().method_4486();
        int scaledHeight = class_310.method_1551().method_22683().method_4502();

        //RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        //RenderSystem.enableBlend();
        //RenderSystem.defaultBlendFunc();

        ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

        if(!config.runLuaOnTick) {
            FRAME_COUNTER++;
            if(FRAME_COUNTER >= config.runLuaSkipFrames){
                runLua(config);
                FRAME_COUNTER = 0;
            }
        }

        for(HudModulePlacement hudModulePlacement : config.modulePlacements) {
            HudModule hudModule = HUD_MODULES.get(class_2960.method_60654(hudModulePlacement.identifier));

            if(hudModule != null && (hudModule.runOutOfBoat || IN_BOAT)){
                drawContext.method_51448().method_22903();

                if(
                    hudModulePlacement.anchorType == AnchorType.TOP_CENTER ||
                    hudModulePlacement.anchorType == AnchorType.MIDDLE_CENTER ||
                    hudModulePlacement.anchorType == AnchorType.BOTTOM_CENTER
                ){
                    drawContext.method_51448().method_46416((float) scaledWidth / 2f, 0, 0);
                }

                if(
                    hudModulePlacement.anchorType == AnchorType.TOP_RIGHT ||
                    hudModulePlacement.anchorType == AnchorType.MIDDLE_RIGHT ||
                    hudModulePlacement.anchorType == AnchorType.BOTTOM_RIGHT
                ){
                    drawContext.method_51448().method_46416(scaledWidth, 0, 0);
                }

                if(
                    hudModulePlacement.anchorType == AnchorType.MIDDLE_LEFT ||
                    hudModulePlacement.anchorType == AnchorType.MIDDLE_CENTER ||
                    hudModulePlacement.anchorType == AnchorType.MIDDLE_RIGHT
                ){
                    drawContext.method_51448().method_46416(0, (float) scaledHeight / 2f, 0);
                }

                if(
                    hudModulePlacement.anchorType == AnchorType.BOTTOM_LEFT ||
                    hudModulePlacement.anchorType == AnchorType.BOTTOM_CENTER ||
                    hudModulePlacement.anchorType == AnchorType.BOTTOM_RIGHT
                ){
                    drawContext.method_51448().method_46416(0, scaledHeight, 0);
                }

                drawContext.method_51448().method_46416(hudModulePlacement.xOffset, hudModulePlacement.yOffset, 0);
                drawContext.method_51448().method_22905(hudModulePlacement.scale, hudModulePlacement.scale, hudModulePlacement.scale);
                if(Math.abs(hudModulePlacement.angle) > 0.00001f) {
                    drawContext.method_51448().method_22907(class_7833.field_40718.rotationDegrees(hudModulePlacement.angle));
                }
                String error = hudModule.render(drawContext);
                drawContext.method_51448().method_22909();

                if(error != null){
                    drawContext.method_51448().method_22903();
                    drawContext.method_51448().method_22905(0.5f, 0.5f, 1f);
                    String[] msgLines = error.split("\\r?\\n");
                    for(int i = 0; i < msgLines.length; i++) {
                        drawContext.method_51439(
                            class_310.method_1551().field_1772,
                            class_2561.method_30163(msgLines[i]),
                            10,
                            10 * i + 10,
                            0xFFFF0000,
                            false
                        );
                    }
                    drawContext.method_51448().method_22909();
                }
            }
        }
    }

    public static class_8685 getSkinTexture(UUID playerUuid){
        PlayerSkinCache playerSkinCache = PLAYER_SKIN_CACHE.computeIfAbsent(playerUuid, PlayerSkinCache::new);
        return playerSkinCache.skinTextures == null ? class_1068.method_4648(playerUuid) : playerSkinCache.skinTextures;
    }

    private static void updatePlayerSkinCache(){
        class_310 minecraftClient = class_310.method_1551();
        long now = System.currentTimeMillis();

        for (var k : PLAYER_SKIN_CACHE.keySet()) {
            PlayerSkinCache playerSkinCache = PLAYER_SKIN_CACHE.get(k);
            if (playerSkinCache.callApiThread != null) {

                if(playerSkinCache.callApiThread.isAlive()) {
                    return;
                }

                playerSkinCache.callApiThread = null;
            }
        }

        for (var k : PLAYER_SKIN_CACHE.keySet()) {
            PlayerSkinCache playerSkinCache = PLAYER_SKIN_CACHE.get(k);
            if (playerSkinCache.skinTextures == null && !playerSkinCache.startedApiThread) {
                Thread thread = new Thread(() -> {
                    ProfileResult profileResult = minecraftClient.method_1495().fetchProfile(playerSkinCache.playerUuid, false);

                    if(profileResult != null) {
                        minecraftClient.method_1582().method_52862(profileResult.profile());
                    }
                });

                playerSkinCache.callApiThread = thread;
                playerSkinCache.startedApiThread = true;
                thread.start();
                return;
            }
        }

        for (var k : PLAYER_SKIN_CACHE.keySet()) {
            PlayerSkinCache playerSkinCache = PLAYER_SKIN_CACHE.get(k);
            if (
                playerSkinCache.skinTextures == null &&
                playerSkinCache.startedApiThread &&
                playerSkinCache.callApiThread == null
            ) {
                ProfileResult profileResult = minecraftClient.method_1495().fetchProfile(playerSkinCache.playerUuid, false);

                playerSkinCache.skinTextures = profileResult != null
                    ? minecraftClient.method_1582().method_52862(profileResult.profile())
                    : class_1068.method_4648(playerSkinCache.playerUuid);
            }
        }
    }

    public static void drawPlayerHead(class_332 drawContext, UUID playerUuid) {
        class_8685 skinTextures = getSkinTexture(playerUuid);
        class_7532.method_52722(drawContext, skinTextures, 0, 0, 16);
    }
}
