/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.bb_boat_hud.webui;

public class WebUI {
    public static String getHTML() {
        return "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <title>BBBoatHUD Configuration</title>\n    <style>\n        * {\n            margin: 0;\n            padding: 0;\n            box-sizing: border-box;\n        }\n\n        body {\n            font-family: 'Courier New', monospace;\n            background: #1a1a1a;\n            min-height: 100vh;\n            padding: 20px;\n            color: #fff;\n            image-rendering: pixelated;\n            image-rendering: -moz-crisp-edges;\n            image-rendering: crisp-edges;\n        }\n\n        .container {\n            max-width: 1200px;\n            margin: 0 auto;\n            background: #2d2d2d;\n            border: 4px solid #000;\n            box-shadow: 0 0 0 2px #555, 0 8px 24px rgba(0, 0, 0, 0.8);\n        }\n\n        header {\n            background: #1e1e1e;\n            color: #fff;\n            padding: 20px;\n            text-align: center;\n            border-bottom: 4px solid #000;\n            box-shadow: inset 0 -2px 0 #555;\n        }\n\n        header h1 {\n            font-size: 2em;\n            margin-bottom: 5px;\n            text-shadow: 3px 3px 0 #000;\n            letter-spacing: 2px;\n        }\n\n        header p {\n            font-size: 0.9em;\n            color: #aaa;\n        }\n\n        .tabs {\n            display: flex;\n            background: #1e1e1e;\n            border-bottom: 4px solid #000;\n        }\n\n        .tab {\n            flex: 1;\n            padding: 12px 15px;\n            background: #3a3a3a;\n            border: 2px solid #000;\n            border-bottom: none;\n            cursor: pointer;\n            font-size: 14px;\n            font-weight: bold;\n            transition: all 0.1s;\n            color: #aaa;\n            font-family: 'Courier New', monospace;\n            text-transform: uppercase;\n            margin-right: 2px;\n        }\n\n        .tab:hover {\n            background: #4a4a4a;\n            color: #fff;\n        }\n\n        .tab.active {\n            background: #2d2d2d;\n            color: #5f5;\n            border-bottom: 2px solid #2d2d2d;\n        }\n\n        .tab-content {\n            display: none;\n            padding: 20px;\n            max-height: 70vh;\n            overflow-y: auto;\n        }\n\n        .tab-content.active {\n            display: block;\n        }\n\n        .module-item {\n            background: #1e1e1e;\n            border: 3px solid #000;\n            box-shadow: inset 0 0 0 1px #555;\n            padding: 10px;\n            margin-bottom: 8px;\n            transition: all 0.1s;\n        }\n\n        .module-item:hover {\n            border-color: #5f5;\n            box-shadow: inset 0 0 0 1px #5f5, 0 0 8px rgba(85, 255, 85, 0.3);\n        }\n\n        .module-header {\n            display: flex;\n            justify-content: space-between;\n            align-items: center;\n            padding: 8px;\n            background: #2d2d2d;\n            border: 2px solid #000;\n            cursor: pointer;\n            user-select: none;\n        }\n\n        .module-header:hover {\n            background: #3a3a3a;\n        }\n\n        .module-title {\n            font-size: 1em;\n            font-weight: bold;\n            color: #5f5;\n            text-shadow: 2px 2px 0 #000;\n        }\n\n        .module-id {\n            font-size: 0.75em;\n            color: #888;\n            font-family: monospace;\n        }\n\n        .module-details {\n            display: none;\n            padding: 15px;\n            background: #262626;\n            border-top: 2px solid #000;\n        }\n\n        .module-details.expanded {\n            display: block;\n        }\n\n        .expand-indicator {\n            color: #5f5;\n            font-weight: bold;\n            font-size: 1.2em;\n        }\n\n        .form-group {\n            margin-bottom: 12px;\n        }\n\n        label {\n            display: block;\n            margin-bottom: 4px;\n            font-weight: bold;\n            color: #aaa;\n            font-size: 0.85em;\n            text-transform: uppercase;\n        }\n\n        input[type=\"number\"],\n        input[type=\"range\"],\n        select {\n            width: 100%;\n            padding: 8px;\n            background: #1e1e1e;\n            border: 2px solid #000;\n            box-shadow: inset 0 0 0 1px #555;\n            font-size: 13px;\n            font-family: 'Courier New', monospace;\n            color: #fff;\n        }\n\n        input[type=\"number\"]:focus,\n        select:focus {\n            outline: none;\n            border-color: #5f5;\n            box-shadow: inset 0 0 0 1px #5f5, 0 0 8px rgba(85, 255, 85, 0.3);\n        }\n\n        input[type=\"range\"] {\n            padding: 5px;\n            background: #1e1e1e;\n        }\n\n        .slider-input-group {\n            display: grid;\n            grid-template-columns: 1fr 80px;\n            gap: 8px;\n            align-items: center;\n        }\n\n        .slider-input-group input[type=\"range\"] {\n            width: 100%;\n        }\n\n        .slider-input-group input[type=\"number\"] {\n            width: 100%;\n            text-align: center;\n        }\n\n        .checkbox-group {\n            display: flex;\n            align-items: center;\n            gap: 10px;\n        }\n\n        input[type=\"checkbox\"] {\n            width: 18px;\n            height: 18px;\n            cursor: pointer;\n        }\n\n        button {\n            padding: 8px 16px;\n            background: #3a3a3a;\n            color: #fff;\n            border: 2px solid #000;\n            box-shadow: inset 0 0 0 1px #555;\n            cursor: pointer;\n            font-size: 13px;\n            font-weight: bold;\n            font-family: 'Courier New', monospace;\n            text-transform: uppercase;\n            transition: all 0.1s;\n        }\n\n        button:hover {\n            background: #4a4a4a;\n            box-shadow: inset 0 0 0 1px #5f5, 0 0 8px rgba(85, 255, 85, 0.3);\n            border-color: #5f5;\n        }\n\n        button:active {\n            background: #2a2a2a;\n        }\n\n        button.danger {\n            background: #5a1a1a;\n            border-color: #f55;\n            box-shadow: inset 0 0 0 1px #f55;\n        }\n\n        button.danger:hover {\n            background: #7a2a2a;\n            box-shadow: inset 0 0 0 1px #f55, 0 0 8px rgba(255, 85, 85, 0.3);\n        }\n\n        .anchor-grid {\n            display: grid;\n            grid-template-columns: repeat(3, 1fr);\n            gap: 6px;\n            margin-top: 8px;\n        }\n\n        .anchor-btn {\n            padding: 8px;\n            background: #1e1e1e;\n            border: 2px solid #000;\n            box-shadow: inset 0 0 0 1px #555;\n            cursor: pointer;\n            transition: all 0.1s;\n            font-size: 11px;\n            font-family: 'Courier New', monospace;\n            color: #aaa;\n        }\n\n        .anchor-btn:hover {\n            border-color: #5f5;\n            background: #2a2a2a;\n            color: #fff;\n        }\n\n        .anchor-btn.active {\n            background: #2a4a2a;\n            color: #5f5;\n            border-color: #5f5;\n            box-shadow: inset 0 0 0 1px #5f5, 0 0 8px rgba(85, 255, 85, 0.3);\n        }\n\n        .module-library {\n            max-height: 600px;\n            overflow-y: auto;\n        }\n\n        .folder {\n            margin-left: 15px;\n        }\n\n        .folder-header {\n            font-weight: bold;\n            margin: 8px 0 4px 0;\n            color: #ff5;\n            text-shadow: 2px 2px 0 #000;\n            text-transform: uppercase;\n            font-size: 0.9em;\n            cursor: pointer;\n            user-select: none;\n            padding: 6px 8px;\n            background: #2a2a2a;\n            border: 2px solid #000;\n            display: flex;\n            justify-content: space-between;\n            align-items: center;\n        }\n\n        .folder-header:hover {\n            background: #3a3a3a;\n        }\n\n        .folder-content {\n            display: none;\n            margin-left: 10px;\n        }\n\n        .folder-content.expanded {\n            display: block;\n        }\n\n        .folder-indicator {\n            color: #ff5;\n            font-weight: bold;\n        }\n\n        .module-add-btn {\n            display: block;\n            width: 100%;\n            margin: 3px 0;\n            padding: 8px;\n            background: #1e1e1e;\n            border: 2px solid #000;\n            box-shadow: inset 0 0 0 1px #555;\n            text-align: left;\n            cursor: pointer;\n            transition: all 0.1s;\n            font-family: 'Courier New', monospace;\n            color: #aaa;\n            font-size: 0.85em;\n        }\n\n        .module-add-btn:hover {\n            background: #2a4a2a;\n            color: #5f5;\n            border-color: #5f5;\n            box-shadow: inset 0 0 0 1px #5f5, 0 0 8px rgba(85, 255, 85, 0.3);\n        }\n\n        .save-indicator {\n            position: fixed;\n            top: 20px;\n            right: 20px;\n            padding: 12px 20px;\n            background: #2a4a2a;\n            color: #5f5;\n            border: 2px solid #000;\n            box-shadow: inset 0 0 0 1px #5f5, 0 0 16px rgba(85, 255, 85, 0.5);\n            opacity: 0;\n            transition: opacity 0.2s;\n            z-index: 1000;\n            font-family: 'Courier New', monospace;\n            font-weight: bold;\n            text-shadow: 2px 2px 0 #000;\n        }\n\n        .save-indicator.show {\n            opacity: 1;\n        }\n\n        .vanilla-config {\n            display: grid;\n            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));\n            gap: 12px;\n        }\n\n        .vanilla-item {\n            background: #1e1e1e;\n            border: 3px solid #000;\n            box-shadow: inset 0 0 0 1px #555;\n            padding: 12px;\n        }\n\n        .vanilla-item h3 {\n            margin-bottom: 10px;\n            color: #ff5;\n            text-shadow: 2px 2px 0 #000;\n            font-size: 1em;\n            text-transform: uppercase;\n        }\n\n        .empty-state {\n            text-align: center;\n            padding: 40px 20px;\n            color: #666;\n        }\n\n        .empty-state-icon {\n            font-size: 3em;\n            margin-bottom: 15px;\n            color: #444;\n        }\n\n        .empty-state p {\n            font-size: 1em;\n            color: #888;\n        }\n\n        ::-webkit-scrollbar {\n            width: 12px;\n            height: 12px;\n        }\n\n        ::-webkit-scrollbar-track {\n            background: #1e1e1e;\n            border: 2px solid #000;\n        }\n\n        ::-webkit-scrollbar-thumb {\n            background: #3a3a3a;\n            border: 2px solid #000;\n        }\n\n        ::-webkit-scrollbar-thumb:hover {\n            background: #4a4a4a;\n        }\n\n        .loading-overlay {\n            position: fixed;\n            top: 0;\n            left: 0;\n            width: 100%;\n            height: 100%;\n            background: rgba(0, 0, 0, 0.8);\n            display: none;\n            justify-content: center;\n            align-items: center;\n            z-index: 9999;\n        }\n\n        .loading-overlay.show {\n            display: flex;\n        }\n\n        .loading-text {\n            color: #5f5;\n            font-size: 1.5em;\n            font-weight: bold;\n            text-shadow: 2px 2px 0 #000;\n            animation: pulse 1.5s infinite;\n        }\n\n        @keyframes pulse {\n            0%, 100% { opacity: 1; }\n            50% { opacity: 0.5; }\n        }\n    </style>\n</head>\n<body>\n    <div class=\"loading-overlay\" id=\"loadingOverlay\">\n        <div class=\"loading-text\">Loading...</div>\n    </div>\n    <div class=\"save-indicator\" id=\"saveIndicator\">Configuration saved!</div>\n\n    <div class=\"container\">\n        <header>\n            <h1>BBBoatHUD</h1>\n            <p>Configure your HUD modules and settings</p>\n        </header>\n\n        <div class=\"tabs\">\n            <button class=\"tab active\" onclick=\"switchTab(0)\">Active Modules</button>\n            <button class=\"tab\" onclick=\"switchTab(1)\">Add Modules</button>\n            <button class=\"tab\" onclick=\"switchTab(2)\">Vanilla HUD</button>\n        </div>\n\n        <div class=\"tab-content active\" id=\"tab-0\">\n            <div id=\"activeModules\"></div>\n        </div>\n\n        <div class=\"tab-content\" id=\"tab-1\">\n            <h2 style=\"margin-bottom: 20px;\">Module Library</h2>\n            <div id=\"moduleLibrary\" class=\"module-library\"></div>\n        </div>\n\n        <div class=\"tab-content\" id=\"tab-2\">\n            <h2 style=\"margin-bottom: 20px;\">Vanilla HUD Configuration</h2>\n            <div id=\"vanillaConfig\" class=\"vanilla-config\"></div>\n        </div>\n    </div>\n\n    <script>\n        let config = null;\n        let modules = null;\n        let expandedModules = new Set();\n\n        function switchTab(index) {\n            document.querySelectorAll('.tab').forEach((tab, i) => {\n                tab.classList.toggle('active', i === index);\n            });\n            document.querySelectorAll('.tab-content').forEach((content, i) => {\n                content.classList.toggle('active', i === index);\n            });\n        }\n\n        async function loadConfig() {\n            try {\n                const response = await fetch('http://localhost:8765/api/config');\n                config = await response.json();\n                renderActiveModules();\n                renderVanillaConfig();\n            } catch (error) {\n                console.error('Failed to load config:', error);\n            }\n        }\n\n        async function loadModules() {\n            try {\n                const response = await fetch('http://localhost:8765/api/modules');\n                modules = await response.json();\n                renderModuleLibrary();\n            } catch (error) {\n                console.error('Failed to load modules:', error);\n            }\n        }\n\n        function showSaveIndicator() {\n            const indicator = document.getElementById('saveIndicator');\n            indicator.classList.add('show');\n            setTimeout(() => {\n                indicator.classList.remove('show');\n            }, 2000);\n        }\n\n        async function savePlacements() {\n            try {\n                await fetch('http://localhost:8765/api/modules/placements', {\n                    method: 'POST',\n                    headers: { 'Content-Type': 'application/json' },\n                    body: JSON.stringify(config.modulePlacements)\n                });\n                showSaveIndicator();\n            } catch (error) {\n                console.error('Failed to save placements:', error);\n                alert('Failed to save configuration');\n            }\n        }\n\n        async function saveVanillaConfig() {\n            try {\n                await fetch('http://localhost:8765/api/vanilla', {\n                    method: 'POST',\n                    headers: { 'Content-Type': 'application/json' },\n                    body: JSON.stringify(config)\n                });\n                showSaveIndicator();\n            } catch (error) {\n                console.error('Failed to save vanilla config:', error);\n                alert('Failed to save configuration');\n            }\n        }\n\n        async function addModule(identifier) {\n            const loadingOverlay = document.getElementById('loadingOverlay');\n\n            try {\n                // Show loading overlay\n                loadingOverlay.classList.add('show');\n\n                await fetch('http://localhost:8765/api/modules/add', {\n                    method: 'POST',\n                    headers: { 'Content-Type': 'application/json' },\n                    body: JSON.stringify({ identifier })\n                });\n\n                // Wait a bit for the server to process\n                await new Promise(resolve => setTimeout(resolve, 100));\n\n                await loadConfig();\n\n                // Collapse all modules and expand only the newly added one (which is at the end, index length-1)\n                expandedModules.clear();\n                expandedModules.add(config.modulePlacements.length - 1);\n\n                // Switch to active modules tab and render\n                switchTab(0);\n                renderActiveModules();\n\n                // Scroll to top to see the newly added module\n                const activeModulesContainer = document.getElementById('activeModules');\n                activeModulesContainer.scrollTop = 0;\n\n                showSaveIndicator();\n            } catch (error) {\n                console.error('Failed to add module:', error);\n                alert('Failed to add module');\n            } finally {\n                // Hide loading overlay\n                loadingOverlay.classList.remove('show');\n            }\n        }\n\n        function removeModule(index) {\n            // Collapse all modules when removing\n            expandedModules.clear();\n\n            config.modulePlacements.splice(index, 1);\n            savePlacements();\n            renderActiveModules();\n        }\n\n        function getFriendlyName(identifier) {\n            // Extract filename from path like bb_boat_hud:bb_boat_hud_modules/boatlabs/scoreboard.lua\n            const parts = identifier.split('/');\n            const filename = parts[parts.length - 1];\n            // Remove .lua extension\n            const nameWithoutExt = filename.replace('.lua', '');\n            // Replace underscores with spaces and capitalize each word\n            return nameWithoutExt.split('_').map(word =>\n                word.charAt(0).toUpperCase() + word.slice(1)\n            ).join(' ');\n        }\n\n        function renderActiveModules() {\n            const container = document.getElementById('activeModules');\n\n            if (!config || config.modulePlacements.length === 0) {\n                container.innerHTML = '<div class=\"empty-state\"><div class=\"empty-state-icon\">[_]</div><p>No modules added yet</p><p style=\"margin-top: 10px; font-size: 0.9em;\">Go to \"Add Modules\" tab to add your first module</p></div>';\n                return;\n            }\n\n            // Render in reverse order so newest (last in array) appears first\n            const reversedPlacements = [...config.modulePlacements].reverse();\n\n            container.innerHTML = reversedPlacements.map((placement, reverseIndex) => {\n                // Calculate the actual index in the original array\n                const index = config.modulePlacements.length - 1 - reverseIndex;\n\n                return `\n                <div class=\"module-item\">\n                    <div class=\"module-header\" onclick=\"toggleModule(${index})\">\n                        <div>\n                            <div class=\"module-title\">${getFriendlyName(placement.identifier)}</div>\n                            <div class=\"module-id\">${placement.identifier}</div>\n                        </div>\n                        <span class=\"expand-indicator\" id=\"indicator-${index}\">${expandedModules.has(index) ? '-' : '+'}</span>\n                    </div>\n                    <div class=\"module-details ${expandedModules.has(index) ? 'expanded' : ''}\" id=\"details-${index}\">\n                        <div class=\"form-group\">\n                            <label>Anchor Position</label>\n                            <select onchange=\"updateAnchor(${index}, this.value)\">\n                                ${['TOP_LEFT', 'TOP_CENTER', 'TOP_RIGHT', 'MIDDLE_LEFT', 'MIDDLE_CENTER', 'MIDDLE_RIGHT', 'BOTTOM_LEFT', 'BOTTOM_CENTER', 'BOTTOM_RIGHT'].map(anchor => `\n                                    <option value=\"${anchor}\" ${placement.anchorType === anchor ? 'selected' : ''}>\n                                        ${anchor.replace(/_/g, ' ')}\n                                    </option>\n                                `).join('')}\n                            </select>\n                        </div>\n                        <div class=\"form-group\">\n                            <label>X Offset</label>\n                            <div class=\"slider-input-group\">\n                                <input type=\"range\" min=\"-300\" max=\"300\" value=\"${placement.xOffset}\"\n                                       oninput=\"updateOffsetFromSlider(${index}, 'x', this.value)\">\n                                <input type=\"number\" min=\"-300\" max=\"300\" value=\"${placement.xOffset}\"\n                                       oninput=\"updateOffsetFromInput(${index}, 'x', this.value)\">\n                            </div>\n                        </div>\n                        <div class=\"form-group\">\n                            <label>Y Offset</label>\n                            <div class=\"slider-input-group\">\n                                <input type=\"range\" min=\"-300\" max=\"300\" value=\"${placement.yOffset}\"\n                                       oninput=\"updateOffsetFromSlider(${index}, 'y', this.value)\">\n                                <input type=\"number\" min=\"-300\" max=\"300\" value=\"${placement.yOffset}\"\n                                       oninput=\"updateOffsetFromInput(${index}, 'y', this.value)\">\n                            </div>\n                        </div>\n                        <div class=\"form-group\">\n                            <label>Scale</label>\n                            <div class=\"slider-input-group\">\n                                <input type=\"range\" min=\"0.1\" max=\"10\" step=\"0.1\" value=\"${placement.scale}\"\n                                       oninput=\"updateScaleFromSlider(${index}, this.value)\">\n                                <input type=\"number\" min=\"0.1\" max=\"10\" step=\"0.1\" value=\"${placement.scale.toFixed(2)}\"\n                                       oninput=\"updateScaleFromInput(${index}, this.value)\">\n                            </div>\n                        </div>\n                        <div class=\"form-group\">\n                            <label>Rotation (degrees)</label>\n                            <div class=\"slider-input-group\">\n                                <input type=\"range\" min=\"-180\" max=\"180\" step=\"1\" value=\"${placement.angle}\"\n                                       oninput=\"updateAngleFromSlider(${index}, this.value)\">\n                                <input type=\"number\" min=\"-180\" max=\"180\" step=\"1\" value=\"${placement.angle.toFixed(1)}\"\n                                       oninput=\"updateAngleFromInput(${index}, this.value)\">\n                            </div>\n                        </div>\n                        <button class=\"danger\" onclick=\"removeModule(${index})\" style=\"width: 100%; margin-top: 10px;\">Remove Module</button>\n                    </div>\n                </div>\n            `}).join('');\n        }\n\n        function toggleModule(index) {\n            if (expandedModules.has(index)) {\n                // If clicking on already expanded module, collapse it\n                expandedModules.delete(index);\n            } else {\n                // Collapse all others and expand this one\n                expandedModules.clear();\n                expandedModules.add(index);\n            }\n\n            // Re-render to update all indicators and states\n            renderActiveModules();\n        }\n\n        function updateAnchor(index, anchor) {\n            config.modulePlacements[index].anchorType = anchor;\n            savePlacements();\n        }\n\n        function updateOffsetFromSlider(index, axis, value) {\n            const intValue = parseInt(value);\n            if (axis === 'x') {\n                config.modulePlacements[index].xOffset = intValue;\n            } else {\n                config.modulePlacements[index].yOffset = intValue;\n            }\n            // Update the corresponding number input\n            const sliderGroup = event.target.parentElement;\n            const numberInput = sliderGroup.querySelector('input[type=\"number\"]');\n            numberInput.value = intValue;\n            savePlacements();\n        }\n\n        function updateOffsetFromInput(index, axis, value) {\n            const intValue = parseInt(value);\n            if (axis === 'x') {\n                config.modulePlacements[index].xOffset = intValue;\n            } else {\n                config.modulePlacements[index].yOffset = intValue;\n            }\n            // Update the corresponding slider\n            const inputGroup = event.target.parentElement;\n            const slider = inputGroup.querySelector('input[type=\"range\"]');\n            slider.value = intValue;\n            savePlacements();\n        }\n\n        function updateScaleFromSlider(index, value) {\n            const floatValue = parseFloat(value);\n            config.modulePlacements[index].scale = floatValue;\n            // Update the corresponding number input\n            const sliderGroup = event.target.parentElement;\n            const numberInput = sliderGroup.querySelector('input[type=\"number\"]');\n            numberInput.value = floatValue.toFixed(2);\n            savePlacements();\n        }\n\n        function updateScaleFromInput(index, value) {\n            const floatValue = parseFloat(value);\n            config.modulePlacements[index].scale = floatValue;\n            // Update the corresponding slider\n            const inputGroup = event.target.parentElement;\n            const slider = inputGroup.querySelector('input[type=\"range\"]');\n            slider.value = floatValue;\n            savePlacements();\n        }\n\n        function updateAngleFromSlider(index, value) {\n            const floatValue = parseFloat(value);\n            config.modulePlacements[index].angle = floatValue;\n            // Update the corresponding number input\n            const sliderGroup = event.target.parentElement;\n            const numberInput = sliderGroup.querySelector('input[type=\"number\"]');\n            numberInput.value = floatValue.toFixed(1);\n            savePlacements();\n        }\n\n        function updateAngleFromInput(index, value) {\n            const floatValue = parseFloat(value);\n            config.modulePlacements[index].angle = floatValue;\n            // Update the corresponding slider\n            const inputGroup = event.target.parentElement;\n            const slider = inputGroup.querySelector('input[type=\"range\"]');\n            slider.value = floatValue;\n            savePlacements();\n        }\n\n        function renderModuleLibrary() {\n            const container = document.getElementById('moduleLibrary');\n\n            if (!modules) {\n                container.innerHTML = '<p>Loading modules...</p>';\n                return;\n            }\n\n            const tree = {};\n            for (const [identifier, path] of Object.entries(modules)) {\n                let current = tree;\n                for (let i = 0; i < path.length - 1; i++) {\n                    if (!current[path[i]]) {\n                        current[path[i]] = {};\n                    }\n                    current = current[path[i]];\n                }\n                const lastName = path[path.length - 1];\n                current[lastName] = identifier;\n            }\n\n            let folderIdCounter = 0;\n\n            function renderTree(obj, level = 0) {\n                let html = '';\n                for (const [key, value] of Object.entries(obj)) {\n                    if (typeof value === 'string') {\n                        html += `<button class=\"module-add-btn\" onclick=\"addModule('${value}')\">${key}</button>`;\n                    } else {\n                        const folderId = 'folder-' + (folderIdCounter++);\n                        html += `<div class=\"folder\" style=\"margin-left: ${level * 20}px\">\n                            <div class=\"folder-header\" onclick=\"toggleFolder('${folderId}')\">\n                                <span>${key}</span>\n                                <span class=\"folder-indicator\" id=\"indicator-${folderId}\">+</span>\n                            </div>\n                            <div class=\"folder-content\" id=\"${folderId}\">\n                                ${renderTree(value, level + 1)}\n                            </div>\n                        </div>`;\n                    }\n                }\n                return html;\n            }\n\n            container.innerHTML = renderTree(tree);\n        }\n\n        function toggleFolder(folderId) {\n            const content = document.getElementById(folderId);\n            const indicator = document.getElementById('indicator-' + folderId);\n            content.classList.toggle('expanded');\n            indicator.textContent = content.classList.contains('expanded') ? '-' : '+';\n        }\n\n        function renderVanillaConfig() {\n            const container = document.getElementById('vanillaConfig');\n\n            if (!config) {\n                container.innerHTML = '<p>Loading configuration...</p>';\n                return;\n            }\n\n            const vanillaElements = [\n                { key: 'hotbar', name: 'Hotbar' },\n                { key: 'experienceBar', name: 'Experience Bar' },\n                { key: 'experienceLevel', name: 'Experience Level' },\n                { key: 'heldItemTooltip', name: 'Held Item Tooltip' },\n                { key: 'armorBar', name: 'Armor Bar' },\n                { key: 'healthBar', name: 'Health Bar' },\n                { key: 'foodBar', name: 'Food Bar' },\n                { key: 'oxygenBar', name: 'Oxygen Bar' },\n                { key: 'bossBar', name: 'Boss Bar' },\n                { key: 'overlayMessage', name: 'Action Bar Message' }\n            ];\n\n            container.innerHTML = vanillaElements.map(elem => `\n                <div class=\"vanilla-item\">\n                    <h3>${elem.name}</h3>\n                    <div class=\"form-group\">\n                        <div class=\"checkbox-group\">\n                            <input type=\"checkbox\" id=\"${elem.key}_render\"\n                                   ${config[elem.key].render ? 'checked' : ''}\n                                   onchange=\"updateVanillaRender('${elem.key}', this.checked)\">\n                            <label for=\"${elem.key}_render\">Render</label>\n                        </div>\n                    </div>\n                    <div class=\"form-group\">\n                        <label>X Offset</label>\n                        <input type=\"number\" value=\"${config[elem.key].xOffset}\"\n                               onchange=\"updateVanillaOffset('${elem.key}', 'xOffset', this.value)\">\n                    </div>\n                    <div class=\"form-group\">\n                        <label>Y Offset</label>\n                        <input type=\"number\" value=\"${config[elem.key].yOffset}\"\n                               onchange=\"updateVanillaOffset('${elem.key}', 'yOffset', this.value)\">\n                    </div>\n                </div>\n            `).join('');\n        }\n\n        function updateVanillaRender(key, value) {\n            config[key].render = value;\n            saveVanillaConfig();\n        }\n\n        function updateVanillaOffset(key, offset, value) {\n            config[key][offset] = parseInt(value);\n            saveVanillaConfig();\n        }\n\n        loadConfig();\n        loadModules();\n    </script>\n</body>\n</html>\n";
    }
}

