local background = "piggle/renokas/background.png"
local steerInputOff = "piggle/renokas/steer_input_off.png"
local steerInputOn = "piggle/renokas/steer_input_on.png"
local accInputOff = "piggle/renokas/acc_input_off.png"
local accInputOn = "piggle/renokas/acc_input_on.png"
local accInputReverse = "piggle/renokas/acc_input_reverse.png"
local ping0 = "piggle/renokas/ping_0.png"
local ping1 = "piggle/renokas/ping_1.png"
local ping2 = "piggle/renokas/ping_2.png"
local ping3 = "piggle/renokas/ping_3.png"
local ping4 = "piggle/renokas/ping_4.png"
local ping5 = "piggle/renokas/ping_5.png"
local barEmpty = "piggle/renokas/bar_empty.png"
local barFull = "piggle/renokas/bar_full.png"

renderTexture(background, 182, 26, "MIDDLE_CENTER")

-- speedometer
offsetPosition(0, -13, function()
    renderTexture(barEmpty, 182, 5, "TOP_CENTER")

    local speedCrop = speed * 2.3
    if(speedCrop > 182) then
        speedCrop = 182
    end

    renderTextureCropped(barFull, 182, 5, 0, 0, speedCrop, 5, "TOP_CENTER")
end)

-- left input
offsetPosition(-91, 0, function()
    if(pressingLeft) then
        renderTexture(steerInputOn, 4, 26, "MIDDLE_RIGHT")
    else
        renderTexture(steerInputOff, 4, 26, "MIDDLE_RIGHT")
    end
end)

-- right input
offsetPosition(91, 0, function()
    offsetRotation(180, function()
        if(pressingRight) then
            renderTexture(steerInputOn, 4, 26, "MIDDLE_RIGHT")
        else
            renderTexture(steerInputOff, 4, 26, "MIDDLE_RIGHT")
        end
    end)
end)

-- forward / back inputs
offsetPosition(0, 2, function()
    offsetScale(0.3, 0.3, function()
        if pressingForward then
            renderTexture(accInputOn, 94, 36, "MIDDLE_CENTER")
        elseif pressingBack then
            renderTexture(accInputReverse, 94, 36, "MIDDLE_CENTER")
        else
            renderTexture(accInputOff, 94, 36, "MIDDLE_CENTER")
        end
    end)
end)

-- Speed label
offsetPosition(-20, -2, function()
    renderText(
        string.format("%00i", speed * 3.59 * 0.6213712) .. " mph",
        0xFFFFFFFF,
        false,
        "MIDDLE_RIGHT"
    )
end)

-- Speed arrow
offsetPosition(-70, -2, function()
    local color = 0xFF00FF00
    local arrow = "↑"

    if(driftAngle > 90) then
        color = 0xFFf4a402
        arrow = "↓"
    end

    if(speed < 1) then
        color = 0xFF999999
        arrow = "-"
    end

    renderText(
        arrow,
        color,
        true,
        "MIDDLE_CENTER"
    )
end)

-- ping label
offsetPosition(-26, 7, function()
    renderText(
        ping .. " ms",
        0xFFFFFFFF,
        false,
        "MIDDLE_RIGHT"
    )
end)

-- ping icon
offsetPosition(-70, 7, function()
    local tex = ping0

    if(ping <= 10) then
        tex = ping5
    elseif(ping < 150) then
        tex = ping4
    elseif(ping < 300) then
        tex = ping3
    elseif(ping < 600) then
        tex = ping2
    elseif(ping < 1000) then
        tex = ping1
    end

    renderTexture(
        tex,
        10,
        7,
        "MIDDLE_CENTER"
    )
end)

-- drift angle label
offsetPosition(57, -2, function()
    renderText(
        string.format("%00i", math.abs(driftAngle)) .. " °",
        0xFFFFFFFF,
        true,
        "MIDDLE_RIGHT"
    )
end)

-- FPS label
offsetPosition(70, 7, function()
    renderText(
        fps .. " FPS",
        0xFFFFFFFF,
        true,
        "MIDDLE_RIGHT"
    )
end)