package uk.co.cablepost.bb_boat_hud.network;

// TODO - move into own lib

public enum ScoreboardModColumnTypes {
    PLAYER_UUID(ScoreboardModDataTypes.UUID),
    POSITION(ScoreboardModDataTypes.INT),
    FINISHED(ScoreboardModDataTypes.BOOLEAN),
    IN_PIT(ScoreboardModDataTypes.BOOLEAN),
    DNF(ScoreboardModDataTypes.BOOLEAN),
    PITS(ScoreboardModDataTypes.INT),
    CHECKPOINTS(ScoreboardModDataTypes.INT),
    LAPS(ScoreboardModDataTypes.INT),
    TIME_DIFF_FROM_FIRST_MS(ScoreboardModDataTypes.LONG),
    TIME_DIFF_FROM_PREVIOUS_MS(ScoreboardModDataTypes.LONG),
    FASTEST_LAP(ScoreboardModDataTypes.BOOLEAN),
    DRS_STATE(ScoreboardModDataTypes.BYTE),
    TT_TIME(ScoreboardModDataTypes.LONG);

    private final ScoreboardModDataTypes dataType;

    ScoreboardModColumnTypes(ScoreboardModDataTypes dataType){
        this.dataType = dataType;
    }

    public ScoreboardModDataTypes getDataType(){
        return dataType;
    }

    public static int getTotalBytes(ScoreboardModColumnTypes[] types) {
        int total = 0;
        for (ScoreboardModColumnTypes type : types) {
            total += type.getDataType().getByteSize();
        }
        return total;
    }
}
