package uk.co.cablepost.bb_boat_hud.network;

import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import uk.co.cablepost.bb_boat_hud.client.BbBoatHudClient;
import uk.co.cablepost.bb_boat_hud.client.ScoreboardPlayerCache;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public record TimingSystemScoreboardModPayload(ByteBuf data) implements class_8710 {
    public static final class_9139<class_2540, TimingSystemScoreboardModPayload> CODEC = class_8710.method_56484(TimingSystemScoreboardModPayload::write, TimingSystemScoreboardModPayload::new);
    public static final class_9154<TimingSystemScoreboardModPayload> ID = new class_9154<>(class_2960.method_60655("timingsystemscoreboardmod","protocol"));

    public TimingSystemScoreboardModPayload(class_2540 buf) {
        this(buf.copy());
        buf.method_52988(buf.writerIndex());
    }

    void write(class_2540 buf) {
        buf.method_52975(data);
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public static void handlePacket(TimingSystemScoreboardModPayload payload, ClientPlayNetworking.Context context) {

        byte packetType = payload.data.readByte();

        if(packetType == 0){
            // Type 0 if for telling the client what structure to expect from packet type 1.

            BbBoatHudClient.LUA_SCOREBOARD = null;
            BbBoatHudClient.LUA_SCOREBOARD_COLUMN_TYPES = new ArrayList<>();
            BbBoatHudClient.LUA_SCOREBOARD_ONE_OFF_TYPES = new ArrayList<>();

            if(!payload.data.isReadable()){
                // Server sent empty type 0 packet to indicate no more scoreboard
                System.out.println("Wiping scoreboard");
                return;
            }

            int numberOfColumns = payload.data.readInt();
            System.out.println("Getting " + numberOfColumns + " columns for scoreboard");

            ScoreboardModColumnTypes[] allPossibleColumnTypes = ScoreboardModColumnTypes.values();

            for(int i = 0; i < numberOfColumns; i++){
                int columnType = payload.data.readInt();

                BbBoatHudClient.LUA_SCOREBOARD_COLUMN_TYPES.add(allPossibleColumnTypes[columnType]);
            }

            ScoreboardModOneOffTypes[] allPossibleOneOffTypes = ScoreboardModOneOffTypes.values();

            while(payload.data.readableBytes() >= 4){
                int oneOffType = payload.data.readInt();
                BbBoatHudClient.LUA_SCOREBOARD_ONE_OFF_TYPES.add(allPossibleOneOffTypes[oneOffType]);
            }

            if(payload.data.readableBytes() > 0){
                throw new RuntimeException("Got bytes left over from packet type 0?!");
            }
        }
        else if(packetType == 1){
            // Type 1 is for sending the actual scoreboard data.

            BbBoatHudClient.LUA_SCOREBOARD = new LuaTable();

            LuaTable rows = new LuaTable();

            if(
                BbBoatHudClient.LUA_SCOREBOARD_COLUMN_TYPES == null ||
                BbBoatHudClient.LUA_SCOREBOARD_ONE_OFF_TYPES == null
            ){
                throw new RuntimeException("Got packet type 1 before type 0");
            }

            int numberOfRows = payload.data.readInt();
            //System.out.println("Getting " + numberOfRows + " rows for scoreboard");

            for(int i = 0; i < numberOfRows; i++){
                LuaTable row = new LuaTable();

                for(ScoreboardModColumnTypes columnType : BbBoatHudClient.LUA_SCOREBOARD_COLUMN_TYPES){
                    switch(columnType){
                        case PLAYER_UUID -> {
                            long playerUuidMostSig = payload.data.readLong();
                            long playerUuidLeastSig = payload.data.readLong();

                            UUID playerUuid = new UUID(playerUuidMostSig, playerUuidLeastSig);

//                            @Nullable PlayerEntity playerEntity = context.player().clientWorld.getPlayerByUuid(playerUuid);
//                            if(playerEntity != null){
//                                BbBoatHudClient.PLAYER_NAME_CACHE.put(playerUuid, Objects.requireNonNull(playerEntity.getDisplayName()).asTruncatedString(16));
//                            }

                            if(!BbBoatHudClient.PLAYER_NAME_CACHE.containsKey(playerUuid)){
                                class_2540 packet = PacketByteBufs.create();
                                packet.method_52997(1);// Packet type
                                packet.method_52974(playerUuidMostSig);
                                packet.method_52974(playerUuidLeastSig);
                                ClientPlayNetworking.send(new TimingSystemScoreboardModPayload(packet));

                                BbBoatHudClient.PLAYER_NAME_CACHE.put(playerUuid, new ScoreboardPlayerCache(playerUuid, null, -1, -1));
                            }

                            ScoreboardPlayerCache scoreboardPlayerCache = BbBoatHudClient.PLAYER_NAME_CACHE.get(playerUuid);

                            if(scoreboardPlayerCache == null || scoreboardPlayerCache.name() == null){
                                row.set("player_name", "Loading...");
                                row.set("team_color_1", -1);
                                row.set("team_color_2", -1);
                            }
                            else{
                                row.set("player_name", scoreboardPlayerCache.name());
                                row.set("team_color_1", scoreboardPlayerCache.teamColor1());
                                row.set("team_color_2", scoreboardPlayerCache.teamColor2());
                            }

                            row.set("player_uuid", playerUuid.toString());
                        }
                        case POSITION -> row.set("position", payload.data.readInt());
                        case FINISHED -> row.set("finished", LuaBoolean.valueOf(payload.data.readBoolean()));
                        case IN_PIT -> row.set("in_pit", LuaBoolean.valueOf(payload.data.readBoolean()));
                        case DNF -> row.set("dnf", LuaBoolean.valueOf(payload.data.readBoolean()));
                        case PITS -> row.set("pits", payload.data.readInt());
                        case CHECKPOINTS -> row.set("checkpoints", payload.data.readInt());
                        case LAPS -> row.set("laps", payload.data.readInt());
                        case TIME_DIFF_FROM_FIRST_MS -> row.set("time_diff_from_first_ms", payload.data.readLong());
                        case TIME_DIFF_FROM_PREVIOUS_MS -> row.set("time_diff_from_previous_ms", payload.data.readLong());
                        case FASTEST_LAP -> row.set("fastest_lap", LuaBoolean.valueOf(payload.data.readBoolean()));
                        case DRS_STATE -> {
                            byte drsState = payload.data.readByte();
                            if(drsState == 0){
                                row.set("drs_state", "OFF");
                            }
                            else if(drsState == 1){
                                row.set("drs_state", "READY");
                            } else if(drsState == 2){
                                row.set("drs_state", "ON");
                            } else {
                                row.set("drs_state", "UNKNOWN");
                            }
                        }
                        case TT_TIME -> row.set("tt_time", payload.data.readLong());
                    }
                }

                rows.set(i + 1, row);
            }

            BbBoatHudClient.LUA_SCOREBOARD.set("rows", rows);
            LuaTable extra = new LuaTable();

            //System.out.println("One off types: " + BbBoatHudClient.LUA_SCOREBOARD_ONE_OFF_TYPES);

            for(ScoreboardModOneOffTypes oneOffType : BbBoatHudClient.LUA_SCOREBOARD_ONE_OFF_TYPES){
                switch (oneOffType){
                    case MAIN_TITLE -> {
                        byte[] bytes = new byte[oneOffType.getDataType().getByteSize()];
                        payload.data.readBytes(bytes);
                        extra.set("main_title", new String(bytes, StandardCharsets.UTF_8).trim());
                    }
                    case SUB_TITLE -> {
                        byte[] bytes = new byte[oneOffType.getDataType().getByteSize()];
                        payload.data.readBytes(bytes);
                        extra.set("sub_title", new String(bytes, StandardCharsets.UTF_8).trim());
                    }
                    case SCOREBOARD_TITLE -> {
                        byte[] bytes = new byte[oneOffType.getDataType().getByteSize()];
                        payload.data.readBytes(bytes);
                        extra.set("scoreboard_title", new String(bytes, StandardCharsets.UTF_8).trim());
                    }
                    case TOTAL_LAPS -> extra.set("total_laps", payload.data.readInt());
                    case TOTAL_PITS -> extra.set("total_pits", payload.data.readInt());
                    case IS_QUALIFICATION -> extra.set("is_qualification", LuaBoolean.valueOf(payload.data.readBoolean()));
                    case BRONZE_MEDAL_TIME -> extra.set("bronze_medal_time", payload.data.readLong());
                    case SILVER_MEDAL_TIME -> extra.set("silver_medal_time", payload.data.readLong());
                    case GOLD_MEDAL_TIME -> extra.set("gold_medal_time", payload.data.readLong());
                    case DIAMOND_MEDAL_TIME -> extra.set("diamond_medal_time", payload.data.readLong());
                    case NETHERITE_MEDAL_TIME -> extra.set("netherite_medal_time", payload.data.readLong());
                    case BRONZE_MEDAL_OBTAINED_PERCENTAGE -> extra.set("bronze_medal_obtained_percentage", payload.data.readFloat());
                    case SILVER_MEDAL_OBTAINED_PERCENTAGE -> extra.set("silver_medal_obtained_percentage", payload.data.readFloat());
                    case GOLD_MEDAL_OBTAINED_PERCENTAGE -> extra.set("gold_medal_obtained_percentage", payload.data.readFloat());
                    case DIAMOND_MEDAL_OBTAINED_PERCENTAGE -> extra.set("diamond_medal_obtained_percentage", payload.data.readFloat());
                    case NETHERITE_MEDAL_OBTAINED_PERCENTAGE -> extra.set("netherite_medal_obtained_percentage", payload.data.readFloat());
                    case ATTEMPTS -> extra.set("attempts", payload.data.readInt());
                    case COMPLETIONS -> extra.set("completions", payload.data.readInt());
                    case TIME_SPENT_MS -> extra.set("time_spent_ms", payload.data.readLong());
                    case SESSION_ATTEMPTS -> extra.set("session_attempts", payload.data.readInt());
                    case SESSION_COMPLETIONS -> extra.set("session_completions", payload.data.readInt());
                    case SESSION_TIME_SPENT_MS -> extra.set("session_time_spent_ms", payload.data.readLong());
                    case TOTAL_CHECKPOINTS -> extra.set("total_checkpoints", payload.data.readInt());
                    case POSITION_PERCENTAGE -> extra.set("position_percentage", payload.data.readFloat());
                }
            }

            BbBoatHudClient.LUA_SCOREBOARD.set("extra", extra);
        }
        else if(packetType == 2){
            long playerUuidMostSig = payload.data.readLong();
            long playerUuidLeastSig = payload.data.readLong();

            UUID playerUuid = new UUID(playerUuidMostSig, playerUuidLeastSig);

            byte[] bytes = new byte[ScoreboardModDataTypes.STRING_16.getByteSize()];
            payload.data.readBytes(bytes);
            String playerName = new String(bytes, StandardCharsets.UTF_8).trim();
            int teamColor1 = payload.data.readInt();
            int teamColor2 = payload.data.readInt();

            if(!playerName.isEmpty()) {
                ScoreboardPlayerCache scoreboardPlayerCache = new ScoreboardPlayerCache(playerUuid, playerName, teamColor1, teamColor2);
                BbBoatHudClient.PLAYER_NAME_CACHE.put(playerUuid, scoreboardPlayerCache);

                if(BbBoatHudClient.LUA_SCOREBOARD != null) {
                    var luaScoreboardRows = BbBoatHudClient.LUA_SCOREBOARD.get("rows");

                    if(luaScoreboardRows != null){
                        for(var k : ((LuaTable)luaScoreboardRows).keys()){
                            LuaValue playerUuidLua = luaScoreboardRows.get(k).get("player_uuid");

                            if(playerUuidLua != null && playerUuidLua.toString().equals(playerUuid.toString())){
                                luaScoreboardRows.get(k).set("player_name", scoreboardPlayerCache.name());
                                luaScoreboardRows.get(k).set("team_color_1", scoreboardPlayerCache.teamColor1());
                                luaScoreboardRows.get(k).set("team_color_2", scoreboardPlayerCache.teamColor2());
                            }
                        }
                    }
                }
            }
            else {
                BbBoatHudClient.PLAYER_NAME_CACHE.remove(playerUuid);
            }
        }
        else {
            throw new RuntimeException("Unknown packet type: " + packetType);
        }
    }
}