runOutOfBoat = true;
hookTimingSystemScoreboardForRaces = true;
hookTimingSystemScoreboardForTimeTrials = true;

local scoreboardSections = {}

local width = 200

function msToTime(ms)
    local seconds = math.floor(ms / 1000)
    local milliseconds = ms % 1000

    local hours = math.floor(seconds / 3600)
    local minutes = math.floor((seconds % 3600) / 60)
    local secs = seconds % 60

    if hours > 0 then
        return string.format("%d:%02d:%02d.%03d", hours, minutes, secs, milliseconds)
    elseif minutes > 0 then
        return string.format("%d:%02d.%03d", minutes, secs, milliseconds)
    else
        return string.format("%d.%03d", secs, milliseconds)
    end
end

function getMedalIcon(medalName)
    if medalName == "Bronze" then
        return "ለ"
    elseif medalName == "Silver" then
        return "ሉ"
    elseif medalName == "Gold" then
        return "ሐ"
    elseif medalName == "Diamond" then
        return "ሑ"
    elseif medalName == "Netherite" then
        return "ሒ"
    else
        return "ሇ"
    end
end

function generateTitleSection()
    if timingSystemScoreboard["extra"]["main_title"] then
        local section = {
            height = 11,
            funcs = {},
            background_color = 0xAA772222
        }

        table.insert(section.funcs, function()
            offsetPosition(2, 2, function()
                renderText(
                    "§l" .. timingSystemScoreboard["extra"]["main_title"],
                    0xFFFFFF00,
                    false,
                    "TOP_LEFT"
                )
            end)
        end)

        if timingSystemScoreboard["extra"]["sub_title"] then
            section["height"] = section["height"] + 11

            table.insert(section.funcs, function()
                offsetPosition(2, 12, function()
                    renderText(
                        timingSystemScoreboard["extra"]["sub_title"],
                        0xFFDDCCFF,
                        false,
                        "TOP_LEFT"
                    )
                end)
            end)
        end

        table.insert(scoreboardSections, section)
    end
end

function generateTtLeaderboard()
    local myPosition = -1
    local myTime = -1
    local myCheckpoints = -1
    if #timingSystemScoreboard.rows > 0 then
        -- Times

        for k, v in pairs(timingSystemScoreboard.rows) do
            if v.player_name == playerName then
                myPosition = v.position
                myTime = v.tt_time
                myCheckpoints = v.checkpoints
            end
        end

        if true then
            -- Section for top times
            local section = {
                height = 0,
                funcs = {},
                background_color = 0xAA777722
            }

            for k, v in pairs(timingSystemScoreboard.rows) do
                if v.position >= 1 and v.position <= 3 then
                    section.height = section.height + 11

                    table.insert(section.funcs, function()
                        offsetPosition(20, 2 + (v.position - 1) * 11, function()
                            renderText(
                                v.position,
                                0xFFFFFFFF,
                                false,
                                "TOP_RIGHT"
                            )

                            offsetPosition(50, 0, function()
                                renderText(
                                    msToTime(v.tt_time),
                                    0xFFFFFFFF,
                                    false,
                                    "TOP_RIGHT"
                                )
                            end)

                            offsetPosition(55, 0, function()
                                renderText("§l§o|", v.team_color_1 + 2852126720, false, "TOP_LEFT");
                            end)

                            offsetPosition(58, 0, function()
                                if v.team_color_2 == -1 then
                                    v.team_color_2 = v.team_color_1
                                end
                                renderText("§l§o|", v.team_color_2 + 2852126720, false, "TOP_LEFT");
                            end)

                            offsetPosition(67, 0, function()
                                offsetScale(0.5, 0.5, function()
                                    renderPlayerHead(v.player_uuid, "TOP_LEFT");
                                end)
                            end)

                            offsetPosition(79, 0, function()
                                renderText(
                                    v.player_name,
                                    0xFFFFFFFF,
                                    false,
                                    "TOP_LEFT"
                                )
                            end)

                            if
                                v.checkpoints ~= nil and
                                timingSystemScoreboard.extra.total_checkpoints ~= nil and
                                v.checkpoints < timingSystemScoreboard.extra.total_checkpoints
                            then
                                offsetPosition(178, 2, function()
                                    offsetScale(0.5, 0.5, function()
                                        renderText(
                                            v.checkpoints .. "/" .. timingSystemScoreboard.extra.total_checkpoints .. " CKPTs",
                                            0xFFFFFFFF,
                                            false,
                                            "TOP_RIGHT"
                                        )
                                    end)
                                end)
                            end
                        end)
                    end)
                end
            end

            table.insert(scoreboardSections, section)
        end

        if myPosition > 3 then
            -- Section for times around me

            local section = {
                height = 0,
                funcs = {},
                background_color = 0xAA222277
            }

            for k, v in pairs(timingSystemScoreboard.rows) do
                if v.position > 3 and v.position >= myPosition - 2 and v.position <= myPosition + 2 then
                    section.height = section.height + 11

                    table.insert(section.funcs, function()
                        local yOffset = 2 + (v.position - myPosition + 2) * 11;

                        if myPosition == 4 or myPosition == 5 then
                            yOffset = 2 + (v.position - 4) * 11;
                        end

                        offsetPosition(20, yOffset, function()
                            renderText(
                                v.position,
                                0xFFFFFFFF,
                                false,
                                "TOP_RIGHT"
                            )

                            offsetPosition(50, 0, function()
                                renderText(
                                    msToTime(v.tt_time),
                                    0xFFFFFFFF,
                                    false,
                                    "TOP_RIGHT"
                                )
                            end)

                            offsetPosition(55, 0, function()
                                renderText("§l§o|", v.team_color_1 + 2852126720, false, "TOP_LEFT");
                            end)

                            offsetPosition(58, 0, function()
                                if v.team_color_2 == -1 then
                                    v.team_color_2 = v.team_color_1
                                end
                                renderText("§l§o|", v.team_color_2 + 2852126720, false, "TOP_LEFT");
                            end)

                            offsetPosition(67, 0, function()
                                offsetScale(0.5, 0.5, function()
                                    renderPlayerHead(v.player_uuid, "TOP_LEFT");
                                end)
                            end)

                            offsetPosition(79, 0, function()
                                renderText(
                                    v.player_name,
                                    0xFFFFFFFF,
                                    false,
                                    "TOP_LEFT"
                                )
                            end)

                            if
                                v.checkpoints ~= nil and
                                timingSystemScoreboard.extra.total_checkpoints ~= nil and
                                v.checkpoints < timingSystemScoreboard.extra.total_checkpoints
                            then
                                offsetPosition(178, 2, function()
                                    offsetScale(0.5, 0.5, function()
                                        renderText(
                                            v.checkpoints .. "/" .. timingSystemScoreboard.extra.total_checkpoints .. " CKPTs",
                                            0xFFFFFFFF,
                                            false,
                                            "TOP_RIGHT"
                                        )
                                    end)
                                end)
                            end
                        end)
                    end)
                end
            end

            table.insert(scoreboardSections, section)
        end
    else
        local section = {
            height = 11,
            funcs = {},
            background_color = 0xAACCCC00
        }

        table.insert(section.funcs, function()
            offsetPosition(2, 2, function()
                renderText(
                    "No times set",
                    0xFF999999,
                    false,
                    "TOP_LEFT"
                )
            end)
        end)

        table.insert(scoreboardSections, section)
    end

    if
        timingSystemScoreboard.extra.bronze_medal_time or
        timingSystemScoreboard.extra.silver_medal_time or
        timingSystemScoreboard.extra.gold_medal_time or
        timingSystemScoreboard.extra.diamond_medal_time or
        timingSystemScoreboard.extra.netherite_medal_time or
        (timingSystemScoreboard.extra.position_percentage and timingSystemScoreboard.extra.position_percentage >= 0)
    then
        if myPosition == -1 then
            -- show all medals

            local section = {
                height = 12,
                funcs = {},
                background_color = 0xAA227722
            }

            table.insert(section.funcs, function()
                offsetPosition(2, 2, function()
                    renderText(
                        "§lMedals",
                        0xFFFFFF00,
                        false,
                        "TOP_LEFT"
                    )
                end)
            end)

            local yOffset = 2;

            if timingSystemScoreboard.extra.bronze_medal_time then
                yOffset = yOffset + 11;
                local yo = yOffset;
                section["height"] = section["height"] + 11;

                table.insert(section.funcs, function()
                    offsetPosition(2, yo, function()
                        renderBoatLabsText(
                            getMedalIcon("Bronze"),
                            0xFFFFFFFF,
                            false,
                            "TOP_LEFT"
                        )
                    end)

                    offsetPosition(50, yo, function()
                        renderText(
                            msToTime(timingSystemScoreboard.extra.bronze_medal_time),
                            0xFFFFFFFF,
                            false,
                            "TOP_LEFT"
                        )
                    end)

                    offsetPosition(100, yo, function()
                        renderText(
                            tostring(timingSystemScoreboard.extra.bronze_medal_obtained_percentage) .. "%",
                            0xFFFFFFFF,
                            false,
                            "TOP_LEFT"
                        )
                    end)
                end)
            end

            if timingSystemScoreboard.extra.silver_medal_time then
                yOffset = yOffset + 11;
                local yo = yOffset;
                section["height"] = section["height"] + 11;

                table.insert(section.funcs, function()
                    offsetPosition(2, yo, function()
                        renderBoatLabsText(
                            getMedalIcon("Silver"),
                            0xFFFFFFFF,
                            false,
                            "TOP_LEFT"
                        )
                    end)

                    offsetPosition(50, yo, function()
                        renderText(
                            msToTime(timingSystemScoreboard.extra.silver_medal_time),
                            0xFFFFFFFF,
                            false,
                            "TOP_LEFT"
                        )
                    end)

                    offsetPosition(100, yo, function()
                        renderText(
                            tostring(timingSystemScoreboard.extra.silver_medal_obtained_percentage) .. "%",
                            0xFFFFFFFF,
                            false,
                            "TOP_LEFT"
                        )
                    end)
                end)
            end

            if timingSystemScoreboard.extra.gold_medal_time then
                yOffset = yOffset + 11;
                local yo = yOffset;
                section["height"] = section["height"] + 11;

                table.insert(section.funcs, function()
                    offsetPosition(2, yo, function()
                        renderBoatLabsText(
                            getMedalIcon("Gold"),
                            0xFFFFFFFF,
                            false,
                            "TOP_LEFT"
                        )
                    end)

                    offsetPosition(50, yo, function()
                        renderText(
                            msToTime(timingSystemScoreboard.extra.gold_medal_time),
                            0xFFFFFFFF,
                            false,
                            "TOP_LEFT"
                        )
                    end)

                    offsetPosition(100, yo, function()
                        renderText(
                            tostring(timingSystemScoreboard.extra.gold_medal_obtained_percentage) .. "%",
                            0xFFFFFFFF,
                            false,
                            "TOP_LEFT"
                        )
                    end)
                end)
            end

            if timingSystemScoreboard.extra.diamond_medal_time then
                yOffset = yOffset + 11;
                local yo = yOffset;
                section["height"] = section["height"] + 11;

                table.insert(section.funcs, function()
                    offsetPosition(2, yo, function()
                        renderBoatLabsText(
                            getMedalIcon("Diamond"),
                            0xFFFFFFFF,
                            false,
                            "TOP_LEFT"
                        )
                    end)

                    offsetPosition(50, yo, function()
                        renderText(
                            msToTime(timingSystemScoreboard.extra.diamond_medal_time),
                            0xFFFFFFFF,
                            false,
                            "TOP_LEFT"
                        )
                    end)

                    offsetPosition(100, yo, function()
                        renderText(
                            tostring(timingSystemScoreboard.extra.diamond_medal_obtained_percentage) .. "%",
                            0xFFFFFFFF,
                            false,
                            "TOP_LEFT"
                        )
                    end)
                end)
            end

            if timingSystemScoreboard.extra.netherite_medal_time then
                yOffset = yOffset + 11;
                local yo = yOffset;
                section["height"] = section["height"] + 11;

                table.insert(section.funcs, function()
                    offsetPosition(2, yo, function()
                        renderBoatLabsText(
                            getMedalIcon("Netherite"),
                            0xFFFFFFFF,
                            false,
                            "TOP_LEFT"
                        )
                    end)

                    offsetPosition(50, yo, function()
                        renderText(
                            msToTime(timingSystemScoreboard.extra.netherite_medal_time),
                            0xFFFFFFFF,
                            false,
                            "TOP_LEFT"
                        )
                    end)

                    offsetPosition(100, yo, function()
                        renderText(
                            tostring(timingSystemScoreboard.extra.netherite_medal_obtained_percentage) .. "%",
                            0xFFFFFFFF,
                            false,
                            "TOP_LEFT"
                        )
                    end)
                end)
            end

            table.insert(scoreboardSections, section)
        elseif myTime > 0 and myCheckpoints == timingSystemScoreboard.extra.total_checkpoints then
            -- show next medal

            local currentMedal = "None";

            if timingSystemScoreboard.extra.bronze_medal_time and myTime <= timingSystemScoreboard.extra.bronze_medal_time then
                currentMedal = "Bronze"
            end

            if timingSystemScoreboard.extra.silver_medal_time and myTime <= timingSystemScoreboard.extra.silver_medal_time then
                currentMedal = "Silver"
            end

            if timingSystemScoreboard.extra.gold_medal_time and myTime <= timingSystemScoreboard.extra.gold_medal_time then
                currentMedal = "Gold"
            end

            if timingSystemScoreboard.extra.diamond_medal_time and myTime <= timingSystemScoreboard.extra.diamond_medal_time then
                currentMedal = "Diamond"
            end

            if timingSystemScoreboard.extra.netherite_medal_time and myTime <= timingSystemScoreboard.extra.netherite_medal_time then
                currentMedal = "Netherite"
            end

            local nextMedal = "None";
            local nextMedalTime = -1;

            if timingSystemScoreboard.extra.netherite_medal_time and myTime > timingSystemScoreboard.extra.netherite_medal_time then
                nextMedal = "Netherite"
                nextMedalTime = timingSystemScoreboard.extra.netherite_medal_time
            end

            if timingSystemScoreboard.extra.diamond_medal_time and myTime > timingSystemScoreboard.extra.diamond_medal_time then
                nextMedal = "Diamond"
                nextMedalTime = timingSystemScoreboard.extra.diamond_medal_time
            end

            if timingSystemScoreboard.extra.gold_medal_time and myTime > timingSystemScoreboard.extra.gold_medal_time then
                nextMedal = "Gold"
                nextMedalTime = timingSystemScoreboard.extra.gold_medal_time
            end

            if timingSystemScoreboard.extra.silver_medal_time and myTime > timingSystemScoreboard.extra.silver_medal_time then
                nextMedal = "Silver"
                nextMedalTime = timingSystemScoreboard.extra.silver_medal_time
            end

            if timingSystemScoreboard.extra.bronze_medal_time and myTime > timingSystemScoreboard.extra.bronze_medal_time then
                nextMedal = "Bronze"
                nextMedalTime = timingSystemScoreboard.extra.bronze_medal_time
            end

            if true then
                local section = {
                    height = 12 + 11,
                    funcs = {},
                    background_color = 0xAA227722
                }

                table.insert(section.funcs, function()
                    offsetPosition(2, 2, function()
                        renderText(
                            "§lPersonal Best",
                            0xFFFFFF00,
                            false,
                            "TOP_LEFT"
                        )
                    end)


                    offsetPosition(2, 13, function()
                        if currentMedal ~= "None" then
                            renderBoatLabsText(
                                getMedalIcon(currentMedal),
                                0xFFFFFFFF,
                                false,
                                "TOP_LEFT"
                            )
                        end

                        offsetPosition(68, 0, function()
                            renderText(
                                msToTime(myTime),
                                0xFFFFFFFF,
                                false,
                                "TOP_RIGHT"
                            )
                        end)

                        if nextMedal ~= "None" then
                            offsetPosition(186, 0, function()
                                renderText(
                                    msToTime(myTime - nextMedalTime) .. " from",
                                    0xFFFFFFFF,
                                    false,
                                    "TOP_RIGHT"
                                )
                            end)

                            offsetPosition(188, 0, function()
                                renderBoatLabsText(
                                    getMedalIcon(nextMedal),
                                    0xFFFFFFFF,
                                    false,
                                    "TOP_LEFT"
                                )
                            end)
                        end
                    end)
                end)

                if timingSystemScoreboard.extra.position_percentage then
                    section.height = section.height + 11
                    table.insert(section.funcs, function()
                        offsetPosition(2, 25, function()
                            renderText(
                                "Top " .. timingSystemScoreboard.extra.position_percentage .. "% of all players",
                                0xFFFFFFFF,
                                false,
                                "TOP_LEFT"
                            )
                        end)
                    end)
                end

                table.insert(scoreboardSections, section)
            end
        end
    end

    if true then
        -- Stats
        local section = {
            height = 12 + 11,
            funcs = {},
            background_color = 0xAA772277
        }

        table.insert(section.funcs, function()
            offsetPosition(2, 2, function()
                renderText(
                    "§lOverall Stats",
                    0xFFFFFF00,
                    false,
                    "TOP_LEFT"
                )
            end)

            offsetPosition(55, 13, function()
                renderText(
                    msToTime(timingSystemScoreboard.extra.time_spent_ms),
                    0xFFFFFFFF,
                    false,
                    "TOP_RIGHT"
                )
                offsetPosition(2, 0, function()
                    renderBoatLabsText(
                        "Ⴀ",
                        0xFFFFFFFF,
                        false,
                        "TOP_LEFT"
                    )
                end)
            end)

            offsetPosition(110, 13, function()
                renderText(
                    timingSystemScoreboard.extra.completions,
                    0xFFFFFFFF,
                    false,
                    "TOP_RIGHT"
                )
                offsetPosition(2, 0, function()
                    renderBoatLabsText(
                        "Ⴂ",
                        0xFFFFFFFF,
                        false,
                        "TOP_LEFT"
                    )
                end)
            end)

            offsetPosition(180, 13, function()
                renderText(
                    timingSystemScoreboard.extra.attempts,
                    0xFFFFFFFF,
                    false,
                    "TOP_RIGHT"
                )
                offsetPosition(2, 0, function()
                    renderBoatLabsText(
                        "Ⴁ",
                        0xFFFFFFFF,
                        false,
                        "TOP_LEFT"
                    )
                end)
            end)
        end)

        table.insert(scoreboardSections, section)
    end
end

function generateRaceLeaderboard()
    if #timingSystemScoreboard.rows > 0 then
        local section = {
            height = 0,
            funcs = {},
            background_color = 0xAA777722
        }

        local myPosition = 0;
        local myTimeFromLead = 0;

        for k, v in pairs(timingSystemScoreboard.rows) do
            if v.player_name == playerName then
                myTimeFromLead = v.time_diff_from_first_ms
            end
        end

        for k, v in pairs(timingSystemScoreboard.rows) do
            section.height = section.height + 11

            table.insert(section.funcs, function()
                offsetPosition(20, 2 + (v.position - 1) * 11, function()
                    renderText(
                        v.position,
                        0xFFFFFFFF,
                        false,
                        "TOP_RIGHT"
                    )

                    offsetPosition(50, 0, function()
                        local timeDiff = math.abs(myTimeFromLead - v.time_diff_from_first_ms);

                        local color = 0xFFFFFFFF;
                        if v.position > myPosition then
                            color = 0xFF00FF00;
                        elseif v.position > myPosition then
                            color = 0xFFFF0000;
                        end

                        renderText(
                            msToTime(timeDiff),
                            0xFFFFFFFF,
                            false,
                            "TOP_RIGHT"
                        )
                    end)

                    offsetPosition(55, 0, function()
                        renderText("§l§o|", v.team_color_1 + 2852126720, false, "TOP_LEFT");
                    end)

                    offsetPosition(58, 0, function()
                        if v.team_color_2 == -1 then
                            v.team_color_2 = v.team_color_1
                        end
                        renderText("§l§o|", v.team_color_2 + 2852126720, false, "TOP_LEFT");
                    end)

                    offsetPosition(67, 0, function()
                        renderText(
                            v.player_name,
                            0xFFFFFFFF,
                            false,
                            "TOP_LEFT"
                        )
                    end)
                end)
            end)
        end

        table.insert(scoreboardSections, section)
    end
end

if timingSystemScoreboard["rows"] and timingSystemScoreboard["extra"] then
    generateTitleSection()
    if timingSystemScoreboard.extra.attempts then
        generateTtLeaderboard()
    end
    if timingSystemScoreboard.extra.total_laps then
        generateRaceLeaderboard()
    end
elseif editorMode then
    table.insert(scoreboardSections, {
        height = 300,
        funcs = {},
        background_color = 0xAACCCC00
    });
end

local yOffset = 0
for k, v in pairs(scoreboardSections) do
    offsetPosition(0, yOffset, function()
    renderRect(width, v.height, v.background_color, "TOP_LEFT")
        for k2, v2 in pairs(v.funcs) do
            v2()
        end
    end)
    yOffset = yOffset + v.height + 2
end
