/*
 * Decompiled with CFR 0.152.
 */
package systems.brn.textvoice.client;

import java.util.Arrays;

public class SafeBMPCodec {
    private static final int OFFSET = 168;
    private static final int BITS_PER_CHAR = 15;

    public static String encode(byte[] data) {
        StringBuilder sb = new StringBuilder();
        int bitBuffer = 0;
        int bitCount = 0;
        for (byte b : data) {
            bitBuffer = bitBuffer << 8 | b & 0xFF;
            bitCount += 8;
            while (bitCount >= 15) {
                int value = bitBuffer >> (bitCount -= 15) & Short.MAX_VALUE;
                sb.append((char)(value + 168));
            }
        }
        if (bitCount > 0) {
            int value = bitBuffer << 15 - bitCount & Short.MAX_VALUE;
            sb.append((char)(value + 168));
        }
        return sb.toString();
    }

    public static byte[] decode(String s) {
        int bitBuffer = 0;
        int bitCount = 0;
        byte[] temp = new byte[s.length() * 2];
        int pos = 0;
        for (int i = 0; i < s.length(); ++i) {
            int value = s.charAt(i) - 168;
            bitBuffer = bitBuffer << 15 | value & Short.MAX_VALUE;
            bitCount += 15;
            while (bitCount >= 8) {
                temp[pos++] = (byte)(bitBuffer >> (bitCount -= 8) & 0xFF);
            }
        }
        return Arrays.copyOf(temp, pos);
    }
}

