/*
 * Decompiled with CFR 0.152.
 */
package systems.brn.textvoice.client;

import com.mojang.authlib.GameProfile;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import net.minecraft.class_7471;
import org.jetbrains.annotations.Nullable;
import systems.brn.textvoice.client.Codec2Wrapper;
import systems.brn.textvoice.client.PlayerAudioMixer;
import systems.brn.textvoice.client.PlayerHUDState;
import systems.brn.textvoice.client.PlayerReceiveBuffer;
import systems.brn.textvoice.client.SafeBMPCodec;

public class TextVoiceHandler {
    public static final char START_MARKER = '\ud7f0';
    public static final char END_MARKER = '\ud7f1';
    public static final char PTT_PLAY_MARKER = '\ud7f3';
    public static final int MAX_ENCODED_LEN = 236;
    public final PlayerAudioMixer mixer;
    public final List<short[]> pttSendBuffer = new ArrayList<short[]>();
    public final Map<String, PlayerReceiveBuffer> receiveBuffers;
    private final Map<String, PlayerHUDState> hudStates;
    private volatile boolean pttActive = false;
    private final Object pttLock = new Object();
    public String targetPlayer = null;
    public final Codec2Wrapper codec2Encode = new Codec2Wrapper(0);
    private final Map<String, Codec2Wrapper> playerDecoders = new ConcurrentHashMap<String, Codec2Wrapper>();
    private long lastSentTime = 0L;
    private int messagesSent = 0;

    public TextVoiceHandler(PlayerAudioMixer mixer, Map<String, PlayerReceiveBuffer> receiveBuffers, Map<String, PlayerHUDState> hudStates) {
        this.mixer = mixer;
        this.receiveBuffers = receiveBuffers;
        this.hudStates = hudStates;
    }

    public void startPTT() {
        this.pttActive = true;
        new Thread(this::pttSendLoop, "Voice-PTT-Sender").start();
    }

    public void stopPTT() {
        this.pttActive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pttSendLoop() {
        ArrayList<byte[]> pendingFrames = new ArrayList<byte[]>();
        while (this.pttActive || !this.pttSendBuffer.isEmpty() || !pendingFrames.isEmpty()) {
            Object object = this.pttLock;
            synchronized (object) {
                if (!this.pttSendBuffer.isEmpty()) {
                    for (short[] pcm : this.pttSendBuffer) {
                        pendingFrames.add(this.codec2Encode.encodeFrame(this.codec2Encode.handle, pcm));
                    }
                    this.pttSendBuffer.clear();
                }
            }
            if (!pendingFrames.isEmpty()) {
                int bundleCharCount = 0;
                ArrayList<byte[]> bundle = new ArrayList<byte[]>();
                Iterator iter = pendingFrames.iterator();
                while (iter.hasNext()) {
                    byte[] frame = (byte[])iter.next();
                    String encodedFrame = SafeBMPCodec.encode(frame);
                    int actualLen = encodedFrame.length();
                    if (bundleCharCount + actualLen > 236) {
                        this.sendBundle(bundle);
                        bundle.clear();
                        bundleCharCount = 0;
                    }
                    bundle.add(frame);
                    bundleCharCount += actualLen;
                    iter.remove();
                }
                if (!bundle.isEmpty() && !this.pttActive) {
                    this.sendBundle(bundle);
                } else {
                    pendingFrames.addAll(bundle);
                }
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.sendPTTPlaySignal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferPCM(short[] pcmSamples) {
        List<short[]> list = this.pttSendBuffer;
        synchronized (list) {
            this.pttSendBuffer.add(pcmSamples);
        }
    }

    private void sendBundle(List<byte[]> codec2Frames) {
        if (codec2Frames.isEmpty()) {
            return;
        }
        int total = codec2Frames.size() * 8;
        byte[] blob = new byte[total];
        int pos = 0;
        for (byte[] frame : codec2Frames) {
            System.arraycopy(frame, 0, blob, pos, 8);
            pos += 8;
        }
        String encoded = SafeBMPCodec.encode(blob);
        String wrapped = "\ud7f0" + encoded + "\ud7f1";
        this.sendChatMessage(wrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onChatMessage(class_2561 message, @Nullable class_7471 signedMessage, @Nullable GameProfile sender, class_2556.class_7602 params, Instant timestamp) {
        UUID myUUID;
        UUID senderUUID;
        class_7417 class_74172 = message.method_10851();
        if (!(class_74172 instanceof class_2588)) {
            return true;
        }
        class_2588 content = (class_2588)class_74172;
        String messageContent = content.method_29434(1).getString();
        String playerName = content.method_29434(0).getString();
        if (messageContent.startsWith(String.valueOf('\ud7f3'))) {
            PlayerReceiveBuffer buffer;
            if (sender != null && (buffer = this.receiveBuffers.get(sender.getName())) != null) {
                buffer.playOnRelease = true;
                this.playReceiveBuffer(sender.getName(), buffer);
            }
            return false;
        }
        if (!messageContent.startsWith(String.valueOf('\ud7f0')) || !messageContent.endsWith(String.valueOf('\ud7f1'))) {
            return true;
        }
        if (sender != null && (senderUUID = sender.getId()).equals(myUUID = class_310.method_1551().method_53462().getId())) {
            return false;
        }
        try {
            String stripped = messageContent.substring(1, messageContent.length() - 1);
            PlayerReceiveBuffer buffer = this.receiveBuffers.computeIfAbsent(playerName, k -> new PlayerReceiveBuffer());
            PlayerHUDState hud = this.hudStates.computeIfAbsent(playerName, k -> new PlayerHUDState());
            hud.lastFrameTime = System.currentTimeMillis();
            byte[] blob = SafeBMPCodec.decode(stripped);
            for (int i = 0; i < blob.length; i += 8) {
                byte[] codec2Frame = Arrays.copyOfRange(blob, i, i + 8);
                Codec2Wrapper codec2 = this.playerDecoders.computeIfAbsent(playerName, k -> new Codec2Wrapper(0));
                short[] pcm = codec2.decodeFrame(codec2.handle, codec2Frame);
                List<short[]> list = buffer.buffer;
                synchronized (list) {
                    buffer.buffer.add(pcm);
                    continue;
                }
            }
            if (buffer.playOnRelease) {
                this.playReceiveBuffer(playerName, buffer);
            }
        }
        catch (Exception e) {
            class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"gui.textvoice.errordecode", (Object[])new Object[]{playerName, e}));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playReceiveBuffer(String playerName, PlayerReceiveBuffer buffer) {
        PlayerHUDState hud = this.hudStates.computeIfAbsent(playerName, k -> new PlayerHUDState());
        int totalSamples = buffer.buffer.stream().mapToInt(f -> ((short[])f).length).sum();
        hud.playingTo = hud.playingTo <= System.currentTimeMillis() ? System.currentTimeMillis() + (long)(totalSamples / 8) : (hud.playingTo += (long)(totalSamples / 8));
        List<short[]> list = buffer.buffer;
        synchronized (list) {
            for (short[] pcm : buffer.buffer) {
                this.mixer.enqueuePlayerFrame(playerName, pcm);
            }
            buffer.buffer.clear();
            buffer.playOnRelease = false;
        }
    }

    private void sendPTTPlaySignal() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        String control = "\ud7f3" + (this.targetPlayer != null ? this.targetPlayer : "");
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.sendChatMessage(control);
    }

    private void sendChatMessage(String msg) {
        if (this.targetPlayer == null || this.targetPlayer.isBlank()) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        long now = System.currentTimeMillis();
        double frequency = this.lastSentTime > 0L ? 1000.0 / (double)(now - this.lastSentTime) : 0.0;
        this.lastSentTime = now;
        ++this.messagesSent;
        System.out.printf("[textvoice] Sending #%d: freq=%.2f Hz, target=%s, chars=%d%n", this.messagesSent, frequency, this.targetPlayer, msg.length());
        if (!Objects.equals(this.targetPlayer, "*")) {
            String whisper = "w " + this.targetPlayer + " " + msg;
            player.field_3944.method_45730(whisper);
        } else {
            player.field_3944.method_45729(msg);
        }
    }

    public void setTargetPlayer(@Nullable String name) {
        this.targetPlayer = name != null && name.length() <= 16 ? name : null;
    }
}

