/*
 * Decompiled with CFR 0.152.
 */
package systems.brn.textvoice.client.audio;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class Microphone {
    private final int sampleRate;
    private final int frameSize;
    private TargetDataLine line;
    private Mixer.Info currentMixer;

    public Microphone(int sampleRate, int frameSize) {
        this.sampleRate = sampleRate;
        this.frameSize = frameSize;
    }

    public void open(Mixer.Info mixerInfo) throws LineUnavailableException {
        this.close();
        this.currentMixer = mixerInfo;
        AudioFormat format = new AudioFormat(this.sampleRate, 16, 1, true, false);
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
        this.line = (TargetDataLine)AudioSystem.getLine(info);
        if (mixerInfo != null) {
            this.line = (TargetDataLine)AudioSystem.getMixer(mixerInfo).getLine(info);
        }
        this.line.open(format, this.frameSize * 2);
        this.line.start();
    }

    public short[] readFrame() {
        if (this.line == null) {
            return new short[0];
        }
        byte[] buffer = new byte[this.frameSize * 2];
        int bytesRead = this.line.read(buffer, 0, buffer.length);
        short[] pcm = new short[bytesRead / 2];
        for (int i = 0; i < pcm.length; ++i) {
            int lo = buffer[i * 2] & 0xFF;
            int hi = buffer[i * 2 + 1] << 8;
            pcm[i] = (short)(hi | lo);
        }
        return pcm;
    }

    public void close() {
        if (this.line != null) {
            this.line.stop();
            this.line.close();
            this.line = null;
        }
    }

    public void setDevice(Mixer.Info mixerInfo) throws LineUnavailableException {
        this.open(mixerInfo);
    }

    public Mixer.Info getCurrentMixer() {
        return this.currentMixer;
    }
}

